/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.ToBeBuiltComputer;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

public class ProjectOpenedOrClosedListener
implements IResourceChangeListener {
    private static final Logger log = Logger.getLogger(ProjectOpenedOrClosedListener.class);
    private static boolean reflectErrorLogged = false;
    @Inject
    private ToBeBuiltComputer toBeBuiltComputer;
    @Inject
    private IBuilderState builderState;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private BuildScheduler buildScheduler;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IWorkspace workspace;

    public IResourceSetProvider getResourceSetProvider() {
        return this.resourceSetProvider;
    }

    public ToBeBuiltComputer getToBeBuiltComputer() {
        return this.toBeBuiltComputer;
    }

    public IBuilderState getBuilderState() {
        return this.builderState;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.workspace != null && this.workspace.isAutoBuilding()) {
            if (event.getType() == 1) {
                try {
                    final LinkedHashSet toUpdate = Sets.newLinkedHashSet();
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta.getResource() instanceof IWorkspaceRoot) {
                                return true;
                            }
                            if (delta.getResource() instanceof IProject) {
                                IProject project = (IProject)delta.getResource();
                                if ((delta.getKind() & 4) != 0 && project.isOpen()) {
                                    if ((delta.getFlags() & 0x4000) != 0) {
                                        toUpdate.add(project);
                                    }
                                    if ((delta.getFlags() & 0x80000) != 0) {
                                        if (delta.findMember((IPath)new Path(".project")) != null && XtextProjectHelper.hasNature((IProject)project) && XtextProjectHelper.hasBuilder((IProject)project)) {
                                            toUpdate.add(project);
                                        } else if (!XtextProjectHelper.hasNature((IProject)project)) {
                                            ProjectOpenedOrClosedListener.this.scheduleRemoveProjectJobIfNecessary(project, delta);
                                        }
                                    }
                                }
                            }
                            return false;
                        }
                    });
                    this.buildScheduler.scheduleBuildIfNecessary(toUpdate, IBuildFlag.FORGET_BUILD_STATE_ONLY);
                }
                catch (CoreException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if ((event.getType() == 2 || event.getType() == 4) && event.getResource() instanceof IProject && (XtextProjectHelper.hasNature((IProject)((IProject)event.getResource())) || event.getResource().isAccessible() && event.getResource().isHidden())) {
                this.scheduleRemoveProjectJob((IProject)event.getResource());
            }
        }
    }

    protected void scheduleRemoveProjectJob(final IProject project) {
        final ToBeBuilt toBeBuilt = this.getToBeBuiltComputer().removeProject(project, (IProgressMonitor)new NullProgressMonitor());
        if (toBeBuilt.getToBeDeleted().isEmpty() && toBeBuilt.getToBeUpdated().isEmpty()) {
            return;
        }
        new Job(String.valueOf(Messages.ProjectOpenedOrClosedListener_RemovingProject) + project.getName() + Messages.ProjectOpenedOrClosedListener_FromIndex){
            {
                super($anonymous0);
                this.setRule((ISchedulingRule)ProjectOpenedOrClosedListener.this.workspace.getRoot());
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new WorkspaceModifyOperation(this.getRule()){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                            try {
                                try {
                                    ResourceSet resourceSet = ProjectOpenedOrClosedListener.this.getResourceSetProvider().get(project);
                                    resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
                                    if (resourceSet instanceof ResourceSetImpl) {
                                        ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
                                    }
                                    BuildData buildData = new BuildData(project.getName(), resourceSet, toBeBuilt, ProjectOpenedOrClosedListener.this.queuedBuildData);
                                    ProjectOpenedOrClosedListener.this.getBuilderState().update(buildData, (IProgressMonitor)progress.newChild(1));
                                    resourceSet.getResources().clear();
                                    resourceSet.eAdapters().clear();
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    throw new InterruptedException();
                                }
                            }
                            finally {
                                if (monitor != null) {
                                    monitor.done();
                                }
                            }
                        }
                    }.run(monitor);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void scheduleRemoveProjectJobIfNecessary(IProject project, IResourceDelta delta) {
        try {
            ReflectExtensions reflector = new ReflectExtensions();
            Object oldInfo = reflector.get((Object)delta, "oldInfo");
            Map natures = (Map)reflector.get(oldInfo, "natures");
            if (natures != null && natures.containsKey("org.eclipse.xtext.ui.shared.xtextNature")) {
                this.scheduleRemoveProjectJob(project);
            }
        }
        catch (Exception e) {
            if (!reflectErrorLogged) {
                log.error((Object)"Scheduled unnecessary build due to reflective code failure", (Throwable)e);
                reflectErrorLogged = true;
            }
            this.scheduleRemoveProjectJob(project);
        }
    }
}

