/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.figures;

import java.util.List;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xtext.ui.graph.figures.AbstractSegmentFigure;
import org.eclipse.xtext.xtext.ui.graph.figures.ISegmentFigure;
import org.eclipse.xtext.xtext.ui.graph.figures.layouts.SequenceLayout;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.CrossPoint;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.PrimitiveFigureFactory;

public class SequenceSegment
extends AbstractSegmentFigure {
    public SequenceSegment(EObject eObject, List<ISegmentFigure> body, PrimitiveFigureFactory primitiveFactory) {
        super(eObject);
        if (body.isEmpty()) {
            this.setEntry(primitiveFactory.createCrossPoint(this));
            this.setExit(this.getEntry());
        } else {
            boolean isFirst = true;
            CrossPoint currentEnd = null;
            for (ISegmentFigure child : body) {
                if (isFirst) {
                    this.setEntry(child.getEntry());
                    isFirst = false;
                } else {
                    primitiveFactory.createConnection(currentEnd, child.getEntry(), this);
                }
                this.add(child);
                currentEnd = child.getExit();
            }
            this.setExit(currentEnd);
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SequenceLayout();
    }
}

