/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationTargetImpl;
import org.eclipse.xtend.core.macro.declaration.TypeLookupImpl;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Modifier;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceProvider;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.impl.JvmMemberImplCustom;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public abstract class JvmMemberDeclarationImpl<T extends JvmMember>
extends JvmAnnotationTargetImpl<T>
implements MemberDeclaration {
    public String getDocComment() {
        JvmMember _delegate = (JvmMember)this.getDelegate();
        EList _eAdapters = _delegate.eAdapters();
        Adapter _adapter = EcoreUtil.getAdapter((List)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = (DocumentationAdapter)_adapter;
        String _documentation = null;
        if (adapter != null) {
            _documentation = adapter.getDocumentation();
        }
        return _documentation;
    }

    public void setDocComment(String docComment) {
        this.checkMutable();
        JvmMember _delegate = (JvmMember)this.getDelegate();
        EList _eAdapters = _delegate.eAdapters();
        Adapter _adapter = EcoreUtil.getAdapter((List)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = (DocumentationAdapter)_adapter;
        boolean _equals = Objects.equal((Object)adapter, null);
        if (_equals) {
            DocumentationAdapter _documentationAdapter;
            adapter = _documentationAdapter = new DocumentationAdapter();
            JvmMember _delegate_1 = (JvmMember)this.getDelegate();
            EList _eAdapters_1 = _delegate_1.eAdapters();
            _eAdapters_1.add((Object)adapter);
        }
        adapter.setDocumentation(docComment);
    }

    public Visibility getVisibility() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmMember _delegate = (JvmMember)this.getDelegate();
        JvmVisibility _visibility = _delegate.getVisibility();
        return _compilationUnit.toVisibility(_visibility);
    }

    public void setVisibility(Visibility visibility) {
        this.checkMutable();
        JvmMember _delegate = (JvmMember)this.getDelegate();
        JvmVisibility _switchResult = null;
        if (visibility != null) {
            switch (visibility) {
                case DEFAULT: {
                    _switchResult = JvmVisibility.DEFAULT;
                    break;
                }
                case PUBLIC: {
                    _switchResult = JvmVisibility.PUBLIC;
                    break;
                }
                case PRIVATE: {
                    _switchResult = JvmVisibility.PRIVATE;
                    break;
                }
                case PROTECTED: {
                    _switchResult = JvmVisibility.PROTECTED;
                    break;
                }
            }
        }
        _delegate.setVisibility(_switchResult);
    }

    public TypeDeclaration getDeclaringType() {
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmMember _delegate = (JvmMember)this.getDelegate();
        JvmDeclaredType _declaringType = _delegate.getDeclaringType();
        return _compilationUnit.toTypeDeclaration(_declaringType);
    }

    public void setSimpleName(String name) {
        JvmMember _delegate;
        this.checkMutable();
        ConditionUtils.checkJavaIdentifier(name, "name");
        JvmMember it = _delegate = (JvmMember)this.getDelegate();
        boolean _matched = false;
        if (it instanceof JvmMemberImplCustom) {
            _matched = true;
            ((JvmMemberImplCustom)it).clearIdentifierCache();
        }
        JvmMember _delegate_1 = (JvmMember)this.getDelegate();
        _delegate_1.setSimpleName(name);
    }

    public Set<Modifier> getModifiers() {
        return Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Modifier[0]));
    }

    public boolean isDeprecated() {
        JvmMember _delegate = (JvmMember)this.getDelegate();
        return DeprecationUtil.isDeprecatedMember((JvmMember)_delegate);
    }

    public void setDeprecated(boolean deprecated) {
        this.checkMutable();
        if (deprecated) {
            JvmMember _delegate = (JvmMember)this.getDelegate();
            _delegate.setDeprecated(true);
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            AnnotationReferenceProvider _annotationReferenceProvider = _compilationUnit.getAnnotationReferenceProvider();
            AnnotationReference _newAnnotationReference = _annotationReferenceProvider.newAnnotationReference(Deprecated.class);
            this.addAnnotation(_newAnnotationReference);
        } else {
            boolean _notEquals;
            JvmMember _delegate_1 = (JvmMember)this.getDelegate();
            _delegate_1.setDeprecated(false);
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            TypeLookupImpl _typeLookup = _compilationUnit_1.getTypeLookup();
            Type _findTypeGlobally = _typeLookup.findTypeGlobally(Deprecated.class);
            AnnotationReference existingReference = this.findAnnotation(_findTypeGlobally);
            boolean bl = _notEquals = !Objects.equal((Object)existingReference, null);
            if (_notEquals) {
                this.removeAnnotation(existingReference);
            }
        }
    }
}

