/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.m2e;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.xtext.m2e.XtextProjectConfigurator;

public class BinFolderConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = XtextProjectConfigurator.getProject(request);
        if (this.compileToBin(project)) {
            IPath projectRoot = project.getFullPath();
            IPath binPath = projectRoot.append("bin");
            IPath binTestPath = projectRoot.append("bin-test");
            IJavaProject javaProject = JavaCore.create((IProject)project);
            javaProject.setOutputLocation(binPath, monitor);
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            int i = 0;
            while (i < rawClasspath.length) {
                IClasspathEntry entry = rawClasspath[i];
                if (entry.getEntryKind() == 3) {
                    rawClasspath[i] = this.isTest(entry) ? this.copyWithOutput(entry, binTestPath) : this.copyWithOutput(entry, binPath);
                }
                ++i;
            }
            javaProject.setRawClasspath(rawClasspath, monitor);
        }
    }

    @Deprecated
    private boolean isTest(IClasspathEntry entry) {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("test".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IClasspathEntry copyWithOutput(IClasspathEntry entry, IPath output) {
        return JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)output, (IClasspathAttribute[])entry.getExtraAttributes());
    }

    private boolean compileToBin(IProject project) {
        String pluginId = "org.eclipse.xtext.m2e";
        String key = "compileToBin";
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences projectPreferences = projectScope.getNode(pluginId);
        String value = projectPreferences.get(key, null);
        if (value != null) {
            return "true".equals(value);
        }
        IEclipsePreferences instancePreferences = InstanceScope.INSTANCE.getNode(pluginId);
        return "true".equals(instancePreferences.get(key, "false"));
    }
}

