/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.EmfStandaloneMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.Messages;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelRegistry {
    public static final String MM_POINT_ID = "metamodelProvider";
    private static final MetamodelRegistry ourInstance = new MetamodelRegistry();
    private final Map<String, IMetamodelDesc> myMetamodelDescs;

    private MetamodelRegistry() {
        ArrayList<EmfStandaloneMetamodelProvider> providers = new ArrayList<EmfStandaloneMetamodelProvider>();
        providers.add(new EmfStandaloneMetamodelProvider(EPackage.Registry.INSTANCE));
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            providers.addAll(Eclipse.getMetamodelProviders());
        }
        this.myMetamodelDescs = MetamodelRegistry.getMetamodelDescs(providers);
    }

    public MetamodelRegistry(IMetamodelProvider metamodelProvider) {
        this.myMetamodelDescs = new HashMap<String, IMetamodelDesc>(MetamodelRegistry.ourInstance.myMetamodelDescs);
        this.myMetamodelDescs.putAll(MetamodelRegistry.getMetamodelDescs(Collections.singletonList(metamodelProvider)));
    }

    public EPackage.Registry toEPackageRegistry() {
        EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl();
        String[] stringArray = this.getMetamodelIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nsURI = stringArray[n2];
            try {
                IMetamodelDesc metamodelDesc = this.getMetamodelDesc(nsURI);
                if (metamodelDesc.getLoadStatus().getSeverity() < 4) {
                    packageRegistry.put((Object)nsURI, (Object)new Desc(metamodelDesc));
                }
            }
            catch (EmfException emfException) {
                // empty catch block
            }
            ++n2;
        }
        return packageRegistry;
    }

    public static MetamodelRegistry getInstance() {
        return ourInstance;
    }

    public void merge(MetamodelRegistry mergedRegistry) {
        for (String id : mergedRegistry.myMetamodelDescs.keySet()) {
            if (this.myMetamodelDescs.containsKey(id)) continue;
            this.myMetamodelDescs.put(id, mergedRegistry.myMetamodelDescs.get(id));
        }
    }

    public String[] getMetamodelIds() {
        ArrayList<String> ids = new ArrayList<String>(this.myMetamodelDescs.size());
        ids.addAll(this.myMetamodelDescs.keySet());
        return ids.toArray(new String[ids.size()]);
    }

    public static EPackage tryLookupEmptyRootPackage(String nsURI, EPackage.Registry registry) {
        EPackage pack;
        URI rootURI = URI.createURI((String)nsURI);
        if (rootURI.segmentCount() == 0) {
            return null;
        }
        String base = rootURI.segment(0);
        String commonBaseURI = rootURI.trimSegments(rootURI.segmentCount()).appendSegment(base).toString();
        LinkedList<String> candidates = new LinkedList<String>();
        for (String nextURI : registry.keySet()) {
            if (!nextURI.startsWith(commonBaseURI)) continue;
            candidates.add(nextURI);
        }
        for (String nextNsURI : candidates) {
            pack = registry.getEPackage(nextNsURI);
            while (pack.getESuperPackage() != null) {
                pack = pack.getESuperPackage();
            }
            if (!nsURI.equals(pack.getNsURI())) continue;
            return pack;
        }
        for (String nextNsURI : registry.keySet()) {
            pack = registry.getEPackage(nextNsURI);
            while (pack.getESuperPackage() != null) {
                pack = pack.getESuperPackage();
            }
            if (!nsURI.equals(pack.getNsURI())) continue;
            return pack;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public IMetamodelDesc getMetamodelDesc(String id) throws EmfException {
        block3: {
            desc = this.myMetamodelDescs.get(id);
            if (desc != null || id == null) break block3;
            for (IMetamodelDesc d : this.myMetamodelDescs.values()) {
                pack = d.getModel();
                if (pack == null) continue;
                if (!id.equals(pack.getNsURI())) ** GOTO lbl10
                desc = d;
                break;
lbl-1000:
                // 1 sources

                {
                    pack = pack.getESuperPackage();
lbl10:
                    // 2 sources

                    ** while (pack.getESuperPackage() != null)
                }
lbl11:
                // 1 sources

                if (!id.equals(pack.getNsURI())) continue;
                desc = new EmfMetamodelDesc(pack, pack.getNsURI());
                this.myMetamodelDescs.put(id, desc);
                break;
            }
        }
        if (desc == null) {
            throw new EmfException(NLS.bind((String)Messages.MetamodelRegistry_0, (Object)id, this.myMetamodelDescs.values()));
        }
        return desc;
    }

    public static List<EPackage> resolveMetamodels(EPackage.Registry registry, List<String> packageName) throws EmfException {
        UniqueEList metamodels = new UniqueEList(1);
        for (String nsURI : registry.keySet()) {
            EPackage lookupPackage;
            EPackage pack = registry.getEPackage(nsURI);
            if (pack == null || pack.getESuperPackage() != null || (lookupPackage = MetamodelRegistry.lookupPackage(pack, packageName)) == null) continue;
            metamodels.add(lookupPackage);
        }
        return metamodels;
    }

    public static EPackage lookupPackage(EPackage rootPackage, List<String> path) {
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        registry.put((Object)rootPackage.getNsURI(), (Object)rootPackage);
        return EcoreEnvironment.findPackage(path, (EPackage.Registry)registry);
    }

    private static Map<String, IMetamodelDesc> getMetamodelDescs(List<? extends IMetamodelProvider> providers) {
        HashMap<String, IMetamodelDesc> metamodelDescs = new HashMap<String, IMetamodelDesc>();
        for (IMetamodelProvider iMetamodelProvider : providers) {
            IMetamodelDesc[] models;
            try {
                models = iMetamodelProvider.getMetamodels();
            }
            catch (Throwable e) {
                continue;
            }
            int i = 0;
            while (i < models.length) {
                if (models[i].getId() != null) {
                    metamodelDescs.put(models[i].getId(), models[i]);
                }
                ++i;
            }
        }
        return metamodelDescs;
    }

    private static class Desc
    implements EPackage.Descriptor {
        private final IMetamodelDesc fDesc;

        public Desc(IMetamodelDesc desc) {
            this.fDesc = desc;
        }

        public EFactory getEFactory() {
            return this.fDesc.getModel().getEFactoryInstance();
        }

        public EPackage getEPackage() {
            return this.fDesc.getModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Eclipse {
        private Eclipse() {
        }

        private static List<IMetamodelProvider> getMetamodelProviders() {
            ArrayList<IMetamodelProvider> metamodelProviders = new ArrayList<IMetamodelProvider>();
            IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EmfUtilPlugin.getDefault().getBundle().getSymbolicName(), MetamodelRegistry.MM_POINT_ID);
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement extension = extensions[i];
                try {
                    Object provider = extension.createExecutableExtension("class");
                    if (provider instanceof IMetamodelProvider) {
                        metamodelProviders.add((IMetamodelProvider)provider);
                    }
                }
                catch (CoreException e) {
                    EmfUtilPlugin.getDefault().getLog().log(e.getStatus());
                }
                catch (Exception e) {
                    EmfUtilPlugin.log(e);
                }
                ++i;
            }
            return metamodelProviders;
        }
    }
}

