/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.m2m.internal.qvt.oml.common.project.CompiledTransformation;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.CommonPluginImages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UniSelectTransformationControl
extends Composite {
    private final ViewerFilter VIEWER_FILTER = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return this.hasMatchingChildrenRecursive((IContainer)element, UniSelectTransformationControl.this.myResourceFilter);
            }
            if (element instanceof IResource) {
                return this.resourceMatches(UniSelectTransformationControl.this.myResourceFilter, (IResource)element);
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean hasMatchingChildrenRecursive(IContainer container, IResourceFilter filter) {
            try {
                IResource[] members;
                IResource[] iResourceArray = members = container.members();
                int n = members.length;
                int n2 = 0;
                while (true) {
                    boolean has;
                    if (n2 >= n) {
                        return false;
                    }
                    IResource member = iResourceArray[n2];
                    if (this.resourceMatches(filter, member)) {
                        return true;
                    }
                    if (member instanceof IContainer && (has = this.hasMatchingChildrenRecursive((IContainer)member, filter))) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        private boolean resourceMatches(IResourceFilter filter, IResource member) {
            return filter == null || filter.accept(member);
        }
    };
    private static final ViewerSorter VIEWER_SORTER = new ViewerSorter(){

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean folderLeft = e1 instanceof IContainer;
            boolean folderRight = e2 instanceof IContainer;
            if (folderLeft == folderRight) {
                return super.compare(viewer, e1, e2);
            }
            return folderLeft ? -1 : 1;
        }
    };
    private final ISelectionChangedListener VIEWER_LISTENER = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            UniSelectTransformationControl.this.myFileNameText.setText("");
            UniSelectTransformationControl.this.myUri = null;
            if (selection != null && selection.getFirstElement() instanceof IFile) {
                IFile ifile = (IFile)selection.getFirstElement();
                UniSelectTransformationControl.this.myFileNameText.setText(ifile.getName());
                UniSelectTransformationControl.this.myUri = URI.createPlatformResourceURI((String)ifile.getFullPath().toOSString(), (boolean)false);
            } else if (selection != null && selection.getFirstElement() instanceof CompiledTransformation) {
                CompiledTransformation transf = (CompiledTransformation)selection.getFirstElement();
                UniSelectTransformationControl.this.myUri = transf.getUri();
                UniSelectTransformationControl.this.myFileNameText.setText(UniSelectTransformationControl.this.myUri.toString());
            }
            UniSelectTransformationControl.this.fileSelectionChanged(UniSelectTransformationControl.this.myUri);
        }
    };
    private TreeViewer myViewer;
    private Text myFileNameText;
    private final IResourceFilter myResourceFilter;
    private URI myUri;
    private final List<CompiledTransformation> myCompiledTransformations;
    private final List<ISelectionListener> mySelectionListeners;
    private static final int DEFAUL_AUTO_EXPAND_LEVEL = 2;
    private ITreeContentProviderEx WORKSPACE_CONTENT_PROVIDER = new ITreeContentProviderEx(){
        private final ITreeContentProvider myProvider = new WorkbenchContentProvider();

        public Object[] getChildren(Object parentElement) {
            return this.myProvider.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            Object parent = this.myProvider.getParent(element);
            if (parent != null) {
                return parent;
            }
            if (!(element instanceof IFile)) {
                return null;
            }
            IFile file = (IFile)element;
            return file.getParent();
        }

        public boolean hasChildren(Object element) {
            return this.myProvider.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.myProvider.getElements(inputElement);
        }

        public void dispose() {
            this.myProvider.dispose();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.myProvider.inputChanged(viewer, oldInput, newInput);
        }

        public boolean canHandle(Object element) {
            return element instanceof IResource;
        }
    };

    public UniSelectTransformationControl(Composite parentComposite, IResourceFilter resourceFilter, ILabelProvider transfLabelProvider, TransformationRegistry transfRegistry, TransformationRegistry.Filter transfFilter) {
        super(parentComposite, 0);
        this.myResourceFilter = resourceFilter;
        this.mySelectionListeners = new ArrayList<ISelectionListener>();
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(1808));
        ArrayList<ITreeContentProviderEx> contentProviders = new ArrayList<ITreeContentProviderEx>(2);
        contentProviders.add(this.WORKSPACE_CONTENT_PROVIDER);
        contentProviders.add(new CompiledTransfContentProvider());
        ArrayList<ILabelProviderEx> labelProviders = new ArrayList<ILabelProviderEx>(2);
        labelProviders.add(new LabelProviderDelegate((ILabelProvider)new WorkbenchLabelProvider()){

            public boolean canHandle(Object element) {
                return element instanceof IResource;
            }
        });
        labelProviders.add(new LabelProviderDelegate(transfLabelProvider){

            public boolean canHandle(Object element) {
                return element instanceof CompiledTransformation || element instanceof CompiledTransformationRoot;
            }

            public String getText(Object element) {
                if (element instanceof CompiledTransformationRoot) {
                    return Messages.UniSelectTransformationControl_DeployedTransformations;
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof CompiledTransformationRoot) {
                    return CommonPluginImages.getInstance().getImage("registry");
                }
                return super.getImage(element);
            }
        });
        this.myViewer = new TreeViewer((Composite)this, 2820);
        this.myViewer.setContentProvider((IContentProvider)new CompositeContentProvider(contentProviders));
        this.myViewer.setLabelProvider((IBaseLabelProvider)new CompositeLabelProvider(labelProviders));
        this.myViewer.setAutoExpandLevel(2);
        this.myViewer.addFilter(this.VIEWER_FILTER);
        this.myViewer.setSorter(VIEWER_SORTER);
        this.myViewer.addSelectionChangedListener(this.VIEWER_LISTENER);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 250;
        data.widthHint = 350;
        this.myViewer.getControl().setLayoutData((Object)data);
        ArrayList<Object> inputs = new ArrayList<Object>(2);
        inputs.add(ResourcesPlugin.getWorkspace().getRoot());
        this.myCompiledTransformations = transfRegistry.getTransformations(transfFilter);
        inputs.add(new CompiledTransformationRoot(this.myCompiledTransformations));
        this.myViewer.setInput(inputs);
        TransformationControls.createLabel(this, Messages.UniSelectTransformationControl_CurrentSelection, 2);
        this.myFileNameText = new Text((Composite)this, 2048);
        this.myFileNameText.setEnabled(false);
        this.myFileNameText.setLayoutData((Object)new GridData(768));
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.mySelectionListeners.remove(listener);
    }

    public URI getSelectedUri() {
        return this.myUri;
    }

    public void selectTransformationByUri(String uriString) {
        URI uri = EmfUtil.makeUri((String)uriString);
        if (uri == null) {
            return;
        }
        if (uri.isPlatformPlugin()) {
            for (CompiledTransformation compiledTransf : this.myCompiledTransformations) {
                if (!compiledTransf.getUri().equals((Object)uri)) continue;
                StructuredSelection sel = new StructuredSelection(new Object[]{compiledTransf});
                this.myViewer.setSelection((ISelection)sel);
                return;
            }
            String transfId = uri.toPlatformString(false).replace("/", "");
            for (CompiledTransformation compiledTransf : this.myCompiledTransformations) {
                if (!compiledTransf.getId().equals(transfId)) continue;
                StructuredSelection sel = new StructuredSelection(new Object[]{compiledTransf});
                this.myViewer.setSelection((ISelection)sel);
                return;
            }
        } else {
            IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)uri);
            if (ifile != null) {
                StructuredSelection sel = new StructuredSelection(new Object[]{ifile});
                this.myViewer.setSelection((ISelection)sel);
            }
        }
    }

    private void fileSelectionChanged(URI selectedUri) {
        for (ISelectionListener listener : new ArrayList<ISelectionListener>(this.mySelectionListeners)) {
            try {
                listener.selectionChanged(selectedUri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class CompiledTransfContentProvider
    implements ITreeContentProviderEx {
        private CompiledTransfContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof CompiledTransformationRoot) {
                return ((CompiledTransformationRoot)inputElement).getChildren();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean canHandle(Object element) {
            return element instanceof CompiledTransformation || element instanceof CompiledTransformationRoot;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompiledTransformationRoot {
        private final List<CompiledTransformation> myTrasformations;

        CompiledTransformationRoot(List<CompiledTransformation> trasformations) {
            this.myTrasformations = trasformations;
        }

        Object[] getChildren() {
            return this.myTrasformations.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeContentProvider
    implements ITreeContentProvider {
        private final List<ITreeContentProviderEx> myProviders;

        CompositeContentProvider(List<ITreeContentProviderEx> providers) {
            this.myProviders = providers;
        }

        public Object[] getChildren(Object parentElement) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(parentElement)) continue;
                return provider.getChildren(parentElement);
            }
            return null;
        }

        public Object getParent(Object element) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getParent(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.hasChildren(element);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(inputElement)) continue;
                return provider.getChildren(inputElement);
            }
            return null;
        }

        public void dispose() {
            for (ITreeContentProviderEx provider : this.myProviders) {
                provider.dispose();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            for (ITreeContentProviderEx provider : this.myProviders) {
                if (!provider.canHandle(oldInput) && !provider.canHandle(newInput)) continue;
                provider.inputChanged(viewer, oldInput, newInput);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeLabelProvider
    implements ILabelProvider {
        private final List<ILabelProviderEx> myProviders;

        CompositeLabelProvider(List<ILabelProviderEx> providers) {
            this.myProviders = providers;
        }

        public Image getImage(Object element) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getImage(element);
            }
            return null;
        }

        public String getText(Object element) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.getText(element);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.addListener(listener);
            }
        }

        public void dispose() {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            for (ILabelProviderEx provider : this.myProviders) {
                if (!provider.canHandle(element)) continue;
                return provider.isLabelProperty(element, property);
            }
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            for (ILabelProviderEx provider : this.myProviders) {
                provider.removeListener(listener);
            }
        }
    }

    private static interface ILabelProviderEx
    extends ILabelProvider {
        public boolean canHandle(Object var1);
    }

    public static interface IResourceFilter {
        public boolean accept(IResource var1);
    }

    public static interface ISelectionListener {
        public void selectionChanged(URI var1);
    }

    private static interface ITreeContentProviderEx
    extends ITreeContentProvider {
        public boolean canHandle(Object var1);
    }

    private static abstract class LabelProviderDelegate
    implements ILabelProviderEx {
        private final ILabelProvider myDelegate;

        LabelProviderDelegate(ILabelProvider provider) {
            this.myDelegate = provider;
        }

        public Image getImage(Object element) {
            return this.myDelegate.getImage(element);
        }

        public String getText(Object element) {
            return this.myDelegate.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.myDelegate.addListener(listener);
        }

        public void dispose() {
            this.myDelegate.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myDelegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myDelegate.removeListener(listener);
        }
    }
}

