/**
* Essential OCL Grammar
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Elimination of some shift-reduce conflicts
*   E.D.Willink - Remove unnecessary warning suppression
*   E.D.Willink - Bugs 184048, 225493, 243976, 259818, 282882, 287993, 288040, 292112, 295166
*   Borland - Bug 242880
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias):
*        - 242153: LPG v 2.0.17 adoption.
*        - 299396: Introducing new LPG templates
*        - 300534: Removing the use of deprecated macros.
* </copyright>
*
* $Id: QVTOParserprs.java,v 1.13 2010/05/14 09:16:04 sboyko Exp $
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2007 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*
* </copyright>
*
*/
/**
* <copyright>
*
* Copyright (c) 2006, 2007 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (297966)
*
* </copyright>
*
*/

package org.eclipse.m2m.internal.qvt.oml.cst.parser;

public class QVTOParserprs implements lpg.runtime.ParseTable, QVTOParsersym {
    public final static int ERROR_SYMBOL = 1;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 96;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 97;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 30;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 506;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 163;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 9848;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 685;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 286;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 449;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 783;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 3;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 119;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 119;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 9162;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 9163;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = true;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return QVTOParsersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,1,0,1,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            1,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,1,
            0,0,0,0,0,0,0,0,0,0,
            0,1,0,0,0,0,1,0,1,0,
            0,0,0,0,1,1,0,0,0,1,
            1,0,0,0,1,0,0,1,0,0,
            0,1,0,1,0,0,0,1,0,0,
            0,0,0,1,0,0,1,0,1,0,
            1,0,0,0,0,0,0,0,1,0,
            1,1,0,0,0,0,0,0,0,0,
            0,0,0,0,0,1,0,0,1,1,
            0,0,1,1,0,1,0,0,1,1,
            0,0,1,1,1,1,0,0,0,1,
            1,1,1,1,0,0,0,0,0,1,
            1,1,0,0,0,1,0,0,1,0,
            0,0,0,1,1,0,0,0,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static char prosthesesIndex[] = {0,
            12,13,9,10,15,17,18,40,38,42,
            32,39,41,43,44,272,273,275,276,11,
            29,30,31,33,46,47,48,49,50,51,
            52,53,54,59,60,61,86,88,89,90,
            91,94,96,101,113,123,141,152,264,266,
            83,84,85,80,81,82,77,78,79,74,
            75,76,71,72,73,68,69,70,65,66,
            67,133,24,55,62,63,64,102,107,110,
            132,136,16,93,95,112,56,58,210,155,
            21,57,226,285,286,22,25,27,188,108,
            23,174,87,164,189,194,195,196,247,261,
            284,6,8,14,26,36,37,104,105,111,
            114,168,169,170,171,172,173,182,208,209,
            227,228,229,230,231,234,235,236,237,238,
            239,241,242,243,245,283,34,35,98,99,
            106,109,119,124,126,129,130,148,149,154,
            157,158,162,178,186,197,198,199,201,207,
            215,216,218,232,233,265,268,269,270,279,
            281,2,3,4,19,20,45,92,97,100,
            103,115,116,117,118,120,121,122,125,127,
            128,131,134,135,137,138,139,140,142,143,
            144,145,146,147,150,151,153,156,159,160,
            161,163,165,166,167,175,176,177,179,180,
            181,183,184,185,187,190,191,192,193,200,
            202,203,204,205,206,211,212,213,214,217,
            219,220,221,222,223,224,225,240,244,246,
            248,249,250,251,252,253,254,255,256,257,
            258,259,260,262,263,267,271,274,277,278,
            280,282,1,5,7,28
        };
    };
    public final static char prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,1,1,0,0,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,0,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            0,1,1,1,1,1,1,1,1,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,0,
            1,1,1,1,1,0,0,0,0,0,
            0,1,1,1,1,1,1,1,0,0,
            0,0,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,0,0,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck0 {
        public final static short baseCheck0[] = {0,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,2,1,1,1,
            3,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,4,4,
            0,1,1,3,1,3,3,5,1,1,
            1,1,1,1,1,1,1,1,1,1,
            4,0,1,1,3,1,1,3,1,1,
            1,1,1,1,1,4,1,3,1,1,
            1,2,1,1,1,1,1,1,1,1,
            1,1,1,1,8,10,10,8,10,1,
            1,1,5,6,8,8,7,7,5,6,
            9,1,4,6,4,0,0,1,1,3,
            1,1,1,1,1,1,1,1,1,3,
            1,3,1,1,1,3,1,3,1,1,
            1,3,1,3,1,1,1,3,1,3,
            1,1,1,3,3,1,3,3,1,1,
            1,3,3,3,3,1,3,3,3,3,
            1,1,1,3,3,1,3,3,1,1,
            1,3,3,1,3,3,1,1,1,2,
            2,1,2,2,1,1,1,1,1,1,
            3,4,1,3,1,4,4,1,6,4,
            1,1,1,3,1,0,1,3,2,1,
            2,1,0,1,2,4,4,1,2,4,
            4,2,3,3,5,5,3,3,3,3,
            1,1,1,1,3,3,3,3,1,7,
            7,5,3,5,1,3,1,1,1,3,
            0,2,2,6,2,1,1,1,1,1,
            1,7,5,6,4,2,1,2,1,1,
            3,7,2,4,4,2,1,2,5,5,
            0,1,2,2,1,1,2,1,0,5,
            1,1,1,0,2,1,0,6,5,1,
            3,1,1,1,1,1,1,1,1,4,
            4,2,1,3,5,5,1,3,0,1,
            2,0,1,6,3,1,5,1,1,1,
            1,1,3,5,5,3,1,0,0,1,
            2,1,1,3,2,3,2,2,2,1,
            6,4,2,4,4,1,1,3,1,2,
            1,2,0,1,1,1,1,1,1,1,
            1,1,2,1,1,1,2,5,1,1,
            2,5,5,0,1,1,1,1,2,4,
            1,2,0,1,1,1,2,0,1,1,
            1,3,3,0,1,1,1,1,3,2,
            2,2,0,1,1,1,1,1,1,2,
            1,7,1,2,0,1,2,1,3,2,
            1,4,1,0,1,1,1,8,0,2,
            1,3,2,0,2,1,3,2,9,1,
            0,2,0,3,1,3,2,0,2,2,
            1,1,1,1,1,0,3,1,1,3,
            3,3,3,1,0,0,4,1,0,6,
            6,7,5,6,8,1,1,1,3,2,
            2,1,1,2,2,4,3,1,1,4,
            2,2,3,1,1,2,2,2,3,4,
            0,2,1,1,2,5,3,2,6,5,
            3,2,0,1,2,1,1,1,1,0,
            5,2,3,0,1,2,2,0,1,1,
            2,2,0,1,2,2,0,1,1,1,
            1,1,3,3,3,5,5,7,7,5,
            5,0,2,2,0,2,0,1,3,1,
            1,1,1,0,1,5,5,3,2,1,
            1,1,1,7,5,7,5,4,3,1,
            1,3,3,1,3,3,1,1,1,1,
            1,3,4,4,3,3,3,4,3,1,
            7,0,2,1,1,1,0,2,2,0,
            1,3,0,1,3,3,1,1,4,2,
            0,1,1,1,1,1,3,1,1,1,
            3,3,1,1,1,3,3,1,3,2,
            1,3,3,2,1,-35,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-2,-4,
            -163,1,2,-238,1,2,3,4,5,6,
            7,-274,-1,-8,-241,-15,16,17,18,19,
            -72,1,2,-20,-91,1,2,-400,-164,5,
            -88,1,2,118,119,5,8,9,10,11,
            12,13,14,15,-162,1,2,44,-502,5,
            -92,1,2,-16,-19,5,-340,9,10,-171,
            16,17,18,19,8,9,10,11,12,13,
            14,15,-153,-372,1,2,161,162,5,-215,
            -21,8,-23,-450,1,2,83,84,85,-65,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,218,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,100,-24,91,-25,176,149,150,96,
            121,98,-245,1,2,106,107,108,177,178,
            179,-6,192,193,182,-246,1,2,175,8,
            -86,-156,129,180,-26,149,150,118,119,209,
            210,211,212,-375,155,-27,-222,189,190,160,
            176,8,195,151,8,205,206,183,184,215,
            216,219,-61,1,2,3,4,-292,1,2,
            -28,158,-30,170,44,3,4,217,6,7,
            161,162,-335,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,93,94,95,101,-46,
            -48,-321,129,91,112,113,114,8,96,97,
            98,-125,-44,152,154,3,4,268,6,7,
            271,-442,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-379,93,94,95,87,-289,
            1,2,91,-318,-343,1,2,96,-7,98,
            -165,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,164,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-416,203,204,97,-52,-314,1,
            2,97,-218,5,-29,101,-388,1,2,106,
            107,108,-213,-214,-390,1,2,-324,-116,115,
            -90,-38,-39,-491,-78,-42,116,117,-191,-54,
            241,-146,-435,-158,1,2,3,4,-330,1,
            2,3,4,-317,1,2,-64,246,5,-426,
            -62,-368,3,4,-205,6,7,147,148,-167,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,105,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,93,94,95,112,113,114,105,-316,
            112,113,114,-496,100,-31,262,263,264,-17,
            -67,164,9,10,-69,167,-70,-71,260,152,
            177,178,179,-76,266,116,117,175,166,166,
            168,168,180,159,-503,-77,154,159,-79,-80,
            -425,1,2,9,10,5,173,-132,-50,44,
            -81,3,4,44,6,7,147,148,-261,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,93,94,95,86,105,99,277,278,281,
            269,250,-501,272,-438,1,2,-377,258,-440,
            1,2,-235,-495,265,-417,-10,-338,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,153,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            91,97,86,244,196,96,99,98,91,256,
            261,-334,100,96,-82,98,-407,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-225,
            1,2,86,-5,1,2,3,4,5,6,
            7,-57,1,2,3,4,5,6,7,-58,
            1,2,3,4,5,6,7,-83,-55,-89,
            213,-117,121,-118,-174,-175,-233,-234,-249,-250,
            -255,-305,-85,-87,-95,-307,-96,240,-310,-349,
            -97,-98,-99,-356,-357,-376,-378,-414,-100,257,
            -101,-102,-422,-103,251,-104,155,-105,-106,153,
            -110,160,44,44,-111,44,-112,44,44,44,
            44,44,44,44,44,44,83,84,85,44,
            91,276,44,44,83,84,85,44,44,44,
            44,44,83,84,85,-131,44,-34,3,4,
            199,6,7,197,-151,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,90,93,94,
            95,87,88,-239,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-14,1,2,-113,
            87,88,-271,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,89,-43,1,2,87,
            88,-275,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-114,89,-36,-119,87,88,
            -276,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-45,1,2,90,87,88,-326,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,89,-56,1,2,87,88,-350,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-123,89,-124,86,-202,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,-126,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,-127,157,-385,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-463,
            1,2,-135,87,88,-387,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,89,-505,
            1,2,87,88,-389,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-40,89,-144,
            -136,87,88,-391,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-145,90,-137,90,
            87,88,-458,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-427,90,-138,86,-184,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,-139,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,-216,-221,72,-353,157,
            -465,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-75,86,90,90,87,88,-466,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-240,-412,-140,92,87,88,-467,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-336,-506,90,92,87,88,-84,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,44,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -203,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-456,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-141,-142,173,-148,-149,44,-152,
            -154,-155,-157,-159,-168,-172,-173,-176,-177,-179,
            -180,-181,-182,-190,-192,194,-236,-193,-194,-206,
            -482,-207,-210,3,4,198,6,7,118,119,
            -342,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-459,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,93,94,95,100,-217,44,-226,
            -228,-230,-231,-243,-247,-248,-251,-252,-253,-254,
            -256,-257,-258,-259,-260,-262,-263,-264,-265,-242,
            -244,-386,-399,-268,-269,-270,116,117,-441,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,92,92,92,92,87,-74,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            -272,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-160,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-381,-278,-279,-280,-281,-282,-283,-284,
            -285,-286,-287,-288,-295,-296,-297,-298,-299,-300,
            -301,-302,-303,-304,-308,-312,-313,191,-161,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-169,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,-464,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-319,-320,-323,-325,-328,44,
            -329,-331,-332,-333,-344,-351,-355,-358,-360,207,
            208,-361,-362,-363,-364,-365,-367,-373,-383,-384,
            -392,-393,-394,-395,-396,-397,-398,-401,-402,-403,
            -404,-405,121,-237,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-267,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-291,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-322,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-382,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-446,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,44,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-461,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-41,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,-408,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-63,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,-409,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -94,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-410,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-121,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,-413,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-143,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            -415,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-232,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,-419,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-290,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,-424,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-294,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,-428,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-306,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-429,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-327,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,-430,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-339,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,-431,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-341,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,-432,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -346,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-433,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-348,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,-434,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-352,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            -444,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-354,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,-445,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-366,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,-451,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-380,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,-460,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-411,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-462,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-418,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,-468,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-436,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,-469,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-437,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,-470,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -439,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-471,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-449,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,-472,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,72,73,74,75,76,
            77,78,79,80,81,82,-453,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            -473,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,-454,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,-474,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,69,70,
            71,72,73,74,75,76,77,78,79,80,
            81,82,-457,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,-476,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,-486,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,-478,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,63,64,
            65,66,67,68,69,70,71,72,73,74,
            75,76,77,78,79,80,81,82,-487,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-479,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,60,61,
            62,63,64,65,66,67,68,69,70,71,
            72,73,74,75,76,77,78,79,80,81,
            82,-488,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,-480,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,-489,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,-483,45,
            46,47,48,49,50,51,52,53,54,55,
            56,57,58,59,60,61,62,63,64,65,
            66,67,68,69,70,71,72,73,74,75,
            76,77,78,79,80,81,82,-490,1,2,
            3,4,5,6,7,8,9,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,24,25,26,27,28,29,30,31,32,
            33,34,35,36,37,38,39,40,41,42,
            43,-484,45,46,47,48,49,50,51,52,
            53,54,55,56,57,58,59,60,61,62,
            63,64,65,66,67,68,69,70,71,72,
            73,74,75,76,77,78,79,80,81,82,
            -504,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-485,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,-183,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,-492,45,46,
            47,48,49,50,51,52,53,54,55,56,
            57,58,59,60,61,62,63,64,65,66,
            67,68,69,70,71,-201,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,-493,
            45,46,47,48,49,50,51,52,53,54,
            55,56,57,58,59,60,61,62,-185,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-494,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,-186,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-498,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,-187,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,-499,45,46,47,48,49,50,51,
            52,53,54,55,56,57,58,59,-197,1,
            2,3,4,5,6,7,8,9,10,11,
            12,13,14,15,16,17,18,19,20,21,
            22,23,24,25,26,27,28,29,30,31,
            32,33,34,35,36,37,38,39,40,41,
            42,43,0,45,46,47,48,49,50,51,
            52,53,54,55,56,-198,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,0,
            45,46,47,48,49,50,51,52,53,54,
            55,56,-199,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,0,45,46,47,
            48,49,50,51,52,53,54,55,56,-200,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,0,45,46,47,48,49,50,
            51,52,53,54,55,56,-188,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            0,45,46,47,48,49,50,51,52,53,
            -189,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,-500,45,46,47,48,49,
            50,51,52,53,-107,1,2,3,4,5,
            6
        };
    };

    public interface BaseCheck1 {
        public final static short baseCheck1[] = {
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,0,45,46,
            47,48,49,50,-108,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,0,45,
            46,47,48,49,50,0,103,-266,0,0,
            0,0,0,-195,1,2,3,4,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,103,45,46,
            47,48,49,50,-196,1,2,3,4,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,-3,45,
            46,47,48,49,50,0,103,-93,1,2,
            3,4,5,6,7,0,-219,-423,-447,1,
            2,0,0,0,0,-130,-406,0,-211,1,
            2,3,4,5,6,7,253,0,0,0,
            0,0,44,0,0,0,0,0,0,0,
            0,0,0,156,0,0,0,103,0,0,
            44,-277,1,2,3,4,5,6,7,44,
            0,0,0,0,0,-497,0,0,0,0,
            0,0,0,-51,1,2,0,0,0,-475,
            83,84,85,0,-448,1,2,-345,201,202,
            102,-68,1,2,3,4,5,6,7,91,
            -134,83,84,85,96,99,98,110,92,102,
            122,123,124,125,126,127,128,102,130,131,
            132,133,134,135,136,137,138,139,140,141,
            142,143,144,145,83,84,85,122,123,124,
            125,126,127,128,44,130,131,132,133,134,
            135,136,137,138,139,140,141,142,143,144,
            145,110,89,-229,1,2,3,4,5,6,
            7,92,0,86,83,84,85,104,171,172,
            174,97,0,0,169,101,0,0,0,0,
            0,-60,1,2,3,4,5,6,7,115,
            0,110,102,0,0,0,0,120,220,221,
            0,223,224,225,226,227,228,229,230,231,
            0,-133,122,123,124,125,126,127,128,0,
            130,131,132,133,134,135,136,137,138,139,
            140,141,142,143,144,145,83,84,85,-122,
            1,2,3,4,5,6,7,-208,1,2,
            3,4,5,6,7,44,248,-220,280,169,
            0,274,275,110,83,84,85,-209,1,2,
            3,4,5,6,7,-223,1,2,3,4,
            5,6,7,-224,1,2,3,4,5,6,
            7,-293,1,2,3,4,5,6,7,-347,
            1,2,3,4,5,6,7,252,0,-12,
            99,-309,3,4,273,6,7,-22,1,2,
            0,0,83,84,85,-33,-18,1,2,-311,
            83,84,85,-359,1,2,3,4,5,6,
            7,-371,1,2,3,4,5,6,7,-129,
            83,84,85,44,-337,1,2,-170,83,84,
            85,44,0,106,107,108,83,84,85,44,
            44,0,-420,44,83,84,85,0,-109,1,
            2,0,83,84,85,-443,1,2,3,4,
            5,6,7,-481,1,2,3,4,5,6,
            7,44,93,94,95,-273,89,-204,3,4,
            -49,6,7,102,0,89,83,84,85,0,
            -32,104,165,0,83,84,85,-212,1,2,
            104,-37,5,0,109,8,111,-166,1,2,
            -53,1,2,232,-47,91,-59,1,2,44,
            96,44,98,0,44,106,107,108,-315,1,
            2,-73,90,5,44,-421,1,2,83,84,
            85,146,0,-150,0,97,83,84,85,101,
            163,-9,171,172,-128,1,2,-115,44,-11,
            233,234,235,-374,-369,1,2,0,93,94,
            95,-13,-120,-66,-147,44,181,-178,-452,44,
            -455,0,158,156,165,-227,109,44,111,109,
            -477,111,0,-370,0,44,0,0,44,89,
            99,44,0,44,97,0,0,91,101,222,
            0,0,0,99,104,44,44,44,44,0,
            0,44,115,146,89,0,129,200,247,44,
            249,100,0,105,238,0,188,44,214,0,
            0,0,243,89,245,86,0,90,0,86,
            99,0,109,89,111,0,237,86,181,86,
            86,0,0,86,86,0,86,170,0,0,
            0,86,100,163,0,174,86,282,0,0,
            0,0,151,90,0,0,0,0,0,146,
            0,0,0,0,187,167,0,0,120,0,
            120,185,186,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,279,0,0,
            0,0,0,0,0,0,0,0,0,242,
            0,0,0,0,0,0,0,0,0,259,
            236,0,0,239,0,0,0,267,0,0,
            270,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            255,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,254,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0
        };
    };

    public final static short baseCheck[] = new short[BaseCheck0.baseCheck0.length + BaseCheck1.baseCheck1.length];
    {
        int index = 0;
        System.arraycopy(BaseCheck0.baseCheck0, 0, baseCheck, index, BaseCheck0.baseCheck0.length);
        index += BaseCheck0.baseCheck0.length;
        System.arraycopy(BaseCheck1.baseCheck1, 0, baseCheck, index, BaseCheck1.baseCheck1.length);
    };
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static short rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction0 {
        public final static char baseAction0[] = {
            182,183,183,183,183,183,183,183,183,183,
            183,183,183,183,183,183,184,284,284,284,
            284,284,284,284,284,284,284,284,112,285,
            113,113,113,20,1,1,2,2,114,114,
            5,5,4,4,4,4,4,4,4,4,
            3,3,3,3,3,83,83,83,83,6,
            7,185,185,186,186,96,91,101,97,115,
            115,98,98,286,286,286,286,21,21,21,
            21,22,147,147,148,148,116,116,117,11,
            11,11,11,11,11,11,23,187,187,9,
            12,8,8,13,13,10,14,15,24,24,
            24,25,25,27,27,28,28,28,29,29,
            26,26,26,31,31,31,31,31,31,31,
            31,31,33,32,32,34,92,88,88,87,
            87,73,73,36,35,74,74,77,77,75,
            75,76,76,70,70,69,69,71,71,67,
            67,66,66,68,68,64,64,63,63,65,
            65,61,61,60,60,60,62,62,62,58,
            58,57,57,57,57,57,59,59,59,59,
            59,55,55,54,54,54,56,56,56,52,
            52,51,51,51,53,53,53,103,103,37,
            37,37,38,38,38,30,30,39,39,39,
            39,39,40,188,188,83,84,42,83,85,
            43,149,21,21,150,189,189,190,190,190,
            73,78,191,191,118,119,119,119,73,79,
            79,79,79,151,151,100,100,100,100,100,
            100,152,152,152,73,80,80,80,80,120,
            45,45,45,28,28,87,87,193,193,194,
            194,195,195,195,192,192,39,153,153,196,
            197,198,41,41,41,41,41,39,46,199,
            199,199,29,46,154,154,154,200,200,156,
            156,201,201,202,202,73,81,203,204,204,
            72,81,205,206,206,207,208,208,82,47,
            39,29,210,210,210,210,211,211,212,212,
            209,209,209,213,213,213,214,158,158,159,
            159,215,216,216,29,29,39,48,217,39,
            39,155,155,121,121,121,160,90,90,218,
            218,161,118,162,162,162,86,86,157,157,
            44,156,156,156,202,202,182,220,221,222,
            221,163,219,219,220,220,220,220,220,220,
            220,220,220,220,220,223,223,226,227,224,
            224,229,230,228,233,233,234,234,232,235,
            231,238,231,236,236,239,165,165,237,237,
            106,106,107,108,166,166,168,168,167,167,
            167,105,164,164,169,169,169,169,169,169,
            169,169,225,244,225,243,243,245,242,242,
            242,170,170,170,241,241,129,122,130,246,
            246,248,248,248,247,247,249,249,249,171,
            171,253,253,172,172,254,254,254,250,250,
            250,255,255,255,255,255,173,173,256,256,
            256,256,256,256,251,251,252,252,257,257,
            123,123,123,123,123,123,124,124,124,134,
            134,135,175,175,131,131,132,133,125,125,
            138,136,136,137,126,126,141,141,139,140,
            102,258,258,127,127,142,143,143,144,145,
            145,145,261,261,262,263,264,264,264,260,
            260,266,266,259,267,267,270,270,268,268,
            271,271,271,269,269,272,272,273,273,274,
            275,275,275,274,49,49,176,176,176,176,
            50,50,276,276,276,177,177,178,178,179,
            277,277,277,277,16,16,17,17,17,17,
            278,278,278,278,18,18,18,18,18,18,
            19,19,31,31,39,31,31,39,39,1,
            1,279,279,40,40,60,62,217,221,228,
            220,280,128,128,180,180,180,281,281,174,
            240,240,99,282,282,181,181,181,181,146,
            146,109,109,111,111,111,110,110,94,94,
            94,93,93,93,95,95,95,95,265,265,
            265,104,104,104,104,89,235,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            377,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,372,
            141,2285,146,1884,240,248,264,315,321,62,
            2413,2835,3706,1011,192,40,1011,986,55,1325,
            57,58,2268,5,3034,3391,2694,1341,620,621,
            622,2209,322,1011,2688,112,40,1011,3254,3025,
            3588,112,40,1011,373,244,3587,1521,89,93,
            231,90,92,94,95,2565,3721,1011,260,3320,
            3704,112,40,1011,3071,3179,3589,3069,501,503,
            3375,1341,620,621,623,1521,89,93,231,90,
            92,94,95,3370,3108,40,1011,370,8899,4007,
            3177,3186,4006,63,112,4209,1011,1338,225,228,
            2106,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,1487,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,372,141,2285,146,1884,240,248,
            264,315,321,1858,90,72,194,625,3710,237,
            71,361,347,112,4183,1011,427,430,431,8745,
            1875,598,96,273,1859,769,112,4184,1011,521,
            1013,3083,3091,463,643,2513,3710,238,373,244,
            331,3708,3707,1860,96,3725,2770,96,3709,1861,
            362,626,4006,6001,1857,4175,323,3580,16,3720,
            353,5542,8390,2161,38,1011,30,31,112,4194,
            1011,2169,7163,2843,459,303,986,668,3586,670,
            669,570,8899,722,3723,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,274,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,4203,4207,2285,146,
            1884,240,248,264,315,321,1371,1342,1343,632,
            2766,85,3433,5337,4206,32,39,41,2625,71,
            4204,4205,2577,2888,4214,298,986,668,1352,670,
            669,569,1866,8481,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,275,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,139,141,2285,146,1884,
            240,248,264,315,321,2958,2554,1342,1343,6914,
            112,4193,1011,72,3202,112,3599,1011,71,2508,
            6831,2301,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,8417,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,3712,141,2285,146,1884,240,
            248,264,315,321,2976,318,320,224,85,112,
            40,1011,70,2738,1628,2693,69,112,5669,1011,
            427,430,431,2823,2823,112,5835,1011,2566,2047,
            98,2535,3233,3257,3570,2851,2569,84,86,2612,
            3068,2600,3358,3534,2161,38,1011,30,31,2161,
            38,1011,30,31,112,40,1011,2218,3603,1628,
            2888,471,480,986,668,3370,670,669,3711,3713,
            2301,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,438,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,3712,141,2285,146,1884,240,248,
            264,315,321,678,1342,1343,32,39,3313,419,
            424,32,39,3722,3320,1862,2620,552,554,1370,
            228,2622,8502,7833,499,351,1876,3015,3330,548,
            4546,8745,3655,6250,2547,559,84,86,521,1319,
            8870,435,435,643,3584,3320,3312,302,3584,2773,
            3270,112,40,1011,500,502,1628,1634,2874,2888,
            562,2796,986,668,453,670,669,3715,3713,420,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,289,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,287,141,2285,146,1884,240,248,264,
            315,321,1518,1342,1343,288,439,530,1856,1855,
            649,563,8877,3581,574,112,4193,1011,3306,540,
            112,4209,1011,3370,3574,4136,3500,3171,2361,8418,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,4185,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,343,141,2285,146,1884,240,248,264,315,
            321,72,6499,1928,454,295,71,651,6665,72,
            7773,1215,3457,254,71,2540,4212,1022,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,290,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            287,141,2285,146,1884,240,248,264,315,321,
            112,3315,1011,288,88,40,1011,986,55,1325,
            57,58,88,40,1011,986,55,1325,57,58,
            88,40,1011,986,55,1325,57,58,2914,2742,
            69,4211,2162,361,2299,3187,3241,2356,2654,3262,
            200,2519,2810,3336,3341,3064,3030,2279,441,2761,
            3292,3181,2562,2718,2787,3301,2836,3027,3310,2595,
            2800,2187,3317,3175,2973,8467,3326,299,2872,3214,
            6167,3218,362,684,609,2894,672,2567,677,619,
            608,247,251,285,342,239,251,853,225,228,
            511,64,599,473,305,2979,225,228,617,607,
            440,440,382,3068,225,228,2888,487,2844,986,
            668,4201,670,669,294,300,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,275,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,139,141,
            2285,146,1884,240,248,264,315,321,539,8408,
            1342,1343,3703,3702,360,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,275,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,139,141,2285,
            146,1884,240,248,264,315,321,112,685,1011,
            3333,3703,4178,482,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,275,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,139,141,2285,146,
            1884,240,248,264,315,321,1346,112,685,1011,
            3703,4187,542,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,275,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,139,141,2285,146,1884,
            240,248,264,315,321,3342,2552,2844,3344,3703,
            4189,602,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,275,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,139,141,2285,146,1884,240,
            248,264,315,321,112,685,1011,533,3703,4192,
            662,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,275,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,139,141,2285,146,1884,240,248,
            264,315,321,1122,112,685,1011,3703,4199,130,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,314,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,5088,141,2285,146,1884,240,248,264,
            315,321,2892,2891,3026,3314,2463,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1349,120,121,122,
            132,4002,218,201,204,1494,212,220,232,233,
            52,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,159,4003,158,3348,313,782,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,275,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            139,141,2285,146,1884,240,248,264,315,321,
            112,685,1011,3349,3703,5420,842,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            275,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,139,
            141,2285,146,1884,240,248,264,315,321,486,
            112,685,1011,3703,5586,902,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,275,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,139,141,
            2285,146,1884,240,248,264,315,321,2844,3403,
            2844,1026,3703,5752,962,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,275,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,139,141,2285,
            146,1884,240,248,264,315,321,2844,527,593,
            3700,3703,5918,1084,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,310,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,5088,141,2285,146,
            1884,240,248,264,315,321,3516,546,3086,3314,
            2463,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1349,120,121,122,132,3986,218,201,204,1494,
            212,220,232,233,3351,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,165,3987,164,2844,2844,325,3443,
            309,1146,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,275,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,139,141,2285,146,1884,240,
            248,264,315,321,221,329,412,408,3703,7329,
            1206,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,275,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,139,141,2285,146,1884,240,248,
            264,315,321,3253,2844,3350,3583,3703,7412,1266,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,275,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,139,141,2285,146,1884,240,248,264,
            315,321,3458,3570,379,133,3703,7495,1326,3224,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,291,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,3585,141,2285,146,1884,240,248,264,315,
            321,2217,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,3315,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,372,141,2285,146,1884,240,
            248,264,315,321,713,3357,507,3359,3364,385,
            3365,833,953,3374,2037,3368,3380,3166,3244,3248,
            3369,3381,3384,3383,3112,3201,798,3370,3215,2597,
            3385,2888,1073,3388,986,668,296,670,669,374,
            244,2361,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,200,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,3712,141,2285,146,1884,240,
            248,264,315,321,679,1342,1343,253,3386,616,
            3389,3390,3392,1197,3397,3402,3403,3406,3407,3411,
            1082,3412,1330,1317,2213,3414,3417,3399,3416,3415,
            216,3398,3485,3105,3422,3425,3216,85,86,1806,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,275,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,139,141,2285,146,1884,240,248,264,
            315,321,4181,4182,5503,3583,6748,2046,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,3423,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            242,141,2285,146,1884,240,248,264,315,321,
            1386,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,268,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,267,141,2285,146,1884,240,248,
            264,315,321,3482,2809,3418,2928,3428,3058,2972,
            3118,3122,3139,3258,3260,3065,3236,3267,3269,3271,
            2948,3123,2912,3430,1390,3221,3431,3288,241,1446,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,266,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,265,141,2285,146,1884,240,248,264,
            315,321,2412,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,3043,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,3716,141,2285,146,1884,
            240,248,3719,315,321,2768,3434,3441,3448,3435,
            680,3440,3454,3289,3297,2950,3464,3465,3459,3467,
            326,328,3473,3472,2933,3451,3474,3480,3481,3483,
            3484,3486,3150,3488,3489,3273,1497,1510,3493,3494,
            3274,3495,3496,3717,1506,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,258,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,257,141,2285,
            146,1884,240,248,264,315,321,1566,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,383,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            4186,141,2285,146,1884,240,248,264,315,321,
            1626,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,634,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,633,141,2285,146,1884,240,248,
            264,315,321,1686,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,276,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,140,141,2285,146,
            1884,240,248,264,315,321,1746,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            256,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,255,
            141,2285,146,1884,240,248,264,315,321,1926,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,283,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,282,141,2285,146,1884,240,248,264,
            315,321,1986,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,594,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,593,141,2285,146,1884,
            240,248,264,315,321,2361,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,3503,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,2288,141,
            2285,146,1884,240,248,264,315,321,2361,3224,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,2546,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,2890,141,2285,146,1884,240,248,264,315,
            321,2361,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,3506,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,3593,141,2285,146,1884,240,
            248,264,315,321,2361,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,3498,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,3600,141,2285,
            146,1884,240,248,264,315,321,2361,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,3508,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            542,141,2285,146,1884,240,248,264,315,321,
            2361,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,3501,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,4177,141,2285,146,1884,240,248,
            264,315,321,2361,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,3511,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,222,141,2285,146,
            1884,240,248,264,315,321,2361,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            3517,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,67,
            141,2285,146,1884,240,248,264,315,321,2361,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,3518,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,4196,141,2285,146,1884,240,248,264,
            315,321,2361,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,3519,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,4200,141,2285,146,1884,
            240,248,264,315,321,2361,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,3524,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,234,141,
            2285,146,1884,240,248,264,315,321,2361,3224,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,3527,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,88,141,2285,146,1884,240,248,264,315,
            321,2361,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,3528,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,4839,141,2285,146,1884,240,
            248,264,315,321,2361,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,3529,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,5005,141,2285,
            146,1884,240,248,264,315,321,2361,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,3537,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            5171,141,2285,146,1884,240,248,264,315,321,
            2361,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,3539,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,366,141,2285,146,1884,240,248,
            264,315,321,2361,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,3538,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,5254,141,2285,146,
            1884,240,248,264,315,321,2361,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            3543,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,317,
            141,2285,146,1884,240,248,264,315,321,2361,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,3540,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,3535,141,2285,146,1884,240,248,264,
            315,321,2361,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,3551,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,68,141,2285,146,1884,
            240,248,264,315,321,2361,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,3545,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,301,141,
            2285,146,1884,240,248,264,315,321,2361,3224,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,3554,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,6416,141,2285,146,1884,240,248,264,315,
            321,2361,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,3546,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,6582,141,2285,146,1884,240,
            248,264,315,321,2361,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1345,120,121,122,132,1879,
            218,201,204,1494,212,220,232,233,3303,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,1881,2110,151,316,344,141,2285,
            146,1884,240,248,264,315,321,2361,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1345,120,121,
            122,132,1879,218,201,204,1494,212,220,232,
            233,3548,286,297,330,356,628,627,1865,1891,
            196,1871,1889,186,1867,1895,176,1873,1888,169,
            1872,1897,163,1882,1886,157,1881,2110,151,316,
            365,141,2285,146,1884,240,248,264,315,321,
            2361,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1345,120,121,122,132,1879,218,201,204,1494,
            212,220,232,233,3319,286,297,330,356,628,
            627,1865,1891,196,1871,1889,186,1867,1895,176,
            1873,1888,169,1872,1897,163,1882,1886,157,1881,
            2110,151,316,364,141,2285,146,1884,240,248,
            264,315,321,2361,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1345,120,121,122,132,1879,218,
            201,204,1494,212,220,232,233,3559,286,297,
            330,356,628,627,1865,1891,196,1871,1889,186,
            1867,1895,176,1873,1888,169,1872,1897,163,1882,
            1886,157,1881,2110,151,316,7246,141,2285,146,
            1884,240,248,264,315,321,2361,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1345,120,121,122,
            132,1879,218,201,204,1494,212,220,232,233,
            3553,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,1873,1888,169,1872,
            1897,163,1882,1886,157,1881,2110,151,316,7578,
            141,2285,146,1884,240,248,264,315,321,2361,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1345,
            120,121,122,132,1879,218,201,204,1494,212,
            220,232,233,3285,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,1867,1895,176,1873,
            1888,169,1872,1897,163,1882,1886,157,1881,2110,
            151,316,7650,141,2285,146,1884,240,248,264,
            315,321,2361,3224,1011,1848,108,1506,109,110,
            1521,89,93,79,90,92,94,95,1341,620,
            621,624,143,219,77,78,80,217,111,112,
            113,114,1345,120,121,122,132,1879,218,201,
            204,1494,212,220,232,233,3560,286,297,330,
            356,628,627,1865,1891,196,1871,1889,186,1867,
            1895,176,1873,1888,169,1872,1897,163,1882,1886,
            157,1881,2110,151,316,7713,141,2285,146,1884,
            240,248,264,315,321,2361,3224,1011,1848,108,
            1506,109,110,1521,89,93,79,90,92,94,
            95,1341,620,621,624,143,219,77,78,80,
            217,111,112,113,114,1345,120,121,122,132,
            1879,218,201,204,1494,212,220,232,233,3562,
            286,297,330,356,628,627,1865,1891,196,1871,
            1889,186,1867,1895,176,1873,1888,169,1872,1897,
            163,1882,1886,157,1881,2110,151,316,346,141,
            2285,146,1884,240,248,264,315,321,2361,3224,
            1011,1848,108,1506,109,110,1521,89,93,79,
            90,92,94,95,1341,620,621,624,143,219,
            77,78,80,217,111,112,113,114,1345,120,
            121,122,132,1879,218,201,204,1494,212,220,
            232,233,3564,286,297,330,356,628,627,1865,
            1891,196,1871,1889,186,1867,1895,176,1873,1888,
            169,1872,1897,163,1882,1886,157,1881,2110,151,
            316,345,141,2285,146,1884,240,248,264,315,
            321,2361,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1345,120,121,122,132,1879,218,201,204,
            1494,212,220,232,233,3565,286,297,330,356,
            628,627,1865,1891,196,1871,1889,186,1867,1895,
            176,1873,1888,169,1872,1897,163,1882,1886,157,
            1881,2110,151,316,482,141,2285,146,1884,240,
            248,264,315,321,2463,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1349,120,121,122,132,3984,
            218,201,204,1494,212,220,232,233,3571,286,
            297,330,356,628,627,1865,1891,196,1871,1889,
            186,1867,1895,176,1873,1888,169,1872,1897,163,
            1882,1886,157,153,3985,152,2463,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1349,120,121,122,
            132,4000,218,201,204,1494,212,220,232,233,
            3572,286,297,330,356,628,627,1865,1891,196,
            1871,1889,186,1867,1895,176,171,4001,170,2463,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1349,
            120,121,122,132,3988,218,201,204,1494,212,
            220,232,233,3573,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,179,3989,636,2463,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1349,
            120,121,122,132,3988,218,201,204,1494,212,
            220,232,233,3579,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,179,3990,178,2463,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1349,
            120,121,122,132,3988,218,201,204,1494,212,
            220,232,233,3239,286,297,330,356,628,627,
            1865,1891,196,1871,1889,186,179,3991,177,2463,
            3224,1011,1848,108,1506,109,110,1521,89,93,
            79,90,92,94,95,1341,620,621,624,143,
            219,77,78,80,217,111,112,113,114,1349,
            120,121,122,132,3995,218,201,204,1494,212,
            220,232,233,9163,286,297,330,356,628,627,
            1865,1891,196,191,3996,190,2463,3224,1011,1848,
            108,1506,109,110,1521,89,93,79,90,92,
            94,95,1341,620,621,624,143,219,77,78,
            80,217,111,112,113,114,1349,120,121,122,
            132,3995,218,201,204,1494,212,220,232,233,
            9163,286,297,330,356,628,627,1865,1891,196,
            191,3997,189,2463,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1349,120,121,122,132,3995,218,
            201,204,1494,212,220,232,233,9163,286,297,
            330,356,628,627,1865,1891,196,191,3998,188,
            2463,3224,1011,1848,108,1506,109,110,1521,89,
            93,79,90,92,94,95,1341,620,621,624,
            143,219,77,78,80,217,111,112,113,114,
            1349,120,121,122,132,3995,218,201,204,1494,
            212,220,232,233,9163,286,297,330,356,628,
            627,1865,1891,196,191,3999,187,2463,3224,1011,
            1848,108,1506,109,110,1521,89,93,79,90,
            92,94,95,1341,620,621,624,143,219,77,
            78,80,217,111,112,113,114,1349,120,121,
            122,132,3992,218,201,204,1494,212,220,232,
            233,9163,286,297,330,356,628,627,199,3993,
            198,2463,3224,1011,1848,108,1506,109,110,1521,
            89,93,79,90,92,94,95,1341,620,621,
            624,143,219,77,78,80,217,111,112,113,
            114,1349,120,121,122,132,3992,218,201,204,
            1494,212,220,232,233,3580,286,297,330,356,
            628,627,199,3994,197,2463,3224,1011,1848,108,
            1506,109
        };
    };

    public interface BaseAction1 {
        public final static char baseAction1[] = {
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1349,120,121,122,132,3594,218,
            207,214,1494,212,220,232,233,9163,286,297,
            330,356,628,627,2463,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1349,120,121,122,132,3594,
            218,207,213,1494,212,220,232,233,9163,286,
            297,330,356,628,627,9163,211,2651,9163,9163,
            9163,9163,9163,2463,3224,1011,1848,108,1506,109,
            110,1521,89,93,79,90,92,94,95,1341,
            620,621,624,143,219,77,78,80,217,111,
            112,113,114,1349,120,121,122,132,3594,218,
            207,206,1494,212,220,232,233,210,286,297,
            330,356,628,627,2463,3224,1011,1848,108,1506,
            109,110,1521,89,93,79,90,92,94,95,
            1341,620,621,624,143,219,77,78,80,217,
            111,112,113,114,1349,120,121,122,132,3594,
            218,207,205,1494,212,220,232,233,2711,286,
            297,330,356,628,627,9163,203,61,40,1011,
            986,55,1325,57,58,9163,2614,3155,112,4209,
            1011,9163,9163,9163,9163,2849,3080,9163,88,40,
            1011,986,55,1325,57,58,479,9163,9163,9163,
            9163,9163,404,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,308,9163,9163,9163,202,9163,9163,
            550,2734,40,1011,986,55,1325,57,58,451,
            9163,9163,9163,9163,9163,3578,9163,9163,9163,9163,
            9163,9163,9163,112,685,1011,9163,9163,9163,3162,
            3577,225,228,9163,112,3599,1011,3443,1870,312,
            770,2710,40,1011,986,55,1325,57,58,72,
            2946,471,225,228,71,1339,348,579,3583,480,
            397,398,399,400,401,402,794,3698,467,516,
            517,518,8913,8721,528,529,8901,534,535,1637,
            543,544,784,1229,3577,225,228,444,445,446,
            447,448,449,1323,451,467,516,517,518,8913,
            8721,528,529,8901,534,535,1637,543,544,784,
            1229,578,681,88,40,1011,986,55,1325,57,
            58,3583,9163,269,3577,225,228,8623,477,1372,
            1470,70,9163,9163,442,69,9163,9163,9163,9163,
            9163,88,40,1011,986,55,1325,57,58,7080,
            9163,660,3698,9163,9163,9163,9163,272,392,387,
            9163,394,395,396,405,406,851,409,410,825,
            9163,2584,444,445,446,447,448,449,1323,9163,
            467,516,517,518,8913,8721,528,529,8901,534,
            535,1637,543,544,784,1229,3577,225,228,88,
            40,1011,986,55,1325,57,58,88,40,1011,
            986,55,1325,57,58,684,1869,2685,640,442,
            9163,8919,3590,659,3575,225,228,88,40,1011,
            986,55,1325,57,58,88,40,1011,986,55,
            1325,57,58,88,40,1011,986,55,1325,57,
            58,88,40,1011,986,55,1325,57,58,88,
            40,1011,986,55,1325,57,58,8175,9163,2275,
            418,3142,986,668,583,670,669,2575,685,1011,
            9163,9163,3602,225,228,2185,219,685,1011,3157,
            1866,225,228,88,40,1011,986,55,1325,57,
            58,88,40,1011,986,55,1325,57,58,2280,
            4005,225,228,520,112,4209,1011,2605,4176,225,
            228,389,9163,426,430,431,66,225,228,658,
            421,9163,2844,460,4195,225,228,9163,112,3599,
            1011,9163,4922,225,228,88,40,1011,986,55,
            1325,57,58,88,40,1011,986,55,1325,57,
            58,306,8843,1342,1343,2275,681,2538,986,668,
            2686,670,669,480,9163,681,1636,225,228,9163,
            1,1849,1224,9163,472,225,228,3108,40,1011,
            8856,2874,4007,9163,8493,4006,662,112,3599,1011,
            112,685,1011,8669,3059,72,227,3315,1011,618,
            71,658,347,9163,551,426,430,431,112,40,
            1011,295,468,1628,547,3006,685,1011,6997,225,
            228,657,9163,2511,9163,223,1344,225,228,631,
            1350,2614,476,1372,219,685,1011,3116,684,3173,
            413,415,417,3443,112,685,1011,9163,1874,1342,
            1343,2629,2157,2930,2930,252,1485,2930,3443,490,
            3443,9163,4210,307,850,2930,8493,656,662,1926,
            3443,662,9163,2775,9163,537,9163,9163,683,681,
            1339,375,9163,532,70,9163,9163,63,69,390,
            9163,9163,9163,425,1849,525,252,567,572,9163,
            9163,585,97,657,6333,9163,463,8289,4197,576,
            8935,3582,9163,438,422,9163,3595,478,4208,9163,
            9163,9163,4198,682,456,2287,9163,371,9163,457,
            536,9163,8493,485,662,9163,420,2888,4004,566,
            571,9163,9163,584,269,9163,269,458,9163,9163,
            9163,575,249,2713,9163,519,284,1481,9163,9163,
            9163,9163,3581,475,9163,9163,9163,9163,9163,655,
            9163,9163,9163,9163,3714,1877,9163,9163,270,9163,
            271,3114,3574,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,3598,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,8741,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,1367,
            8761,9163,9163,424,9163,9163,9163,860,9163,9163,
            565,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            489,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,1883,9163,
            0
        };
    };

    public final static char baseAction[] = new char[BaseAction0.baseAction0.length + BaseAction1.baseAction1.length];
    {
        int index = 0;
        System.arraycopy(BaseAction0.baseAction0, 0, baseAction, index, BaseAction0.baseAction0.length);
        index += BaseAction0.baseAction0.length;
        System.arraycopy(BaseAction1.baseAction1, 0, baseAction, index, BaseAction1.baseAction1.length);
    };
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static char termCheck[] = {0,
            0,1,2,3,0,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,52,53,54,55,56,57,58,59,
            0,0,0,3,64,5,6,7,0,1,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,0,88,0,
            3,2,5,6,7,0,36,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,3,115,5,6,7,24,
            52,53,54,55,56,57,58,59,66,0,
            1,2,3,133,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            119,52,53,54,55,56,57,58,59,138,
            61,0,1,0,3,2,5,6,7,0,
            1,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,0,25,26,0,1,
            0,3,2,5,6,7,0,0,1,3,
            3,5,6,7,0,1,2,3,109,5,
            6,7,8,9,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,24,25,
            26,27,28,29,30,31,32,33,34,35,
            36,37,38,39,40,41,42,43,44,45,
            46,47,48,49,50,65,52,53,54,55,
            56,57,58,59,0,1,2,3,64,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            0,52,53,54,55,56,57,58,59,0,
            1,2,3,4,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            60,52,53,54,55,56,57,58,59,0,
            1,2,3,0,5,6,7,8,9,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            0,52,53,54,55,56,57,58,59,0,
            61,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,62,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,60,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,60,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,60,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,52,53,54,55,56,57,58,
            59,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,60,52,53,54,55,56,57,58,
            59,0,1,2,3,0,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,52,53,54,55,56,57,58,
            59,0,61,0,1,2,3,62,5,6,
            7,8,9,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,24,25,26,
            27,28,29,30,31,32,33,34,35,36,
            37,38,39,40,41,42,43,44,45,46,
            47,48,49,50,62,52,53,54,55,56,
            57,58,59,62,61,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,60,52,53,54,
            55,56,57,58,59,0,1,2,3,4,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,60,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,107,52,53,54,
            55,56,57,58,59,0,1,2,3,60,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,60,52,53,54,
            55,56,57,58,59,0,1,2,3,60,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,1,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,0,2,3,0,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,52,53,54,
            55,56,57,58,59,0,70,2,3,63,
            5,6,7,8,9,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,24,
            25,26,27,28,29,30,31,32,33,34,
            35,36,37,38,39,40,41,42,43,44,
            45,46,47,48,49,50,0,1,2,3,
            0,0,1,3,3,5,6,7,0,64,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,1,0,3,4,5,
            6,7,24,88,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,0,25,
            26,3,0,5,6,7,0,0,2,3,
            115,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,0,1,85,
            3,4,60,87,0,1,64,3,0,0,
            64,64,98,99,10,11,12,13,14,15,
            16,17,18,19,20,21,22,23,0,1,
            0,3,2,3,88,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,73,74,75,76,0,1,83,79,4,
            0,82,2,3,64,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,0,0,2,3,60,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,0,51,2,3,0,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,0,46,47,
            0,1,0,3,2,5,6,7,0,1,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,0,25,26,0,1,0,
            3,2,5,6,7,0,0,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,25,26,0,0,0,3,0,5,
            6,7,8,9,0,1,0,3,60,5,
            6,7,64,0,1,2,52,53,54,55,
            56,57,58,59,0,85,0,33,34,35,
            61,37,8,9,0,1,2,62,98,99,
            103,0,66,0,1,2,70,71,72,0,
            1,0,85,78,78,4,62,62,0,1,
            62,63,68,69,51,98,99,73,74,75,
            76,77,81,78,61,81,100,81,84,66,
            0,87,2,0,1,79,62,4,62,63,
            66,97,68,69,70,71,72,73,74,75,
            76,77,78,108,80,81,102,66,84,51,
            61,87,71,72,0,0,1,0,3,61,
            62,97,0,0,100,10,11,12,13,14,
            15,16,17,18,19,20,21,22,23,0,
            0,1,3,60,5,6,7,0,114,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,0,25,26,3,0,5,6,
            7,0,1,10,11,12,13,14,15,16,
            17,18,19,20,21,22,23,65,25,26,
            0,1,112,79,114,0,82,0,83,0,
            85,2,0,86,0,1,89,90,91,62,
            93,94,95,98,99,92,0,1,101,24,
            4,24,51,83,77,0,86,80,0,89,
            90,91,92,93,94,95,96,66,0,0,
            1,101,102,4,104,105,8,9,51,24,
            60,61,0,86,140,51,89,90,91,119,
            93,94,95,61,0,0,1,3,64,5,
            6,7,0,0,134,3,60,137,0,1,
            0,141,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,33,34,35,
            62,0,38,0,66,2,68,69,70,71,
            72,73,74,75,76,77,51,0,80,81,
            3,0,84,0,51,60,61,10,11,12,
            13,14,15,16,17,18,19,20,21,22,
            23,0,64,0,79,2,66,82,0,8,
            9,71,72,101,102,83,0,0,78,0,
            1,83,0,62,86,8,9,89,90,91,
            92,93,94,95,96,0,1,0,77,0,
            100,80,104,105,63,8,9,0,124,125,
            126,127,128,129,130,131,73,74,75,76,
            83,0,0,62,61,0,1,66,3,68,
            69,70,71,72,73,74,75,76,77,62,
            61,80,81,66,62,68,69,70,71,72,
            73,74,75,76,77,0,1,80,3,64,
            5,6,7,66,0,68,69,70,71,72,
            73,74,75,76,0,0,0,1,83,0,
            1,86,8,0,89,90,91,92,93,94,
            95,96,0,1,73,74,75,76,24,104,
            105,27,28,29,30,31,32,0,0,1,
            2,112,113,0,0,8,9,0,0,97,
            0,8,8,116,117,118,8,51,64,0,
            51,2,0,1,51,0,60,61,63,4,
            0,86,24,51,61,27,28,29,30,31,
            32,0,60,61,0,79,2,0,82,51,
            3,0,5,6,7,0,1,0,51,61,
            0,0,0,66,66,68,69,70,71,72,
            66,24,69,69,70,71,72,79,0,60,
            82,0,63,61,65,103,67,142,143,0,
            145,146,62,63,0,51,0,1,116,117,
            118,0,92,2,60,0,51,63,78,65,
            0,67,0,1,0,1,0,66,0,64,
            0,70,71,72,62,0,0,1,2,9,
            73,74,75,76,73,74,75,76,108,77,
            0,0,80,88,66,64,136,51,70,71,
            72,62,63,0,0,0,60,0,64,0,
            0,51,9,51,63,8,65,78,67,51,
            65,61,0,61,60,0,51,96,0,61,
            0,1,2,0,9,2,61,0,68,2,
            96,110,0,0,2,79,0,0,82,0,
            60,0,1,2,110,8,0,8,0,0,
            0,51,0,0,60,9,111,9,63,9,
            79,68,62,82,0,85,69,0,0,2,
            2,0,1,78,120,139,0,65,2,85,
            0,1,0,68,4,0,4,2,65,0,
            1,0,65,60,0,1,0,65,0,0,
            67,65,4,51,51,0,69,8,69,0,
            61,2,0,60,68,0,68,2,68,67,
            0,0,2,0,60,107,27,0,0,0,
            0,67,65,65,4,64,0,0,0,121,
            4,65,60,0,0,51,2,0,0,0,
            65,24,3,0,0,2,65,3,60,0,
            0,2,0,0,0,0,4,0,0,0,
            0,0,3,3,51,4,0,0,0,51,
            84,0,0,2,2,0,0,2,2,84,
            0,0,63,0,0,0,0,0,109,87,
            4,0,0,2,0,3,63,0,4,0,
            0,63,0,0,0,51,51,4,97,0,
            0,2,0,63,4,88,63,0,61,51,
            0,4,64,0,24,2,0,0,0,3,
            3,65,65,0,0,51,0,4,4,111,
            4,0,0,0,64,64,4,64,63,0,
            0,0,0,0,0,0,4,0,0,4,
            123,4,0,0,0,0,4,0,4,0,
            0,67,0,61,87,0,4,0,81,4,
            0,4,62,84,4,0,0,0,0,2,
            4,63,4,0,51,2,0,0,0,2,
            4,51,4,0,63,103,0,0,0,0,
            4,3,0,64,0,0,4,0,51,65,
            0,51,0,0,4,67,63,4,0,0,
            45,0,67,0,0,4,67,4,4,0,
            0,0,0,0,4,4,4,0,0,0,
            0,0,0,0,0,0,0,0,0,106,
            0,0,0,0,61,0,0,0,0,0,
            0,0,63,0,0,0,0,0,0,0,
            51,67,67,132,67,0,0,0,0,67,
            62,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,70,
            0,62,0,0,0,63,0,0,67,0,
            113,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,106,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,122,0,0,0,0,0,0,0,
            0,0,135,0,0,0,0,144,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0
        };
    };
    public final static char termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            9163,9543,564,564,393,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,564,564,564,564,564,564,564,564,564,
            564,9163,564,564,564,564,564,564,564,564,
            9163,9163,9163,3592,564,9199,3591,9792,9163,9543,
            9213,9214,9215,9216,9217,9208,9206,9209,9207,9205,
            975,9210,9212,9211,443,944,946,9163,564,9163,
            9197,1832,9199,9793,9792,9163,9744,9213,9214,9215,
            9216,9217,9208,9206,9209,9207,9205,975,9210,9212,
            9211,9163,944,946,9197,564,9199,9793,9792,9264,
            605,605,605,605,605,605,605,605,2464,9163,
            9543,4961,9197,8915,9199,9793,9792,9268,8236,9213,
            9214,9215,9216,9217,9208,9206,9209,9207,9205,1735,
            9210,9212,9211,9264,1509,1510,9262,9263,9266,9267,
            9270,9269,821,795,1850,9196,8185,971,3408,8790,
            9522,1864,1863,9523,1488,801,8399,3817,8914,791,
            9162,604,604,604,604,604,604,604,604,8839,
            686,9163,9543,9163,9197,1840,9199,9793,9792,9163,
            9543,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,975,9210,9212,9211,136,944,946,9163,9543,
            144,9197,136,9199,9793,9792,61,9163,9543,9197,
            1110,9199,9793,9792,9163,9543,4961,9197,6289,9199,
            9793,9792,9268,8236,9213,9214,9215,9216,9217,9208,
            9206,9209,9207,9205,1735,9210,9212,9211,9264,1509,
            1510,9262,9263,9266,9267,9270,9269,821,795,1850,
            9196,8185,971,3408,8790,9522,1864,1863,9523,1488,
            801,8399,3817,8873,791,40,604,604,604,604,
            604,604,604,604,9163,9543,843,972,369,9163,
            9543,4961,9197,137,9199,9793,9792,9268,8236,9213,
            9214,9215,9216,9217,9208,9206,9209,9207,9205,1735,
            9210,9212,9211,9264,1509,1510,9262,9263,9266,9267,
            9270,9269,821,795,1850,9196,8185,971,3408,8790,
            9522,1864,1863,9523,1488,801,8399,3817,8914,791,
            654,604,604,604,604,604,604,604,604,9163,
            9543,4961,9197,137,9199,9793,9792,9268,8236,9213,
            9214,9215,9216,9217,9208,9206,9209,9207,9205,1735,
            9210,9212,9211,9264,1509,1510,9262,9263,9266,9267,
            9270,9269,821,795,1850,9196,8185,971,3408,8790,
            9522,1864,1863,9523,1488,801,8399,3817,8914,791,
            8885,604,604,604,604,604,604,604,604,9163,
            9543,4961,9197,553,9199,9793,9792,9268,8236,9213,
            9214,9215,9216,9217,9208,9206,9209,9207,9205,1735,
            9210,9212,9211,9264,1509,1510,9262,9263,9266,9267,
            9270,9269,821,795,1850,9196,8185,971,3408,8790,
            9522,1864,1863,9523,1488,801,8399,3817,8914,791,
            541,604,604,604,604,604,604,604,604,488,
            686,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,5127,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,9163,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,8687,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,62,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,9286,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,1820,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,245,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,1633,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,249,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,137,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,3597,604,604,604,604,604,604,604,
            604,9163,9543,4961,9197,9163,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,9163,604,604,604,604,604,604,604,
            604,9163,686,9163,9543,4961,9197,987,9199,9793,
            9792,9268,8236,9213,9214,9215,9216,9217,9208,9206,
            9209,9207,9205,1735,9210,9212,9211,9264,1509,1510,
            9262,9263,9266,9267,9270,9269,821,795,1850,9196,
            8185,971,3408,8790,9522,1864,1863,9523,1488,801,
            8399,3817,8914,791,5459,604,604,604,604,604,
            604,604,604,5625,686,9163,9543,4961,9197,137,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,138,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,137,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,4463,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,137,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,83,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,87,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,3611,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,648,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,5708,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,8885,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,72,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,141,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,1630,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,3729,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,9163,9543,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,243,647,4961,9197,9163,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8914,791,9163,604,604,604,
            604,604,604,604,604,604,785,4961,9197,8819,
            9199,9793,9792,9268,8236,9213,9214,9215,9216,9217,
            9208,9206,9209,9207,9205,1735,9210,9212,9211,9264,
            1509,1510,9262,9263,9266,9267,9270,9269,821,795,
            1850,9196,8185,971,3408,8790,9522,1864,1863,9523,
            1488,801,8399,3817,8873,791,9163,9543,1375,972,
            9163,9163,9543,9197,9834,9199,9793,9792,35,568,
            9213,9214,9215,9216,9217,9208,9206,9209,9207,9205,
            9191,9210,9212,9211,9163,9543,149,661,653,661,
            661,661,9200,568,661,661,661,661,661,661,
            661,661,661,661,661,661,661,661,324,661,
            661,9197,9163,9199,9793,9792,604,9163,4961,9197,
            8916,9199,9793,9792,9268,8236,9213,9214,9215,9216,
            9217,9208,9206,9209,9207,9205,1735,9210,9212,9211,
            9264,1509,1510,9262,9263,9266,9267,9270,9269,821,
            795,1850,9196,8185,971,3408,8790,9522,1864,1863,
            9523,1488,801,8399,3817,8873,791,595,597,9826,
            13431,597,1225,153,9163,9543,9259,9837,173,428,
            367,2977,9827,9828,9213,9214,9215,9216,9217,9208,
            9206,9209,9207,9205,975,9210,9212,9211,9163,9543,
            604,9839,4961,9197,367,9199,9793,9792,9268,8236,
            9213,9214,9215,9216,9217,9208,9206,9209,9207,9205,
            1735,9210,9212,9211,9264,1509,1510,9262,9263,9266,
            9267,9270,9269,821,795,1850,9196,8185,971,3408,
            8790,9522,1864,1863,9523,1488,801,8399,3817,8914,
            791,179,179,179,179,9163,9543,9838,1333,9409,
            604,1334,4961,9197,82,9199,9793,9792,9268,8236,
            9213,9214,9215,9216,9217,9208,9206,9209,9207,9205,
            1735,9210,9212,9211,9264,1509,1510,9262,9263,9266,
            9267,9270,9269,821,795,1850,9196,8185,971,3408,
            8790,9522,1864,1863,9523,1488,801,8399,3817,8914,
            791,604,9163,4961,3718,1633,9199,9793,9792,9268,
            8236,9213,9214,9215,9216,9217,9208,9206,9209,9207,
            9205,1735,9210,9212,9211,9264,1509,1510,9262,9263,
            9266,9267,9270,9269,821,795,1850,9196,8185,971,
            3408,8790,9522,1864,1863,9523,1488,801,8399,3817,
            8914,791,604,9566,4961,9197,9163,9199,9793,9792,
            9268,8236,9213,9214,9215,9216,9217,9208,9206,9209,
            9207,9205,1735,9210,9212,9211,9264,1509,1510,9262,
            9263,9266,9267,9270,9269,821,795,1850,9196,8185,
            971,3408,8790,9522,1864,1863,9523,560,801,8399,
            9163,9543,9163,661,8858,661,661,661,9163,9543,
            661,661,661,661,661,661,661,661,661,661,
            661,661,661,661,9163,661,661,9163,9543,9163,
            661,8858,661,661,661,363,209,661,661,661,
            661,661,661,661,661,661,661,661,661,661,
            661,161,661,661,604,259,9163,9197,9163,9199,
            9793,9792,9177,9176,9163,9543,469,9197,827,9199,
            9793,9792,235,9163,9543,8737,9763,9765,9773,9775,
            9764,9766,9774,9776,142,9826,9163,966,953,1850,
            8849,9166,200,192,9163,9543,4297,6870,9827,9828,
            1476,349,215,9163,9543,8737,215,215,215,9163,
            9543,9163,9826,6787,215,9815,9173,9424,9163,9543,
            5044,8651,9175,9178,639,9827,9828,9172,9169,9171,
            9170,9174,165,9425,639,9164,215,7606,9167,8896,
            311,9168,4297,9163,9543,8420,172,9413,5376,8703,
            216,9165,192,200,216,216,216,180,180,180,
            180,172,216,9426,172,166,8852,815,160,9687,
            4878,154,771,9513,414,9163,9543,9163,661,686,
            4795,148,56,9163,216,661,661,661,661,661,
            661,661,661,661,661,661,661,661,661,9163,
            9163,9543,3578,3597,9199,9793,9792,167,3724,9213,
            9214,9215,9216,9217,9208,9206,9209,9207,9205,975,
            9210,9212,9211,577,944,946,9197,9163,9199,9793,
            9792,9163,9543,9213,9214,9215,9216,9217,9208,9206,
            9209,9207,9205,975,9210,9212,9211,1003,944,946,
            9163,9543,2469,1333,3724,464,1334,9163,661,9163,
            9826,8593,9163,9809,9163,9543,8822,9686,9685,171,
            9807,9808,1519,9827,9828,2197,9163,9543,8475,9264,
            9778,9265,391,8893,171,91,642,171,9163,642,
            642,642,2107,642,642,642,962,8896,154,9163,
            9543,642,8738,9413,786,824,200,192,9804,9265,
            8753,470,434,9809,1364,8409,8822,9686,9685,386,
            9807,9808,1519,799,604,9163,9543,9197,368,9199,
            9793,9792,9163,368,8729,9837,1314,1480,9163,9543,
            349,1824,9213,9214,9215,9216,9217,9208,9206,9209,
            9207,9205,975,9210,9212,9211,9265,966,953,1850,
            172,9163,3705,9163,216,8737,192,200,216,216,
            216,180,180,180,180,172,433,9163,172,166,
            9837,9163,160,9163,9530,1511,433,9213,9214,9215,
            9216,9217,9208,9206,9209,9207,9205,975,9210,9212,
            9211,160,3136,9163,433,8593,815,433,9163,200,
            192,771,9513,9599,9600,9838,9163,166,4009,9163,
            9543,8893,9163,7789,642,200,192,642,642,642,
            2107,642,642,642,962,9163,9543,172,7729,9163,
            3900,7669,786,824,8659,200,192,549,9495,9496,
            9497,9498,9499,9500,9440,9441,8020,7963,7906,7849,
            9838,635,9163,172,1380,595,597,216,13431,192,
            200,216,216,216,180,180,180,180,172,172,
            686,172,166,216,5376,192,200,216,216,216,
            180,180,180,180,172,9163,9543,172,9197,3137,
            9199,9793,9792,216,9163,192,200,216,216,216,
            180,180,180,180,236,9163,9163,9543,8893,9163,
            9543,642,9268,9163,642,642,642,2107,642,642,
            642,962,9163,9543,8020,7963,7906,7849,9264,786,
            824,9262,9263,9266,9267,9270,9269,180,9163,9543,
            8737,1737,9456,193,192,200,192,9163,9163,7534,
            9163,199,200,9721,9720,9719,9268,432,9539,144,
            9673,136,9163,9543,9708,9163,1511,432,8679,9389,
            9163,9658,9264,555,8832,9262,9263,9266,9267,9270,
            9269,9163,3601,555,144,432,136,9163,432,423,
            9197,208,9199,9793,9792,9163,9543,175,9551,423,
            9163,174,168,216,8896,192,200,216,216,216,
            216,9264,199,200,216,216,216,423,200,854,
            423,483,8695,8769,40,555,65,9654,9657,300,
            9656,9655,9424,774,483,65,9163,9543,555,555,
            555,144,1123,136,1132,358,3491,8797,9425,40,
            9163,65,9163,9543,9163,9543,429,216,9163,368,
            181,216,216,216,7789,9163,9163,9543,8817,191,
            8020,7963,7906,7849,8020,7963,7906,7849,9426,7729,
            9163,416,7669,368,216,474,2374,455,216,216,
            216,6455,8711,9163,9163,9163,844,9163,367,9163,
            9163,9701,8077,9694,8695,8346,40,6040,65,9574,
            1003,686,9163,686,2710,185,9570,962,498,1111,
            9163,9543,782,9163,8077,2202,1318,9163,191,2291,
            962,8906,136,281,2380,1333,673,195,1334,194,
            1220,9163,9543,3402,8906,8346,184,8346,183,9163,
            182,9677,9163,9163,1008,8077,3861,8077,8711,8077,
            1333,8131,6123,1334,9163,5293,8295,461,9163,984,
            2805,9163,9543,6040,9647,8905,9163,1852,2894,4380,
            9163,9543,9163,8131,9769,650,9288,8737,1003,9163,
            9543,9163,1003,6084,9163,9543,155,41,9163,9163,
            4629,1854,9289,1625,8486,9163,8295,9268,8295,9163,
            1231,1935,9163,8410,8131,9163,8131,4092,8131,6621,
            9163,145,830,9163,8410,819,9262,465,9163,9163,
            9163,7368,1003,1327,9223,9467,9163,573,666,1505,
            9222,1335,4463,34,9163,9547,5210,9163,9163,9163,
            1003,9265,972,9163,9163,2024,1354,3726,4463,9163,
            630,2113,9163,34,9163,9163,9384,9163,9163,9163,
            352,9163,9830,13430,9689,1112,9163,136,9163,9801,
            159,9163,355,1732,1023,339,338,8766,1638,3070,
            9163,9163,8695,9163,264,34,9163,150,6953,2556,
            8489,9163,9163,5957,9163,9800,8565,162,3139,156,
            466,8453,319,9163,9163,9676,9613,9392,147,9163,
            9163,2627,9163,580,3983,8927,582,9163,8723,5791,
            9163,9292,9724,135,9265,2716,9163,9163,9163,4202,
            9442,1359,40,9163,9163,5874,9163,1878,9520,3701,
            9754,9163,9163,9163,9393,9390,9753,9244,8711,9163,
            9163,327,9163,9163,136,9163,9293,9163,9163,1353,
            1529,9287,9163,65,9163,9163,9504,9163,9503,592,
            9163,9514,9163,686,2556,9163,8920,9163,7606,8922,
            9163,2983,6372,3070,9625,9163,9163,134,9163,3141,
            9290,9759,9291,9163,9675,3230,9163,9163,9163,3319,
            9750,9615,9749,9163,8703,6206,9163,9163,9163,9163,
            8932,9443,598,8784,9163,9163,9777,9163,9541,41,
            9163,9678,9163,9163,9281,6538,8695,9278,66,9163,
            1488,9163,6704,9163,9163,9294,4712,9752,9751,496,
            9163,9163,9163,505,9282,9280,9279,506,9163,481,
            509,352,595,9163,9163,9163,9163,9163,9163,9517,
            9163,9163,9163,9163,8769,9163,9163,9163,9163,9163,
            9163,9163,8805,9163,9163,9163,9163,9163,9163,9163,
            9544,7036,7119,3066,7202,9163,9163,9163,9163,7285,
            6372,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,1474,
            9163,7451,9163,9163,9163,4188,9163,9163,4179,9163,
            9455,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9660,9163,9163,9163,9163,9163,
            9163,9163,9163,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,9671,9163,9163,9163,9163,9163,9163,9163,
            9163,9163,1623,9163,9163,9163,9163,9667
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }

    public interface Asb {
        public final static char asb[] = {0,
            393,60,393,293,660,200,291,292,540,292,
            559,809,558,676,218,124,531,528,292,404,
            292,773,901,541,541,541,541,132,235,184,
            750,827,780,391,1,391,541,573,280,391,
            624,129,676,810,676,202,895,205,806,810,
            676,205,676,293,899,676,660,660,466,660,
            662,298,624,182,829,750,470,660,232,182,
            541,87,903,611,147,149,573,335,751,751,
            306,357,357,476,541,750,541,676,50,51,
            676,676,659,624,155,159,157,166,163,149,
            168,167,375,377,379,383,628,628,676,386,
            119,389,472,169,179,270,531,531,293,903,
            624,660,609,609,354,203,202,528,352,205,
            810,541,897,205,293,278,233,470,470,609,
            232,470,624,300,391,303,750,551,549,781,
            413,541,679,178,178,127,541,662,340,476,
            476,93,62,879,623,676,623,563,624,539,
            679,541,565,540,540,566,566,750,609,569,
            569,470,628,628,628,628,628,628,628,151,
            337,575,575,129,628,628,628,628,628,628,
            628,628,622,781,679,293,278,660,660,751,
            660,889,263,263,352,392,293,405,540,753,
            392,200,660,660,676,182,750,679,660,470,
            232,624,699,699,679,679,476,512,413,147,
            624,541,573,147,676,676,541,148,540,532,
            540,540,182,278,360,182,578,579,579,182,
            475,470,293,585,723,537,476,541,470,608,
            413,679,809,449,413,413,730,151,168,151,
            166,151,159,159,159,151,155,155,676,624,
            476,676,660,624,151,157,157,157,157,151,
            163,151,167,285,693,624,560,277,759,364,
            705,696,703,676,676,288,676,352,710,470,
            220,476,470,246,470,413,624,261,541,662,
            148,566,566,679,413,679,676,624,624,880,
            624,624,676,713,751,624,660,624,181,474,
            470,624,751,624,470,699,693,609,660,470,
            470,609,278,278,293,624,182,762,676,180,
            660,889,293,751,200,350,348,350,288,624,
            681,476,470,728,413,147,413,676,413,676,
            413,470,606,470,261,718,259,232,582,231,
            470,716,707,470,261,583,475,470,721,470,
            624,536,293,368,470,512,692,624,293,391,
            762,371,759,470,676,810,534,470,148,470,
            541,470,541,470,751,624,624,676,624,676,
            476,476,660,470,679,476,676,676,624,676,
            714,751,624,624,751,560,624,475,532,693,
            476,609,676,286,413,413,413,470,261,470,
            261,232,261,232,583,258,751,261,260,293,
            660,810,470,470,470,624,624,624,624,624,
            295,470,470,470,296,886,297,728,726,298,
            342,886,886,624,676,543
        };
    };
    public final static char asb[] = Asb.asb;
    public final int asb(int index) { return asb[index]; }

    public interface Asr {
        public final static char asr[] = {0,
            64,40,9,37,2,41,44,47,33,34,
            35,46,42,38,43,39,10,11,12,13,
            14,20,31,32,8,29,30,24,28,27,
            19,16,18,15,17,21,23,22,26,25,
            36,3,7,6,5,48,49,50,45,1,
            54,58,55,59,52,56,53,57,0,119,
            0,52,53,54,55,56,57,58,59,33,
            34,35,124,125,126,127,128,129,130,131,
            5,3,7,6,38,0,2,3,7,6,
            5,0,52,53,54,55,56,57,58,59,
            33,34,35,5,3,7,6,81,97,37,
            84,87,62,77,68,9,8,69,73,74,
            75,76,0,136,92,0,78,108,63,62,
            0,61,63,108,120,111,103,135,139,82,
            79,116,117,118,144,24,65,2,78,100,
            70,71,66,72,8,69,68,9,73,74,
            75,76,62,77,80,81,84,87,97,4,
            106,67,107,123,112,113,85,60,88,51,
            1,64,0,10,11,12,13,14,20,19,
            16,18,15,17,21,23,22,3,83,24,
            0,24,138,0,64,86,89,90,91,104,
            105,93,94,83,95,96,1,92,0,64,
            106,51,107,123,112,113,85,88,1,103,
            67,4,60,0,61,70,66,111,103,135,
            116,117,118,144,65,4,64,106,107,123,
            112,113,85,88,1,78,108,62,51,60,
            67,0,5,6,7,3,101,102,0,61,
            103,116,117,118,1,63,51,62,0,2,
            4,64,63,65,62,1,60,116,117,118,
            103,61,51,0,70,144,135,1,62,64,
            51,0,64,88,0,68,9,8,69,73,
            74,62,75,76,77,4,64,106,67,60,
            51,107,80,123,112,113,81,84,87,97,
            85,88,1,24,78,100,72,71,66,70,
            0,5,6,7,3,122,0,2,65,1,
            60,51,82,61,79,0,2,61,0,64,
            1,60,0,61,1,60,0,1,109,0,
            1,120,60,0,97,0,84,0,62,77,
            80,0,68,9,0,8,69,0,81,0,
            64,51,134,102,104,105,92,137,83,141,
            96,119,1,101,93,94,86,91,90,95,
            89,0,52,53,54,55,56,57,58,59,
            40,9,37,2,41,44,47,33,34,35,
            46,42,38,43,39,31,32,8,29,30,
            24,28,27,36,48,49,50,45,1,10,
            11,12,13,14,15,16,17,18,19,20,
            21,22,23,25,26,3,7,6,5,4,
            0,87,0,109,61,52,53,54,55,56,
            57,58,59,40,9,37,2,41,44,47,
            33,34,35,46,42,38,43,39,31,32,
            8,29,30,24,28,27,36,48,49,50,
            45,19,16,18,15,17,21,23,22,10,
            11,12,13,14,20,26,25,5,7,6,
            3,1,0,45,0,51,64,112,114,1,
            2,0,62,64,51,1,70,0,65,63,
            4,60,103,116,117,118,111,62,61,1,
            51,0,123,0,111,65,2,0,61,111,
            1,63,65,0,85,60,0,107,64,60,
            0,51,67,60,68,9,8,69,73,74,
            75,76,77,2,70,71,65,66,100,72,
            80,81,84,87,97,4,62,78,63,0,
            4,106,67,60,51,107,123,112,113,85,
            1,88,64,48,49,50,45,52,53,54,
            55,56,57,58,59,40,9,37,27,28,
            24,29,30,8,32,31,39,43,38,42,
            46,35,33,34,47,2,41,44,36,26,
            25,20,19,16,18,15,17,21,23,22,
            10,11,12,13,14,7,6,5,3,0,
            64,106,60,51,107,123,112,113,85,88,
            132,67,1,4,0,51,139,24,1,4,
            60,0,65,2,1,139,51,60,0,24,
            51,0,112,113,0,60,63,67,51,0,
            62,78,4,51,0,121,107,106,0,19,
            16,18,15,17,21,23,22,5,3,7,
            6,10,11,12,13,14,20,26,25,1,
            61,0,61,51,140,79,82,0,64,110,
            96,5,86,6,7,142,143,145,146,3,
            1,0,1,3,7,6,5,102,0,4,
            5,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,25,26,6,7,3,
            1,85,98,99,0,85,98,99,1,10,
            11,12,13,14,20,19,16,18,15,17,
            21,23,22,3,83,0,1,133,88,52,
            53,54,55,56,57,58,59,115,49,45,
            50,48,9,37,5,3,7,6,36,25,
            26,19,16,18,15,17,21,23,22,20,
            10,11,12,13,14,39,43,38,42,46,
            35,33,34,47,2,41,44,40,64,28,
            24,29,30,32,31,27,8,0,24,3,
            7,6,5,0,82,79,61,2,51,1,
            66,0,1,3,2,0
        };
    };
    public final static char asr[] = Asr.asr;
    public final int asr(int index) { return asr[index]; }

    public interface Nasb {
        public final static char nasb[] = {0,
            14,215,205,215,161,56,73,215,295,302,
            301,239,301,9,215,215,97,253,215,18,
            215,247,215,215,215,215,215,215,215,240,
            129,271,250,299,52,299,296,215,215,299,
            53,215,9,240,9,56,277,58,292,240,
            9,58,9,215,129,9,161,161,280,161,
            9,91,53,215,53,301,215,161,215,215,
            215,9,283,53,145,215,215,87,215,215,
            215,215,215,149,215,42,215,9,129,82,
            9,9,216,53,215,215,215,215,215,215,
            215,215,215,215,215,215,196,196,267,215,
            215,215,215,215,298,80,129,129,215,304,
            53,161,215,215,62,215,215,128,259,223,
            240,296,236,223,215,215,215,215,215,215,
            215,215,53,299,299,89,301,215,215,291,
            53,215,284,215,215,45,215,9,215,52,
            52,26,1,23,53,274,53,215,157,264,
            38,215,215,129,129,215,215,301,215,215,
            215,215,164,139,176,176,176,188,188,215,
            87,215,215,215,196,196,182,182,182,182,
            170,131,53,250,285,215,215,161,161,215,
            161,55,78,78,40,299,215,18,295,259,
            299,56,161,161,121,215,301,215,161,215,
            215,53,129,129,285,285,52,127,53,145,
            16,145,215,145,9,9,215,215,129,129,
            215,215,215,215,129,215,215,215,215,215,
            99,215,215,215,215,202,52,215,215,215,
            53,215,239,11,53,53,161,215,215,215,
            215,215,215,215,215,215,215,215,67,53,
            52,47,161,53,215,215,215,215,215,215,
            215,215,215,215,129,53,129,215,244,129,
            256,215,215,9,9,95,9,40,215,215,
            60,52,215,45,215,53,53,215,215,9,
            215,215,215,113,50,147,261,53,53,35,
            53,53,70,215,234,53,161,53,129,124,
            215,53,302,53,215,129,129,215,161,215,
            215,215,215,215,215,53,215,93,9,298,
            161,55,215,302,56,129,107,129,64,53,
            155,52,215,215,53,145,53,9,53,9,
            53,215,215,215,215,215,215,215,145,21,
            215,215,215,215,215,145,115,215,215,215,
            53,299,215,129,215,75,111,53,215,299,
            287,129,220,215,9,240,137,215,215,215,
            215,215,215,215,43,53,53,67,53,9,
            53,53,161,215,215,52,9,70,53,9,
            215,234,53,53,234,129,53,124,129,215,
            52,215,9,129,53,53,53,215,215,215,
            215,215,215,215,145,215,302,215,215,215,
            161,240,215,215,215,53,53,53,53,53,
            85,215,215,215,109,33,232,215,215,194,
            105,32,32,53,9,85
        };
    };
    public final static char nasb[] = Nasb.nasb;
    public final int nasb(int index) { return nasb[index]; }

    public interface Nasr {
        public final static char nasr[] = {0,
            16,210,211,193,192,209,19,176,2,0,
            177,178,0,219,0,216,0,175,180,0,
            195,0,190,8,0,16,2,184,19,176,
            0,10,9,0,8,150,0,155,0,106,
            0,44,154,0,152,0,2,101,0,91,
            97,44,16,3,2,8,0,164,0,204,
            0,246,0,264,262,0,2,97,0,2,
            115,0,260,0,179,177,0,166,0,281,
            0,277,278,0,173,0,159,0,269,0,
            258,0,250,0,261,0,244,0,2,3,
            8,16,196,0,257,0,240,0,251,0,
            276,0,199,0,2,3,8,16,197,0,
            2,91,0,8,16,86,3,2,44,0,
            16,3,8,2,68,0,72,0,3,8,
            16,2,65,0,92,0,194,0,16,3,
            8,2,198,0,208,0,80,16,8,121,
            2,3,0,3,8,16,2,71,0,16,
            3,8,2,62,0,3,8,16,2,59,
            0,16,3,8,2,56,0,3,8,16,
            2,53,0,253,0,2,3,8,16,38,
            0,201,156,0,228,128,231,134,135,138,
            141,145,102,220,0,2,3,275,0,172,
            171,0,134,135,128,138,141,145,102,169,
            0,252,0,120,0,232,44,0,44,3,
            95,94,0,249,172,0,2,222,0,181,
            109,0,2,238,0,243,44,0,165,0,
            2,214,0,200,44,0,279,2,188,0,
            267,44,0,2,187,0,236,44,0,186,
            2,0,44,151,100,0,2,255,44,0,
            146,109,44,0,44,99,0,44,90,0,
            44,86,0,100,44,0
        };
    };
    public final static char nasr[] = Nasr.nasr;
    public final int nasr(int index) { return nasr[index]; }

    public interface TerminalIndex {
        public final static char terminalIndex[] = {0,
            164,11,163,12,37,134,136,3,2,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,40,73,74,38,39,55,56,
            57,58,115,116,117,43,51,76,44,53,
            75,86,89,90,91,94,99,87,88,92,
            22,118,119,120,121,122,123,124,125,19,
            13,7,20,14,21,23,18,1,4,15,
            17,27,5,6,8,9,10,25,131,34,
            48,130,135,49,54,95,50,97,104,105,
            106,111,132,133,142,158,52,98,107,26,
            100,102,108,109,110,16,24,28,29,30,
            35,46,47,77,114,138,139,140,162,31,
            32,33,45,78,79,80,81,82,83,84,
            85,93,96,101,112,113,126,127,128,129,
            137,141,145,153,156,157,41,42,103,143,
            144,146,147,148,149,150,151,152,154,155,
            159,160,161
        };
    };
    public final static char terminalIndex[] = TerminalIndex.terminalIndex;
    public final int terminalIndex(int index) { return terminalIndex[index]; }

    public interface NonterminalIndex {
        public final static char nonterminalIndex[] = {0,
            167,168,166,0,170,0,0,182,181,183,
            0,0,0,0,0,0,0,0,296,0,
            0,0,0,0,0,0,0,0,0,185,
            0,0,0,0,188,0,0,213,214,0,
            0,0,0,219,0,0,0,0,0,0,
            209,210,211,206,207,208,203,204,205,200,
            201,202,197,198,199,194,195,196,191,192,
            193,241,175,186,189,0,190,0,0,224,
            0,0,171,0,0,226,187,0,270,0,
            173,0,277,301,302,0,176,178,260,222,
            174,255,212,254,261,263,0,0,0,289,
            0,0,0,169,177,180,0,220,0,225,
            227,0,0,0,0,0,0,0,269,0,
            0,0,0,278,279,0,0,282,0,0,
            283,0,0,284,285,300,0,179,216,217,
            221,223,231,235,237,239,240,248,0,0,
            0,250,252,0,259,0,264,0,265,268,
            273,0,0,280,281,292,0,0,293,298,
            299,0,0,165,0,172,184,215,0,218,
            0,228,229,230,0,232,233,234,236,238,
            0,0,0,0,0,0,0,0,242,243,
            244,245,246,247,0,0,249,0,0,251,
            0,253,0,0,0,0,0,256,0,0,
            257,258,0,0,0,0,0,262,0,0,
            0,266,0,267,0,0,0,271,272,0,
            0,0,0,274,275,276,0,0,0,0,
            0,286,0,287,288,0,0,0,0,0,
            0,0,0,290,291,0,294,295,297,0,
            0,0,0,0,0,0
        };
    };
    public final static char nonterminalIndex[] = NonterminalIndex.nonterminalIndex;
    public final int nonterminalIndex(int index) { return nonterminalIndex[index]; }

    public interface ScopePrefix {
        public final static char scopePrefix[] = {
            429,465,475,363,397,405,451,485,439,15,
            24,48,55,197,383,390,84,107,282,372,
            423,163,226,241,413,459,33,33,38,43,
            62,67,102,178,378,137,178,214,178,72,
            72,122,126,159,159,270,270,274,274,278,
            296,300,493,497,501,505,115,130,145,152,
            152,219,288,232,247,97,78,6,6,78,
            172,304,172,78,172,172,95,1,251,251,
            251,251,265,307,307,315,315,323,323,323,
            323,1,1,343,348,353,358
        };
    };
    public final static char scopePrefix[] = ScopePrefix.scopePrefix;
    public final int scopePrefix(int index) { return scopePrefix[index]; }

    public interface ScopeSuffix {
        public final static char scopeSuffix[] = {
            31,31,31,31,31,31,31,31,447,22,
            31,31,31,191,31,31,76,113,31,31,
            31,169,223,223,419,447,22,31,31,31,
            31,31,31,191,31,142,183,134,204,22,
            76,31,31,22,100,22,31,22,31,100,
            100,31,100,100,31,31,119,134,149,81,
            156,223,292,236,236,100,31,9,12,81,
            175,12,193,90,186,208,76,3,253,256,
            259,262,267,309,312,317,320,325,328,331,
            334,337,340,345,350,355,360
        };
    };
    public final static char scopeSuffix[] = ScopeSuffix.scopeSuffix;
    public final int scopeSuffix(int index) { return scopeSuffix[index]; }

    public interface ScopeLhs {
        public final static char scopeLhs[] = {
            29,28,28,31,31,31,29,28,29,18,
            18,176,176,41,31,31,156,29,85,31,
            31,29,45,45,31,29,17,17,50,50,
            176,176,48,41,31,82,41,192,41,202,
            202,209,209,154,154,79,79,119,119,43,
            42,84,23,22,7,6,214,47,72,156,
            156,45,85,45,45,86,39,40,40,156,
            41,40,41,156,41,41,157,62,80,80,
            80,80,151,53,53,56,56,59,59,59,
            59,62,62,65,68,71,76
        };
    };
    public final static char scopeLhs[] = ScopeLhs.scopeLhs;
    public final int scopeLhs(int index) { return scopeLhs[index]; }

    public interface ScopeLa {
        public final static char scopeLa[] = {
            4,4,4,4,4,4,4,4,67,1,
            4,4,4,113,4,4,51,106,4,4,
            4,4,4,4,60,67,1,4,4,4,
            4,4,4,113,4,4,112,4,112,1,
            51,4,4,1,64,1,4,1,4,64,
            64,4,64,64,4,4,67,4,4,4,
            4,4,60,51,51,64,4,85,85,4,
            123,85,123,4,123,123,51,80,100,100,
            78,78,60,69,8,9,68,76,75,74,
            73,77,62,81,84,87,97
        };
    };
    public final static char scopeLa[] = ScopeLa.scopeLa;
    public final int scopeLa(int index) { return scopeLa[index]; }

    public interface ScopeStateSet {
        public final static char scopeStateSet[] = {
            225,225,225,225,225,225,225,225,225,12,
            12,101,101,225,225,225,3,225,315,225,
            225,225,225,225,225,225,12,12,225,225,
            101,101,225,225,225,242,225,102,225,4,
            4,102,102,6,6,242,242,311,311,225,
            225,315,225,225,196,196,1,225,104,3,
            3,225,315,225,225,178,225,225,225,3,
            225,225,225,3,225,225,175,238,242,242,
            242,242,9,229,229,231,231,235,235,235,
            235,238,238,239,240,241,242
        };
    };
    public final static char scopeStateSet[] = ScopeStateSet.scopeStateSet;
    public final int scopeStateSet(int index) { return scopeStateSet[index]; }

    public interface ScopeRhs {
        public final static char scopeRhs[] = {0,
            224,0,80,222,0,442,40,0,85,207,
            0,85,236,0,341,60,256,2,441,179,
            0,207,0,342,60,256,2,441,179,0,
            4,0,341,2,440,179,0,251,2,168,
            34,0,251,2,168,33,0,251,2,164,
            65,164,34,0,251,2,164,65,164,33,
            0,251,2,164,34,0,251,2,164,33,
            0,236,109,112,0,51,0,236,2,0,
            4,207,0,236,109,4,236,2,0,4,
            109,236,51,0,236,0,381,61,0,64,
            0,251,2,380,46,0,236,379,70,322,
            193,0,106,0,278,51,321,0,67,236,
            0,377,2,374,0,376,2,373,0,318,
            2,42,0,4,249,0,236,2,369,50,
            0,4,371,0,251,2,45,0,4,367,
            0,236,2,114,0,4,320,0,364,363,
            61,0,362,2,38,71,193,0,4,317,
            0,236,39,0,123,359,0,316,123,236,
            39,0,112,360,0,123,316,112,360,0,
            113,0,123,316,113,0,316,112,316,123,
            236,39,0,112,316,113,0,123,316,112,
            316,113,0,358,357,2,356,0,236,2,
            43,0,4,283,0,236,51,243,2,43,
            0,243,2,43,0,51,236,4,283,0,
            236,51,284,2,43,0,284,2,43,0,
            193,0,100,207,0,100,236,0,78,207,
            0,78,236,0,263,0,60,263,0,263,
            2,49,0,314,2,49,0,352,61,25,
            0,246,60,246,2,25,0,246,2,25,
            0,60,246,4,0,310,61,26,0,246,
            2,26,0,351,40,0,215,0,69,201,
            0,8,201,0,218,0,9,216,0,68,
            216,0,221,0,76,219,0,75,219,0,
            74,219,0,73,219,0,77,222,0,62,
            222,0,227,0,81,225,0,230,0,84,
            228,0,233,0,87,231,0,240,0,97,
            234,0,251,2,255,277,65,168,66,193,
            0,251,2,277,65,168,0,251,2,255,
            164,0,251,2,255,164,66,193,0,251,
            2,255,347,66,193,0,250,60,164,2,
            164,71,193,0,250,60,237,2,164,71,
            193,0,237,2,164,71,193,0,60,250,
            4,0,236,2,164,71,193,0,236,67,
            260,51,261,2,164,71,193,0,260,51,
            261,2,164,71,193,0,67,236,4,0,
            236,67,260,2,164,71,193,0,260,2,
            164,71,193,0,236,67,261,60,254,2,
            164,71,193,0,236,67,261,60,164,2,
            164,71,193,0,236,67,261,2,164,71,
            193,0,350,61,20,0,310,61,166,0,
            348,2,20,0,246,2,166,0
        };
    };
    public final static char scopeRhs[] = ScopeRhs.scopeRhs;
    public final int scopeRhs(int index) { return scopeRhs[index]; }

    public interface ScopeState {
        public final static char scopeState[] = {0,
            8766,0,8769,8289,0,1353,971,0,843,8873,
            0,7451,7368,7285,7202,7119,7036,3319,3230,3141,
            4712,2983,6953,6870,6787,6704,4629,1132,3729,6621,
            6538,6455,6372,6289,1737,2894,2805,2716,2627,4546,
            6206,6123,6040,5957,2469,5874,5791,3611,5708,5625,
            1638,1023,5542,2380,4463,5459,5376,4380,5293,2291,
            2202,2113,4297,1529,2024,4214,5210,3491,2556,7606,
            8020,7963,7906,7849,8346,8295,8131,8077,7789,7729,
            7669,3070,7534,4092,1380,1231,4009,3900,1935,5127,
            5044,8236,8185,4961,3408,3817,860,4878,4795,686,
            815,771,0,7451,7368,7285,7202,7119,7036,3319,
            3230,3141,4712,6953,6870,6787,6704,4629,1132,3729,
            6621,6538,6455,3066,6372,6289,1737,2894,2805,2716,
            2627,4546,6206,6123,6040,5957,5874,5791,3611,5708,
            5625,1638,1023,5542,2380,4463,5459,5376,4380,5293,
            2291,2202,2113,4297,1529,2024,4214,5210,3491,4092,
            1380,1231,4009,3900,1935,5127,5044,4961,3408,3817,
            860,4878,4795,686,2983,2469,0,8932,2983,8922,
            8920,1737,8905,3139,2469,8489,1529,8927,8919,8916,
            8915,8913,8901,1637,0,3601,8805,8797,1370,8753,
            8745,8711,8703,8453,8817,774,8565,8695,8687,8420,
            8679,8659,1926,8651,8399,8493,8593,1840,1832,1519,
            1123,1013,8721,1824,8346,8295,8236,8185,8131,8077,
            8020,7963,7906,7849,7789,7729,7669,7606,3070,2556,
            7534,7451,7368,7285,7202,7119,7036,3319,3230,3141,
            4712,2983,6953,6870,6787,6704,4629,1132,3729,6621,
            6538,6455,6372,6289,1737,2894,2805,2716,2627,4546,
            6206,6123,6040,5957,2469,5874,5791,3611,5708,5625,
            1638,1023,5542,2380,4463,5459,5376,4380,5293,2291,
            2202,2113,4297,1529,2024,4214,5210,4092,1380,1231,
            4009,3900,1935,5127,5044,4961,3408,3817,4878,4795,
            3491,860,686,0,8805,8797,8753,8745,8711,8703,
            8453,774,8565,8695,8687,8420,8679,8659,8651,8399,
            8493,8593,1840,1832,1824,0
        };
    };
    public final static char scopeState[] = ScopeState.scopeState;
    public final int scopeState(int index) { return scopeState[index]; }

    public interface InSymb {
        public final static char inSymb[] = {0,
            0,345,382,265,141,96,308,307,83,304,
            301,298,297,92,104,105,137,102,394,291,
            391,134,246,25,26,20,166,165,168,171,
            103,61,2,249,61,249,256,257,258,249,
            62,252,92,92,136,3,267,61,89,95,
            101,61,102,326,267,66,2,2,2,2,
            65,256,61,422,430,133,445,272,344,381,
            45,50,49,48,164,202,168,193,25,26,
            171,20,166,39,43,38,42,46,35,179,
            34,33,47,2,214,220,217,226,223,198,
            232,229,240,230,224,218,37,9,40,215,
            221,227,233,238,325,262,65,65,236,49,
            62,63,252,256,252,404,171,66,399,327,
            272,256,267,327,326,252,246,246,348,164,
            349,246,62,236,64,431,115,246,3,60,
            2,369,2,314,263,3,255,65,322,100,
            78,66,71,61,61,61,61,236,2,61,
            2,380,168,441,440,168,168,437,438,6,
            3,236,97,84,80,77,62,9,68,198,
            193,351,442,164,69,8,76,75,74,73,
            81,87,51,63,2,236,246,63,63,409,
            79,138,79,82,328,64,265,291,256,395,
            64,62,60,63,60,253,88,111,63,251,
            250,2,314,263,60,60,315,63,2,277,
            70,347,168,164,34,33,38,164,356,375,
            374,373,352,312,353,310,236,311,350,310,
            123,236,284,3,243,363,2,114,318,3,
            2,111,2,2,2,2,63,198,233,198,
            227,198,221,221,221,198,215,215,60,85,
            85,60,63,62,198,218,218,218,218,198,
            224,198,230,344,263,62,246,246,61,411,
            405,171,168,329,329,337,140,328,171,246,
            4,60,236,246,251,2,379,3,255,65,
            255,164,164,2,2,2,2,2,62,60,
            107,60,60,316,4,51,63,51,364,112,
            236,2,4,78,251,256,341,3,340,251,
            251,164,164,246,236,62,410,335,110,412,
            60,60,406,139,2,330,168,330,424,103,
            4,315,251,236,2,277,2,65,2,65,
            2,362,3,236,260,261,254,237,164,357,
            377,164,321,376,261,164,112,236,246,236,
            109,249,236,4,236,60,246,62,236,64,
            413,417,51,292,60,427,132,251,255,251,
            164,251,164,251,4,62,67,51,67,60,
            60,60,63,358,60,67,60,51,67,60,
            316,4,78,62,4,236,109,4,341,342,
            67,252,60,428,2,2,2,236,260,236,
            261,250,261,250,164,246,4,278,321,236,
            63,60,251,251,251,67,67,67,67,67,
            246,236,236,236,336,70,414,419,172,415,
            135,107,121,62,420,252
        };
    };
    public final static char inSymb[] = InSymb.inSymb;
    public final int inSymb(int index) { return inSymb[index]; }

    public interface Name {
        public final static String name[] = {
            "", //$NON-NLS-1$
            "+", //$NON-NLS-1$
            "-", //$NON-NLS-1$
            "*", //$NON-NLS-1$
            "/", //$NON-NLS-1$
            ">", //$NON-NLS-1$
            "<", //$NON-NLS-1$
            "=", //$NON-NLS-1$
            ">=", //$NON-NLS-1$
            "<=", //$NON-NLS-1$
            "<>", //$NON-NLS-1$
            "(", //$NON-NLS-1$
            ")", //$NON-NLS-1$
            "{", //$NON-NLS-1$
            "}", //$NON-NLS-1$
            "[", //$NON-NLS-1$
            "]", //$NON-NLS-1$
            "->", //$NON-NLS-1$
            "|", //$NON-NLS-1$
            ",", //$NON-NLS-1$
            ":", //$NON-NLS-1$
            "::", //$NON-NLS-1$
            ";", //$NON-NLS-1$
            ".", //$NON-NLS-1$
            "..", //$NON-NLS-1$
            ":=", //$NON-NLS-1$
            "+=", //$NON-NLS-1$
            "!", //$NON-NLS-1$
            "::=", //$NON-NLS-1$
            "?", //$NON-NLS-1$
            "<<", //$NON-NLS-1$
            ">>", //$NON-NLS-1$
            "...", //$NON-NLS-1$
            "~", //$NON-NLS-1$
            "!=", //$NON-NLS-1$
            "@", //$NON-NLS-1$
            "$empty", //$NON-NLS-1$
            "QUOTED_IDENTIFIER", //$NON-NLS-1$
            "INTEGER_LITERAL", //$NON-NLS-1$
            "REAL_LITERAL", //$NON-NLS-1$
            "STRING_LITERAL", //$NON-NLS-1$
            "SINGLE_LINE_COMMENT", //$NON-NLS-1$
            "MULTI_LINE_COMMENT", //$NON-NLS-1$
            "self", //$NON-NLS-1$
            "if", //$NON-NLS-1$
            "then", //$NON-NLS-1$
            "else", //$NON-NLS-1$
            "endif", //$NON-NLS-1$
            "and", //$NON-NLS-1$
            "or", //$NON-NLS-1$
            "xor", //$NON-NLS-1$
            "not", //$NON-NLS-1$
            "implies", //$NON-NLS-1$
            "let", //$NON-NLS-1$
            "in", //$NON-NLS-1$
            "true", //$NON-NLS-1$
            "false", //$NON-NLS-1$
            "null", //$NON-NLS-1$
            "invalid", //$NON-NLS-1$
            "Set", //$NON-NLS-1$
            "Bag", //$NON-NLS-1$
            "Sequence", //$NON-NLS-1$
            "Collection", //$NON-NLS-1$
            "OrderedSet", //$NON-NLS-1$
            "String", //$NON-NLS-1$
            "Integer", //$NON-NLS-1$
            "UnlimitedNatural", //$NON-NLS-1$
            "Real", //$NON-NLS-1$
            "Boolean", //$NON-NLS-1$
            "Tuple", //$NON-NLS-1$
            "OclAny", //$NON-NLS-1$
            "OclVoid", //$NON-NLS-1$
            "OclInvalid", //$NON-NLS-1$
            "Dict", //$NON-NLS-1$
            "List", //$NON-NLS-1$
            "break", //$NON-NLS-1$
            "switch", //$NON-NLS-1$
            "case", //$NON-NLS-1$
            "xselect", //$NON-NLS-1$
            "xcollect", //$NON-NLS-1$
            "selectOne", //$NON-NLS-1$
            "collectOne", //$NON-NLS-1$
            "collectselect", //$NON-NLS-1$
            "collectselectOne", //$NON-NLS-1$
            "forEach", //$NON-NLS-1$
            "forOne", //$NON-NLS-1$
            "compute", //$NON-NLS-1$
            "return", //$NON-NLS-1$
            "var", //$NON-NLS-1$
            "while", //$NON-NLS-1$
            "continue", //$NON-NLS-1$
            "log", //$NON-NLS-1$
            "assert", //$NON-NLS-1$
            "with", //$NON-NLS-1$
            "new", //$NON-NLS-1$
            "static", //$NON-NLS-1$
            "init", //$NON-NLS-1$
            "end", //$NON-NLS-1$
            "out", //$NON-NLS-1$
            "object", //$NON-NLS-1$
            "transformation", //$NON-NLS-1$
            "import", //$NON-NLS-1$
            "library", //$NON-NLS-1$
            "metamodel", //$NON-NLS-1$
            "mapping", //$NON-NLS-1$
            "query", //$NON-NLS-1$
            "helper", //$NON-NLS-1$
            "inout", //$NON-NLS-1$
            "when", //$NON-NLS-1$
            "configuration", //$NON-NLS-1$
            "intermediate", //$NON-NLS-1$
            "property", //$NON-NLS-1$
            "opposites", //$NON-NLS-1$
            "class", //$NON-NLS-1$
            "population", //$NON-NLS-1$
            "map", //$NON-NLS-1$
            "xmap", //$NON-NLS-1$
            "late", //$NON-NLS-1$
            "resolve", //$NON-NLS-1$
            "resolveone", //$NON-NLS-1$
            "resolveIn", //$NON-NLS-1$
            "resolveoneIn", //$NON-NLS-1$
            "invresolve", //$NON-NLS-1$
            "invresolveone", //$NON-NLS-1$
            "invresolveIn", //$NON-NLS-1$
            "invresolveoneIn", //$NON-NLS-1$
            "modeltype", //$NON-NLS-1$
            "uses", //$NON-NLS-1$
            "where", //$NON-NLS-1$
            "refines", //$NON-NLS-1$
            "access", //$NON-NLS-1$
            "extends", //$NON-NLS-1$
            "blackbox", //$NON-NLS-1$
            "abstract", //$NON-NLS-1$
            "result", //$NON-NLS-1$
            "main", //$NON-NLS-1$
            "this", //$NON-NLS-1$
            "rename", //$NON-NLS-1$
            "disjuncts", //$NON-NLS-1$
            "merges", //$NON-NLS-1$
            "inherits", //$NON-NLS-1$
            "composes", //$NON-NLS-1$
            "constructor", //$NON-NLS-1$
            "datatype", //$NON-NLS-1$
            "default", //$NON-NLS-1$
            "derived", //$NON-NLS-1$
            "do", //$NON-NLS-1$
            "elif", //$NON-NLS-1$
            "enum", //$NON-NLS-1$
            "except", //$NON-NLS-1$
            "exception", //$NON-NLS-1$
            "from", //$NON-NLS-1$
            "literal", //$NON-NLS-1$
            "ordered", //$NON-NLS-1$
            "primitive", //$NON-NLS-1$
            "raise", //$NON-NLS-1$
            "readonly", //$NON-NLS-1$
            "references", //$NON-NLS-1$
            "tag", //$NON-NLS-1$
            "try", //$NON-NLS-1$
            "typedef", //$NON-NLS-1$
            "unlimited", //$NON-NLS-1$
            "EOF_TOKEN", //$NON-NLS-1$
            "IDENTIFIER", //$NON-NLS-1$
            "ERROR_TOKEN", //$NON-NLS-1$
            "conceptualOperationNameCS", //$NON-NLS-1$
            "CollectionTypeIdentifierCS", //$NON-NLS-1$
            "simpleNameCS", //$NON-NLS-1$
            "QuotedSimpleNameCS", //$NON-NLS-1$
            "unreservedSimpleNameCS", //$NON-NLS-1$
            "pathNameCS", //$NON-NLS-1$
            "typeCS", //$NON-NLS-1$
            "tupleTypePartsCS", //$NON-NLS-1$
            "typedUninitializedVariableCS", //$NON-NLS-1$
            "untypedInitializedVariableCS", //$NON-NLS-1$
            "OclExpressionCS", //$NON-NLS-1$
            "typedInitializedVariableCS", //$NON-NLS-1$
            "initializedVariableCS", //$NON-NLS-1$
            "uninitializedVariableCS", //$NON-NLS-1$
            "CollectionLiteralPartsCS", //$NON-NLS-1$
            "CollectionLiteralPartCS", //$NON-NLS-1$
            "IntegerLiteralExpCS", //$NON-NLS-1$
            "StringLiteralExpCS", //$NON-NLS-1$
            "UnlimitedNaturalLiteralExpCS", //$NON-NLS-1$
            "TupleLiteralPartsCS", //$NON-NLS-1$
            "primaryExpCS", //$NON-NLS-1$
            "notNameExpressionCS", //$NON-NLS-1$
            "argumentsCS", //$NON-NLS-1$
            "SimpleNameExpCS", //$NON-NLS-1$
            "impliesNotNameNotLetCS", //$NON-NLS-1$
            "impliesNotLetCS", //$NON-NLS-1$
            "xorNotNameNotLetCS", //$NON-NLS-1$
            "xorNotLetCS", //$NON-NLS-1$
            "xorWithLetCS", //$NON-NLS-1$
            "orNotNameNotLetCS", //$NON-NLS-1$
            "orNotLetCS", //$NON-NLS-1$
            "orWithLetCS", //$NON-NLS-1$
            "andNotNameNotLetCS", //$NON-NLS-1$
            "andNotLetCS", //$NON-NLS-1$
            "andWithLetCS", //$NON-NLS-1$
            "equalityNotNameNotLetCS", //$NON-NLS-1$
            "equalityNotLetCS", //$NON-NLS-1$
            "equalityWithLetCS", //$NON-NLS-1$
            "relationalNotNameNotLetCS", //$NON-NLS-1$
            "relationalNotLetCS", //$NON-NLS-1$
            "relationalWithLetCS", //$NON-NLS-1$
            "additiveNotNameNotLetCS", //$NON-NLS-1$
            "additiveNotLetCS", //$NON-NLS-1$
            "additiveWithLetCS", //$NON-NLS-1$
            "multiplicativeNotNameNotLetCS", //$NON-NLS-1$
            "multiplicativeNotLetCS", //$NON-NLS-1$
            "multiplicativeWithLetCS", //$NON-NLS-1$
            "unaryNotLetCS", //$NON-NLS-1$
            "unaryWithLetCS", //$NON-NLS-1$
            "primaryNotNameCS", //$NON-NLS-1$
            "letVariablesCS", //$NON-NLS-1$
            "literalSimpleCS", //$NON-NLS-1$
            "dictLiteralPartCS", //$NON-NLS-1$
            "dictLiteralPartListCS", //$NON-NLS-1$
            "qvtErrorToken", //$NON-NLS-1$
            "expression_semi_list_element", //$NON-NLS-1$
            "var_init_declarator_list", //$NON-NLS-1$
            "var_init_declarator", //$NON-NLS-1$
            "var_init_op", //$NON-NLS-1$
            "assignStatementCS", //$NON-NLS-1$
            "whileBodyCS", //$NON-NLS-1$
            "expression_block", //$NON-NLS-1$
            "declarator1", //$NON-NLS-1$
            "forExpCS", //$NON-NLS-1$
            "forOpCode", //$NON-NLS-1$
            "forExpDeclaratorList", //$NON-NLS-1$
            "ifExpBodyCS", //$NON-NLS-1$
            "ifThenPart", //$NON-NLS-1$
            "ifElsePart", //$NON-NLS-1$
            "ifExpression", //$NON-NLS-1$
            "switchBodyExpCS", //$NON-NLS-1$
            "switchDeclaratorCS", //$NON-NLS-1$
            "declarator", //$NON-NLS-1$
            "switchAltExpCSList", //$NON-NLS-1$
            "switchAltExpCS", //$NON-NLS-1$
            "expression_statement", //$NON-NLS-1$
            "logExpCS", //$NON-NLS-1$
            "imperativeIterateExpCS", //$NON-NLS-1$
            "imperativeIteratorExpCSToken12", //$NON-NLS-1$
            "imperativeIteratorExpCSToken3", //$NON-NLS-1$
            "imperativeIteratorExpCSToken", //$NON-NLS-1$
            "imperativeIterContents12", //$NON-NLS-1$
            "imperativeIterContents3", //$NON-NLS-1$
            "variableDeclarationListCS", //$NON-NLS-1$
            "newTypespecCS", //$NON-NLS-1$
            "expression_semi_list", //$NON-NLS-1$
            "unit_element", //$NON-NLS-1$
            "unit", //$NON-NLS-1$
            "importDeclaration", //$NON-NLS-1$
            "qualifiedNameCS", //$NON-NLS-1$
            "_tag", //$NON-NLS-1$
            "transformation_h", //$NON-NLS-1$
            "library_h", //$NON-NLS-1$
            "transformation_signature", //$NON-NLS-1$
            "module_usageList", //$NON-NLS-1$
            "simple_signature", //$NON-NLS-1$
            "moduleref", //$NON-NLS-1$
            "libraryDeclaration", //$NON-NLS-1$
            "module_usage", //$NON-NLS-1$
            "moduleref_list", //$NON-NLS-1$
            "module_element", //$NON-NLS-1$
            "packageref_list", //$NON-NLS-1$
            "modeltypeDeclaration", //$NON-NLS-1$
            "packageref", //$NON-NLS-1$
            "uri", //$NON-NLS-1$
            "qvtIdentifierCS", //$NON-NLS-1$
            "type_list", //$NON-NLS-1$
            "classifierFeatureList", //$NON-NLS-1$
            "classifierFeatureCS", //$NON-NLS-1$
            "identifier_list", //$NON-NLS-1$
            "feature_key", //$NON-NLS-1$
            "multiplicity_range", //$NON-NLS-1$
            "scoped_identifier", //$NON-NLS-1$
            "helper_header", //$NON-NLS-1$
            "helper_info", //$NON-NLS-1$
            "complete_signature", //$NON-NLS-1$
            "helper_kind", //$NON-NLS-1$
            "constructor_header", //$NON-NLS-1$
            "entry_header", //$NON-NLS-1$
            "mapping_full_header", //$NON-NLS-1$
            "mapping_header", //$NON-NLS-1$
            "mapping_extra", //$NON-NLS-1$
            "mapping_extension_key", //$NON-NLS-1$
            "scoped_identifier_list", //$NON-NLS-1$
            "typespec", //$NON-NLS-1$
            "objectDeclCS", //$NON-NLS-1$
            "objectIdentifierCS", //$NON-NLS-1$
            "featureMappingCallExpCS", //$NON-NLS-1$
            "resolveOpArgsExpCS", //$NON-NLS-1$
            "resolveOp", //$NON-NLS-1$
            "resolveInOp", //$NON-NLS-1$
            "resolveResolveInExpCS", //$NON-NLS-1$
            "letExpSubCS3", //$NON-NLS-1$
            "qualifier", //$NON-NLS-1$
            "param_list", //$NON-NLS-1$
            "param", //$NON-NLS-1$
            "typeCS2", //$NON-NLS-1$
            "scoped_identifier2" //$NON-NLS-1$
        };
    };
    public final static String name[] = Name.name;
    public final String name(int index) { return name[index]; }

    public final int originalState(int state) {
        return -baseCheck[state];
    }
    public final int asi(int state) {
        return asb[originalState(state)];
    }
    public final int nasi(int state) {
        return nasb[originalState(state)];
    }
    public final int inSymbol(int state) {
        return inSymb[originalState(state)];
    }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
