/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebugEvaluationEnvironment;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VariableFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMStackFrame
implements Serializable {
    private static final long serialVersionUID = -9084603067226851028L;
    public long id;
    private String uri;
    private int lineNum;
    public String module;
    public String operationSignature;
    public VMVariable[] visibleVariables;
    private transient VMLocation location;

    private VMStackFrame(long id, String uri, String module, String operationSignature, int line, VMVariable[] vars) {
        if (vars != null && (vars.length == 0 || Arrays.asList(vars).contains(null))) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.uri = uri;
        this.module = module;
        this.operationSignature = operationSignature;
        this.visibleVariables = vars;
        this.lineNum = line;
    }

    public synchronized VMLocation getLocation() {
        if (this.location == null) {
            this.location = new Loc(this);
        }
        return this.location;
    }

    public List<VMVariable> getVisibleVariables() {
        if (this.visibleVariables == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.visibleVariables);
    }

    public static VMStackFrame createFrame(long frameID, List<UnitLocation> stack) {
        UnitLocation location = VMStackFrame.lookupEnvironmentByID(frameID, stack);
        if (location != null) {
            return VMStackFrame.create(location);
        }
        return null;
    }

    public static VMStackFrame create(UnitLocation location) {
        return VMStackFrame.create(location, true);
    }

    public static VMStackFrame create(UnitLocation location, boolean includeVars) {
        DebugEvaluationEnvironment evalEnv = (DebugEvaluationEnvironment)location.getEvalEnv();
        Module module = location.getModule();
        String moduleName = module != null ? module.getName() : "<null>";
        ImperativeOperation operation = location.getOperation();
        String operSignature = operation != null ? VMStackFrame.getOperationSignature(operation) : MessageFormat.format("<{0}>", moduleName);
        List<VMVariable> vars = VariableFinder.getVariables(evalEnv);
        VMStackFrame vmStackFrame = new VMStackFrame(evalEnv.getID(), location.getURI().toString(), moduleName, operSignature, location.getLineNum(), vars.toArray(new VMVariable[vars.size()]));
        return vmStackFrame;
    }

    static VMStackFrame[] create(List<UnitLocation> stack) {
        ArrayList<VMStackFrame> result = new ArrayList<VMStackFrame>();
        int i = 0;
        for (UnitLocation location : stack) {
            result.add(VMStackFrame.create(location, i++ == 0));
        }
        return result.toArray(new VMStackFrame[result.size()]);
    }

    static UnitLocation lookupEnvironmentByID(long id, List<UnitLocation> stack) {
        for (UnitLocation location : stack) {
            DebugEvaluationEnvironment debugEvalEnv;
            QvtOperationalEvaluationEnv evalEnv = location.getEvalEnv();
            if (!(evalEnv instanceof DebugEvaluationEnvironment) || (debugEvalEnv = (DebugEvaluationEnvironment)evalEnv).getID() != id) continue;
            return location;
        }
        return null;
    }

    private static String getOperationSignature(ImperativeOperation operation) {
        StringBuffer buf = new StringBuffer();
        EClassifier ctxType = QvtOperationalParserUtil.getContextualType((ImperativeOperation)operation);
        if (ctxType != null) {
            buf.append(ctxType.getName()).append("::");
        }
        buf.append(operation.getName());
        buf.append('(');
        int i = 0;
        int n = operation.getEParameters().size();
        for (EParameter param : operation.getEParameters()) {
            EClassifier type = param.getEType();
            buf.append(type.getName());
            if (i + 1 < n) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static class Loc
    implements VMLocation {
        private static final long serialVersionUID = 6628362004248726386L;
        private final VMStackFrame frame;

        private Loc(VMStackFrame frame) {
            this.frame = frame;
        }

        public int getLineNum() {
            return this.frame.lineNum;
        }

        public String getURI() {
            return this.frame.uri;
        }

        public String getModule() {
            return this.frame.module;
        }

        public String getOperationSignature() {
            return this.frame.operationSignature;
        }
    }
}

