/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ConnectionManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateNavigationEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ComposedNode;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.RecursionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.util.AbstractExtendingQVTscheduleVisitor;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CheckedConditionAnalysis {
    protected final @NonNull PartitionAnalysis partitionAnalysis;
    protected final @NonNull Partition partition;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ReachabilityForest reachabilityForest;
    private @Nullable Set<@NonNull Property> allCheckedProperties;
    private final @NonNull List<@NonNull Edge> oldUnconditionalEdges;

    public CheckedConditionAnalysis(@NonNull MappingPartitionAnalysis<?> partitionAnalysis, @NonNull ScheduleManager scheduleManager) {
        this.partitionAnalysis = partitionAnalysis;
        this.partition = partitionAnalysis.getPartition();
        this.scheduleManager = scheduleManager;
        this.reachabilityForest = partitionAnalysis.getReachabilityForest();
        this.oldUnconditionalEdges = this.computeOldUnconditionalEdges();
    }

    public @NonNull Set<@NonNull CheckedCondition> computeCheckedConditions() {
        HashSet<@NonNull CheckedCondition> checkedConditions = new HashSet<CheckedCondition>();
        Visitor visitor = new Visitor(checkedConditions);
        visitor.analyze();
        return checkedConditions;
    }

    public @NonNull Set<@NonNull Property> computeCheckedProperties(@Nullable StringBuilder s) {
        if (this.allCheckedProperties != null) {
            return this.allCheckedProperties;
        }
        @NonNull ConnectionManager connectionManager = this.scheduleManager.getConnectionManager();
        HashSet<@NonNull Property> allCheckedProperties = new HashSet<Property>();
        for (Edge edge : this.partition.getPartialEdges()) {
            NavigationEdge navigationEdge;
            if (!(edge instanceof NavigationEdge) || !this.partitionAnalysis.isChecked(edge) || !connectionManager.isHazardousRead(s, this.partition, navigationEdge = (NavigationEdge)edge)) continue;
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            allCheckedProperties.add(property);
            Property oppositeProperty = property.getOpposite();
            if (oppositeProperty == null) continue;
            allCheckedProperties.add(oppositeProperty);
        }
        return allCheckedProperties;
    }

    private @NonNull List<@NonNull Edge> computeOldUnconditionalEdges() {
        ArrayList<@NonNull Edge> oldEdges = new ArrayList<Edge>();
        for (Edge edge : this.partition.getPartialEdges()) {
            Node targetNode;
            Role targetNodeRole;
            Node sourceNode;
            Role sourceNodeRole;
            Role edgeRole = this.partition.getRole(edge);
            if (edgeRole == null || !edgeRole.isOld() || edge.isConditional() || (sourceNodeRole = this.partition.getRole(sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge))) == null || !sourceNodeRole.isOld() || (targetNodeRole = this.partition.getRole(targetNode = QVTscheduleUtil.getTargetNode((Edge)edge))) == null || !targetNodeRole.isOld()) continue;
            oldEdges.add(edge);
        }
        Collections.sort(oldEdges, this.reachabilityForest.getEdgeCostComparator());
        return oldEdges;
    }

    public @NonNull Set<@NonNull Property> getAllCheckedProperties() {
        return this.computeCheckedProperties(null);
    }

    public @NonNull Iterable<@NonNull Edge> getOldUnconditionalEdges() {
        return this.oldUnconditionalEdges;
    }

    protected class Visitor
    extends AbstractExtendingQVTscheduleVisitor<Object, Set<CheckedCondition>> {
        private Set<@NonNull NavigableEdge> checkedNavigableEdges;
        protected final @NonNull CompleteModel completeModel;

        public Visitor(Set<CheckedCondition> checkedConditions) {
            super(checkedConditions);
            this.checkedNavigableEdges = null;
            this.completeModel = CheckedConditionAnalysis.this.scheduleManager.getEnvironmentFactory().getMetamodelManager().getCompleteModel();
        }

        public void analyze() {
            for (Edge edge : CheckedConditionAnalysis.this.oldUnconditionalEdges) {
                edge.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
            for (Node node : CheckedConditionAnalysis.this.partition.getPartialNodes()) {
                Role nodeRole = CheckedConditionAnalysis.this.partition.getRole(node);
                if (nodeRole == null || !nodeRole.isOld() || node.isConditional() || node.isDependency()) continue;
                node.accept((org.eclipse.ocl.pivot.util.Visitor)this);
            }
        }

        private boolean isCheckedNavigation(@NonNull NavigationEdge edge) {
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            Role sourceNodeRole = CheckedConditionAnalysis.this.partition.getRole(sourceNode);
            assert (sourceNodeRole != null);
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            Role targetNodeRole = CheckedConditionAnalysis.this.partition.getRole(targetNode);
            assert (targetNodeRole != null);
            return targetNodeRole.isConstant() && !sourceNodeRole.isNew();
        }

        public @Nullable Element visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public Object visitCastEdge(@NonNull CastEdge castEdge) {
            return this.visiting((Visitable)castEdge);
        }

        public Object visitComposedNode(@NonNull ComposedNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitDependencyNode(@NonNull DependencyNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitEdge(@NonNull Edge edge) {
            return null;
        }

        public Object visitErrorNode(@NonNull ErrorNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitInputNode(@NonNull InputNode object) {
            return this.visiting((Visitable)object);
        }

        public Object visitNavigationEdge(@NonNull NavigationEdge navigationEdge) {
            ClassDatum targetNodeClassDatum;
            if (this.isCheckedNavigation(navigationEdge)) {
                ((Set)this.context).add(new PredicateNavigationEdgeCheckedCondition(navigationEdge));
                return null;
            }
            Role navigableEdgeRole = CheckedConditionAnalysis.this.partition.getRole((Edge)navigationEdge);
            assert (navigableEdgeRole != null);
            NavigationEdge checkedEdge = QVTscheduleUtil.getPrimaryEdge((NavigationEdge)navigationEdge);
            NavigationEdge oppositeEdge = checkedEdge.getOppositeEdge();
            if (oppositeEdge != null) {
                Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)checkedEdge);
                Node targetNode = QVTscheduleUtil.getTargetNode((Edge)checkedEdge);
                Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
                Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
                if (sourceCost != null && targetCost != null && targetCost > 0 && targetCost < sourceCost) {
                    checkedEdge = oppositeEdge;
                }
            }
            Property checkedProperty = QVTscheduleUtil.getReferredProperty((NavigationEdge)checkedEdge);
            Set<@NonNull Property> allCheckedProperties2 = CheckedConditionAnalysis.this.computeCheckedProperties(null);
            if (allCheckedProperties2.contains(checkedProperty)) {
                if (this.checkedNavigableEdges == null) {
                    this.checkedNavigableEdges = new HashSet<NavigableEdge>();
                }
                if (this.checkedNavigableEdges.add((NavigableEdge)checkedEdge)) {
                    ((Set)this.context).add(new NavigableEdgeCheckedCondition((NavigableEdge)checkedEdge));
                }
            }
            Node targetNode = QVTscheduleUtil.getTargetNode((Edge)navigationEdge);
            if (navigableEdgeRole.isPredicated() && targetNode.isConstant()) {
                ((Set)this.context).add(new ConstantTargetCheckedCondition((NavigableEdge)navigationEdge));
            }
            Property property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge);
            CompleteClass edgeTargetCompleteClass = this.completeModel.getCompleteClass(QVTrelationUtil.getType((TypedElement)property));
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)navigationEdge);
            Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(sourceNode);
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(targetNode);
            assert (sourceCost != null && targetCost != null);
            if (sourceCost < targetCost && !QVTscheduleUtil.conformsTo((CompleteClass)edgeTargetCompleteClass, (ClassDatum)(targetNodeClassDatum = QVTscheduleUtil.getClassDatum((Node)targetNode)))) {
                ((Set)this.context).add(new CastEdgeCheckedCondition((NavigableEdge)navigationEdge));
            }
            return null;
        }

        public Object visitNode(@NonNull Node node) {
            Integer targetCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(node);
            assert (targetCost != null);
            Edge firstEdge = null;
            MultipleEdgeCheckedCondition checkedCondition = null;
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                Role edgeRole = CheckedConditionAnalysis.this.partition.getRole(edge);
                if (edgeRole == null || !edgeRole.isOld() || edge.isExpression()) continue;
                Integer sourceCost = CheckedConditionAnalysis.this.reachabilityForest.getCost(QVTscheduleUtil.getSourceNode((Edge)edge));
                assert (sourceCost != null);
                if (sourceCost > targetCost) continue;
                if (firstEdge == null) {
                    firstEdge = edge;
                    continue;
                }
                if (checkedCondition == null) {
                    checkedCondition = new MultipleEdgeCheckedCondition(node, firstEdge, edge);
                    ((Set)this.context).add(checkedCondition);
                    continue;
                }
                checkedCondition.addEdge(edge);
            }
            return null;
        }

        public Object visitOperationNode(@NonNull OperationNode operationNode) {
            Element originatingElement = operationNode.basicGetOriginatingElement();
            if (originatingElement instanceof TypedElement) {
                ClassDatum targetClassDatum;
                Type initializerType;
                CompleteClass initializerCompleteClass;
                TypedElement typedElement = (TypedElement)originatingElement;
                if (operationNode.isRequired() && !typedElement.isIsRequired()) {
                    ((Set)this.context).add(new NonNullInitializerCheckedCondition(operationNode));
                }
                if (!QVTscheduleUtil.conformsTo((CompleteClass)(initializerCompleteClass = this.completeModel.getCompleteClass(initializerType = QVTbaseUtil.getType((TypedElement)typedElement))), (ClassDatum)(targetClassDatum = QVTscheduleUtil.getClassDatum((Node)operationNode)))) {
                    ((Set)this.context).add(new CastInitializerCheckedCondition(operationNode));
                }
            }
            return super.visitOperationNode(operationNode);
        }

        public Object visitPredicateEdge(@NonNull PredicateEdge predicateEdge) {
            ((Set)this.context).add(new PredicateEdgeCheckedCondition(predicateEdge));
            return null;
        }

        public Object visitRecursionEdge(@NonNull RecursionEdge object) {
            return this.visiting((Visitable)object);
        }

        public Object visitSuccessEdge(@NonNull SuccessEdge successEdge) {
            assert (this.isCheckedNavigation((NavigationEdge)successEdge));
            RuleRegion ruleRegion = (RuleRegion)CheckedConditionAnalysis.this.partitionAnalysis.getRegion();
            Rule rule = QVTscheduleUtil.getReferredRule((RuleRegion)ruleRegion);
            AbstractTransformationAnalysis transformationAnalysis = CheckedConditionAnalysis.this.partitionAnalysis.getPartitionedTransformationAnalysis().getTransformationAnalysis();
            RuleAnalysis ruleAnalysis = transformationAnalysis.getRuleAnalysis(rule);
            Rule2TraceGroup rule2TraceGroup = ruleAnalysis.getRule2TraceGroup();
            boolean isLocalSuccess = false;
            Element2MiddleProperty basicGetRelation2LocalSuccessProperty = rule2TraceGroup.basicGetRelation2LocalSuccessProperty();
            if (basicGetRelation2LocalSuccessProperty != null) {
                Property localSuccessProperty = basicGetRelation2LocalSuccessProperty.getTraceProperty();
                isLocalSuccess = successEdge.getReferredProperty() == localSuccessProperty;
            }
            ((Set)this.context).add(new ConstantTargetCheckedCondition(successEdge, isLocalSuccess));
            return null;
        }

        public Object visitUnknownNode(@NonNull UnknownNode object) {
            return this.visiting((Visitable)object);
        }
    }
}

