/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationParameterEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeLibraryHelper;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;

public class UtilityAnalysis {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Region region;
    protected final @NonNull QVTruntimeLibraryHelper qvtbaseLibraryHelper;
    private @Nullable List<@NonNull Node> stronglyMatchedNodes = null;
    private @Nullable List<@NonNull Node> unconditionalNodes = null;
    private @Nullable List<@NonNull Node> conditionalNodes = null;
    private @Nullable List<@NonNull Node> deadNodes = null;

    public static void assignUtilities(@NonNull ScheduleManager scheduleManager, @NonNull Region region) {
        new UtilityAnalysis(scheduleManager, region).assignUtilities();
    }

    protected UtilityAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull Region region) {
        this.scheduleManager = scheduleManager;
        this.region = region;
        this.qvtbaseLibraryHelper = scheduleManager.getQVTruntimeLibraryHelper();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void assignUtilities() {
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Region)this.region);
        Node dispatchNode = this.computeDispatchNode();
        Set<@NonNull Node> traceNodes = this.computeTraceNodes(headNodes);
        Set<@NonNull Node> stronglyMatchedNodes = this.computeStronglyMatchedNodes(headNodes);
        Set<@NonNull Node> unconditionalNodes = this.computeUnconditionalNodes(headNodes);
        Set<@NonNull Node> conditionalNodes = this.computeConditionalNodes(unconditionalNodes);
        HashSet<Node> deadNodes = null;
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            Node.Utility oldUtility = node.basicGetUtility();
            if (dispatchNode == node) {
                node.setUtility(Node.Utility.DISPATCH);
            } else if (traceNodes.contains(node)) {
                node.setUtility(Node.Utility.TRACE);
            } else if (stronglyMatchedNodes.contains(node)) {
                node.setUtility(Node.Utility.STRONGLY_MATCHED);
                if (!unconditionalNodes.contains(node)) {
                    QVTruntimeUtil.errPrintln((String)(node + " is not unconditional in " + this));
                }
            } else if (unconditionalNodes.contains(node) && !node.isDependency()) {
                node.setUtility(Node.Utility.WEAKLY_MATCHED);
            } else if (conditionalNodes.contains(node)) {
                node.setUtility(Node.Utility.CONDITIONAL);
            } else if (node.isDependency()) {
                node.setUtility(Node.Utility.DEPENDENCY);
            } else if (node.isComposed()) {
                node.setUtility(Node.Utility.COMPOSED);
            } else {
                System.out.println("Dead node in " + this + " : " + node);
                if (deadNodes == null) {
                    deadNodes = new HashSet<Node>();
                }
                deadNodes.add(node);
                node.setUtility(Node.Utility.DEAD);
                this.toString();
            }
            Node.Utility newUtility = node.getUtility();
            if (oldUtility != null) assert (oldUtility == newUtility);
        }
        if (deadNodes != null) {
            this.deadNodes = new ArrayList<Node>(deadNodes);
            Collections.sort(this.deadNodes, NameUtil.NAMEABLE_COMPARATOR);
        }
    }

    private boolean canBeStronglyMatched(@NonNull Node node) {
        if (node.isPattern()) {
            return true;
        }
        return node.isConstant();
    }

    private boolean canBeUnconditional(@NonNull Node node) {
        if (node.isIterator()) {
            return false;
        }
        if (node.isOperation()) {
            return true;
        }
        if (node.isPattern()) {
            return true;
        }
        return node.isSuccess();
    }

    private @NonNull Set<@NonNull Node> computeConditionalNodes(@NonNull Set<@NonNull Node> unconditionalNodes) {
        HashSet<@NonNull Node> conditionalNodes = new HashSet<Node>();
        Set<@NonNull Node> moreNodes = unconditionalNodes;
        while (moreNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (unconditionalNodes.contains(sourceNode) || !conditionalNodes.add(sourceNode)) continue;
                    moreMoreNodes.add(sourceNode);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (unconditionalNodes.contains(targetNode) || !conditionalNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreNodes = moreMoreNodes;
        }
        this.conditionalNodes = new ArrayList<Node>(conditionalNodes);
        Collections.sort(this.conditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return conditionalNodes;
    }

    private @Nullable Node computeDispatchNode() {
        Node dispatchNode = null;
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isPredicated() || node.basicGetUtility() != Node.Utility.DISPATCH) continue;
            assert (dispatchNode == null);
            dispatchNode = node;
        }
        return dispatchNode;
    }

    private @NonNull Set<@NonNull Node> computeStronglyMatchedNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> stronglyMatchedNodes = new HashSet<Node>();
        for (Node headNode : headNodes) {
            if (headNode.isDependency()) continue;
            stronglyMatchedNodes.add(headNode);
        }
        HashSet<@NonNull E> moreStronglyMatchedNodes = new HashSet(stronglyMatchedNodes);
        while (moreStronglyMatchedNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node sourceNode : moreStronglyMatchedNodes) {
                for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                    if (!edge.isNavigation()) continue;
                    NavigationEdge navigationEdge = (NavigationEdge)edge;
                    Node targetNode = edge.getEdgeTarget();
                    if (!this.canBeStronglyMatched(targetNode) || !targetNode.isNullLiteral() && !QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge).isIsRequired() || !stronglyMatchedNodes.add(targetNode)) continue;
                    moreMoreNodes.add(targetNode);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreStronglyMatchedNodes = moreMoreNodes;
        }
        this.stronglyMatchedNodes = new ArrayList<Node>(stronglyMatchedNodes);
        Collections.sort(this.stronglyMatchedNodes, NameUtil.NAMEABLE_COMPARATOR);
        return stronglyMatchedNodes;
    }

    private Set<@NonNull Node> computeTraceNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> traceNodes = new HashSet<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (node.basicGetUtility() != Node.Utility.TRACE) continue;
            traceNodes.add(node);
        }
        if (traceNodes.isEmpty()) {
            for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
                if (!node.isRealized() || !this.scheduleManager.isMiddle(node)) continue;
                traceNodes.add(node);
            }
        }
        return traceNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull Node> computeUnconditionalNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        @NonNull @NonNull HashSet unconditionalNodes = Sets.newHashSet(headNodes);
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isNew() && !node.isConstant()) continue;
            unconditionalNodes.add(node);
        }
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (!edge.isRealized() || !edge.isNavigation() || edge.isSecondary()) continue;
            Node sourceNode = edge.getEdgeSource();
            assert (this.canBeUnconditional(sourceNode));
            unconditionalNodes.add(sourceNode);
            Node targetNode = edge.getEdgeTarget();
            assert (this.canBeUnconditional(targetNode));
            unconditionalNodes.add(targetNode);
        }
        HashSet<@NonNull E> moreUnconditionalNodes = new HashSet(unconditionalNodes);
        while (moreUnconditionalNodes.size() > 0) {
            HashSet<@NonNull Node> moreMoreNodes = new HashSet<Node>();
            for (Node node : moreUnconditionalNodes) {
                for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                    assert (!incomingEdge.isCast());
                    Node sourceNode = incomingEdge.getEdgeSource();
                    if (!this.canBeUnconditional(sourceNode)) continue;
                    if (incomingEdge.isComputation()) {
                        if (this.isConditionalEdge(incomingEdge) || !unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    if (incomingEdge.isNavigation()) {
                        if (!unconditionalNodes.add(sourceNode)) continue;
                        moreMoreNodes.add(sourceNode);
                        continue;
                    }
                    System.out.println("Unsupported incoming edge in " + this + " : " + incomingEdge);
                }
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
                    assert (!outgoingEdge.isCast());
                    Node targetNode = outgoingEdge.getEdgeTarget();
                    if (!this.canBeUnconditional(targetNode) || outgoingEdge.isComputation() || outgoingEdge.isDependency()) continue;
                    if (outgoingEdge.isNavigation()) {
                        if (targetNode.isNullLiteral()) {
                            if (!unconditionalNodes.add(targetNode)) continue;
                            moreMoreNodes.add(targetNode);
                            continue;
                        }
                        if (!node.isRequired() || !QVTscheduleUtil.getReferredProperty((NavigationEdge)((NavigationEdge)outgoingEdge)).isIsRequired() || !unconditionalNodes.add(targetNode)) continue;
                        moreMoreNodes.add(targetNode);
                        continue;
                    }
                    System.out.println("Unsupported outgoing edge in " + this + " : " + outgoingEdge);
                }
            }
            if (moreMoreNodes.size() <= 0) break;
            moreUnconditionalNodes = moreMoreNodes;
        }
        this.unconditionalNodes = new ArrayList<Node>(unconditionalNodes);
        Collections.sort(this.unconditionalNodes, NameUtil.NAMEABLE_COMPARATOR);
        return unconditionalNodes;
    }

    private boolean isConditionalEdge(@NonNull Edge edge) {
        if (edge instanceof OperationParameterEdge) {
            OperationParameterEdge operationParameterEdge = (OperationParameterEdge)edge;
            Parameter parameter = operationParameterEdge.getReferredParameter();
            if (parameter == this.qvtbaseLibraryHelper.getIfThenParameter()) {
                return true;
            }
            if (parameter == this.qvtbaseLibraryHelper.getIfElseParameter()) {
                return true;
            }
            if (parameter == this.qvtbaseLibraryHelper.getLoopBodyParameter()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.region.toString();
    }
}

