/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.AbstractGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.CompoundGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Group;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Split;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;

public class Splitter
extends SplitterAnalysis {
    public static final @NonNull TracingOption GROUPS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/split/groups");
    public static final @NonNull TracingOption RESULT = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/split/result");
    public static final @NonNull TracingOption STAGES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/split/stages");
    private final @NonNull Map<@NonNull SimpleGroup, @NonNull AbstractGroup> simpleGroup2mutualGroup = new HashMap<SimpleGroup, AbstractGroup>();

    public Splitter(@NonNull Region region) {
        super(region);
    }

    protected void computeComputableGroup(@NonNull Iterable<@NonNull AbstractGroup> mutualGroups) {
        for (AbstractGroup mutualGroup : mutualGroups) {
            this.computeComputablePredecessors(mutualGroup);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull AbstractGroup> computeComputableGroupSchedule() {
        ArrayList<@NonNull AbstractGroup> rootMutuals = new ArrayList<AbstractGroup>();
        ArrayList<@NonNull AbstractGroup> scheduledNavigables = new ArrayList<AbstractGroup>(this.simpleGroup2mutualGroup.size());
        ArrayList<@NonNull AbstractGroup> unscheduledNavigables = new ArrayList<AbstractGroup>(new HashSet<AbstractGroup>(this.simpleGroup2mutualGroup.values()));
        Collections.sort(unscheduledNavigables, NameUtil.NAMEABLE_COMPARATOR);
        while (unscheduledNavigables.size() > 0) {
            int oldSize = unscheduledNavigables.size();
            for (AbstractGroup unscheduledNavigable : unscheduledNavigables) {
                Iterable<@NonNull AbstractGroup> predecessors = unscheduledNavigable.getPredecessors();
                @NonNull HashSet unscheduledPredecessors = Sets.newHashSet(predecessors);
                for (AbstractGroup scheduledNavigable : scheduledNavigables) {
                    unscheduledPredecessors.remove(scheduledNavigable);
                }
                if (!unscheduledPredecessors.isEmpty()) continue;
                boolean hasPredecessor = false;
                int lastIndex = scheduledNavigables.size() - 1;
                while (lastIndex >= 0) {
                    AbstractGroup lastScheduledNavigable = (AbstractGroup)scheduledNavigables.get(lastIndex);
                    if (Iterables.contains(predecessors, (Object)lastScheduledNavigable)) {
                        lastScheduledNavigable.addSuccessor(unscheduledNavigable);
                        hasPredecessor = true;
                        break;
                    }
                    --lastIndex;
                }
                if (!hasPredecessor) {
                    rootMutuals.add(unscheduledNavigable);
                }
                scheduledNavigables.add(unscheduledNavigable);
            }
            unscheduledNavigables.removeAll(scheduledNavigables);
            int newSize = unscheduledNavigables.size();
            if (oldSize != newSize) continue;
            throw new IllegalStateException("Cyclic dependency in " + this.region);
        }
        return rootMutuals;
    }

    protected void computeComputablePredecessors(@NonNull AbstractGroup mutualGroup) {
        Iterable<@NonNull SimpleGroup> targetGroups = mutualGroup.getInternalSimpleGroups();
        AbstractGroup targetMutualGroup = this.simpleGroup2mutualGroup.get(targetGroups.iterator().next());
        assert (targetMutualGroup != null);
        Iterable<@NonNull Node> reachableNodes = mutualGroup.getReachableNodes();
        for (Node node : reachableNodes) {
            for (Edge edge : RegionUtil.getIncomingEdges((Node)node)) {
                assert (edge.getEdgeTarget() == node);
                if (edge.isRealized() || !edge.isComputation()) continue;
                Node sourceNode = edge.getEdgeSource();
                Iterable<@NonNull SimpleGroup> sourceGroups = this.basicGetReachableSimpleGroups(sourceNode);
                if (sourceGroups == null) {
                    sourceGroups = this.computeComputableSourceGroups(new HashSet<SimpleGroup>(), sourceNode);
                }
                assert (sourceGroups != null);
                ArrayList<@NonNull AbstractGroup> sourceComputableGroups = new ArrayList<AbstractGroup>();
                for (SimpleGroup sourceGroup : sourceGroups) {
                    if (Iterables.contains(targetGroups, (Object)sourceGroup)) continue;
                    AbstractGroup sourceMutualGroup = this.simpleGroup2mutualGroup.get(sourceGroup);
                    assert (sourceMutualGroup != null);
                    sourceComputableGroups.add(sourceMutualGroup);
                }
                targetMutualGroup.addPredecessor(edge, sourceComputableGroups);
            }
        }
    }

    protected Iterable<@NonNull SimpleGroup> computeComputableSourceGroups(@NonNull Set<@NonNull SimpleGroup> groups, @NonNull Node targetNode) {
        for (Edge edge : RegionUtil.getIncomingEdges((Node)targetNode)) {
            Node sourceNode;
            Iterable sourceGroups;
            if (!edge.isComputation() || (sourceGroups = this.basicGetReachableSimpleGroups(sourceNode = edge.getEdgeSource())) == null) continue;
            Iterables.addAll(groups, (Iterable)sourceGroups);
            this.computeComputableSourceGroups(groups, sourceNode);
        }
        return groups;
    }

    protected @NonNull Iterable<@NonNull AbstractGroup> computeSimpleGroup2mutualGroup(@NonNull Iterable<@NonNull SimpleGroup> simpleGroups) {
        for (SimpleGroup simpleGroup : simpleGroups) {
            if (this.simpleGroup2mutualGroup.containsKey(simpleGroup)) continue;
            this.growMutualGroup(simpleGroups, simpleGroup);
        }
        return Sets.newHashSet(this.simpleGroup2mutualGroup.values());
    }

    protected Split computeSplit(@NonNull Iterable<@NonNull AbstractGroup> rootGroups) {
        Split split = new Split(this);
        for (AbstractGroup rootGroup : rootGroups) {
            rootGroup.buildSplit(split, null, null);
        }
        split.addBodyStage();
        return split;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull AbstractGroup growMutualGroup(@NonNull Iterable<@NonNull SimpleGroup> simpleGroups, @NonNull SimpleGroup thisGroup) {
        HashSet<@NonNull SimpleGroup> theseGroups = new HashSet<SimpleGroup>();
        theseGroups.add(thisGroup);
        HashSet<@NonNull E> theseNodes = new HashSet();
        for (Group group : theseGroups) {
            Iterables.addAll(theseNodes, group.getReachableNodes());
        }
        HashSet<@NonNull E> hashSet = new HashSet();
        Iterables.addAll(hashSet, simpleGroups);
        hashSet.removeAll(theseGroups);
        block1: while (true) {
            HashSet<@NonNull E> thoseNodes = new HashSet();
            for (Group group : hashSet) {
                Iterables.addAll(thoseNodes, group.getReachableNodes());
            }
            @NonNull HashSet overlapNodes = Sets.newHashSet(theseNodes);
            overlapNodes.retainAll(thoseNodes);
            if (overlapNodes.isEmpty()) {
                AbstractGroup navigableGroup = theseGroups.size() == 1 ? (AbstractGroup)theseGroups.iterator().next() : new CompoundGroup((SplitterAnalysis)this, theseGroups);
                for (SimpleGroup simpleGroup : theseGroups) {
                    AbstractGroup oldMutualGroup = this.simpleGroup2mutualGroup.put(simpleGroup, navigableGroup);
                    assert (oldMutualGroup == null);
                }
                return navigableGroup;
            }
            HashSet<@NonNull SimpleGroup> newOverlapGroups = new HashSet<SimpleGroup>();
            for (Node node : overlapNodes) {
                @NonNull Iterable overlapGroups = this.getReachableSimpleGroups(node);
                assert (overlapGroups != null);
                for (SimpleGroup overlapGroup : overlapGroups) {
                    newOverlapGroups.add(overlapGroup);
                }
            }
            newOverlapGroups.removeAll(theseGroups);
            Iterator iterator = newOverlapGroups.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block1;
                @NonNull SimpleGroup group = (SimpleGroup)iterator.next();
                theseGroups.add(group);
                hashSet.remove(group);
                Iterables.addAll(theseNodes, group.getReachableNodes());
            }
            break;
        }
    }

    public @Nullable Split split() {
        Iterable<@NonNull SimpleGroup> simpleGroups = this.analyze();
        if (simpleGroups == null) {
            return null;
        }
        Iterable<@NonNull AbstractGroup> mutualGroups = this.computeSimpleGroup2mutualGroup(simpleGroups);
        this.computeComputableGroup(mutualGroups);
        Iterable<@NonNull AbstractGroup> rootGroups = this.computeComputableGroupSchedule();
        for (AbstractGroup rootGroup : rootGroups) {
            rootGroup.computeNavigableGroupSchedule(Collections.emptyList());
        }
        if (GROUPS.isActive()) {
            StringBuilder s = new StringBuilder();
            for (AbstractGroup rootGroup : rootGroups) {
                if (!Iterables.isEmpty(rootGroup.getPredecessors())) continue;
                s.append("\n");
                rootGroup.toString(s, 0);
            }
            GROUPS.println(this.region + s.toString());
        }
        Split split = this.computeSplit(rootGroups);
        if (RESULT.isActive()) {
            RESULT.println(this.region + split.toString());
        }
        split.check();
        return split;
    }
}

