/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.vm;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.data.VMVariableData;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;

public class QVTiVariableFinder
extends VariableFinder {
    public QVTiVariableFinder(@NonNull VMEvaluationEnvironment vmEvaluationEnvironment, boolean isStoreValues) {
        super(vmEvaluationEnvironment, isStoreValues);
    }

    public void collectChildVars(Object valueObject, @NonNull String @NonNull [] parentPath, @Nullable String containerType, @NonNull List<@NonNull VMVariableData> result) {
        if (valueObject instanceof QVTiModelManager.QVTiTransformationInstance) {
            String[] childPath = new String[parentPath.length + 1];
            System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
            QVTiModelManager.QVTiTransformationInstance transformationInstance = (QVTiModelManager.QVTiTransformationInstance)valueObject;
            Transformation transformation = transformationInstance.getTransformation();
            for (TypedModel typedModel : transformation.getModelParameter()) {
                Variable variable = typedModel.getOwnedContext();
                String varName = typedModel.getName();
                assert (varName != null);
                childPath[childPath.length - 1] = varName;
                VMVariableData elementVar = new VMVariableData(varName, QVTiVariableFinder.createURI((String[])childPath).toString());
                elementVar.kind = 4;
                QVTiModelManager modelManager = transformationInstance.getModelManager();
                Resource model = modelManager.getModel(typedModel);
                this.setValueAndType(elementVar, model, "TypedModel");
                if (this.fIsStoreValues) {
                    elementVar.valueObject = variable;
                }
                result.add(elementVar);
            }
        } else if (valueObject instanceof QVTiModelManager.QVTiTypedModelInstance) {
            QVTiModelManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelManager.QVTiTypedModelInstance)valueObject;
            QVTiModelManager modelManager = typedModelInstance.getModelManager();
            TypedModel typedModel = typedModelInstance.getTypedModel();
            Resource model = modelManager.getModel(typedModel);
            super.collectChildVars((Object)model, parentPath, containerType, result);
        } else {
            super.collectChildVars(valueObject, parentPath, containerType, result);
        }
    }

    protected Object findChildObject(Object parentObj, @Nullable String optParentDeclaredType, @NonNull String @NonNull [] varTreePath, int pathIndex) {
        Resource nextObject = null;
        String nextDeclaredType = null;
        if (!(parentObj instanceof QVTiModelManager.QVTiTransformationInstance)) {
            if (parentObj instanceof QVTiModelManager.QVTiTypedModelInstance) {
                QVTiModelManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelManager.QVTiTypedModelInstance)parentObj;
                QVTiModelManager modelManager = typedModelInstance.getModelManager();
                TypedModel typedModel = typedModelInstance.getTypedModel();
                Resource model = modelManager.getModel(typedModel);
                return super.findChildObject((Object)model, optParentDeclaredType, varTreePath, pathIndex);
            }
            return super.findChildObject(parentObj, optParentDeclaredType, varTreePath, pathIndex);
        }
        QVTiModelManager.QVTiTransformationInstance transformationInstance = (QVTiModelManager.QVTiTransformationInstance)parentObj;
        Transformation transformation = transformationInstance.getTransformation();
        TypedModel typedModel = transformation.getModelParameter(varTreePath[pathIndex]);
        QVTiModelManager modelManager = transformationInstance.getModelManager();
        nextObject = typedModel != null ? modelManager.getModel(typedModel) : null;
        nextDeclaredType = "Resource";
        int nextIndex = pathIndex + 1;
        if (nextIndex < varTreePath.length) {
            if (nextObject != null) {
                return this.findChildObject(nextObject, nextDeclaredType, varTreePath, nextIndex);
            }
            return null;
        }
        return nextObject;
    }

    protected String getDeclaredType(Object valueObject) {
        if (valueObject instanceof QVTiModelManager.QVTiTransformationInstance) {
            return "qvtbaselibrary::Transformation";
        }
        if (valueObject instanceof QVTiModelManager.QVTiTypedModelInstance) {
            return "qvtbaselibrary::Model";
        }
        return super.getDeclaredType(valueObject);
    }

    protected @Nullable VMVariableData getVariable(@NonNull TypedElement variable, @Nullable Object pcObject) {
        return super.getVariable(variable, pcObject);
    }

    public void setValueAndType(@NonNull VMVariableData variable, @Nullable Object value, @Nullable String declaredTypeName) {
        if (value instanceof QVTiModelManager.QVTiTransformationInstance) {
            super.setValueAndType(variable, (Object)((QVTiModelManager.QVTiTransformationInstance)value).getTransformation(), declaredTypeName);
        } else if (value instanceof QVTiModelManager.QVTiTypedModelInstance) {
            QVTiModelManager.QVTiTypedModelInstance typedModelInstance = (QVTiModelManager.QVTiTypedModelInstance)value;
            QVTiModelManager modelManager = typedModelInstance.getModelManager();
            TypedModel typedModel = typedModelInstance.getTypedModel();
            Resource model = modelManager.getModel(typedModel);
            super.setValueAndType(variable, (Object)model, declaredTypeName);
        } else {
            super.setValueAndType(variable, value, declaredTypeName);
        }
    }
}

