/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;

public final class RegionCycle {
    public static final @NonNull CycleComparator COMPARATOR = new CycleComparator();
    private final @NonNull Set<@NonNull Region> regions;
    private @Nullable String name;

    public RegionCycle(@NonNull Set<@NonNull Region> regions) {
        this.regions = regions;
        assert (regions.size() > 0);
    }

    public @NonNull RegionCycle createResidualCycle(@NonNull RegionCycle thatCycle) {
        HashSet<@NonNull Region> regions = new HashSet<Region>(this.regions);
        regions.removeAll(thatCycle.regions);
        return new RegionCycle(regions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegionCycle)) {
            return false;
        }
        return this.regions.equals(((RegionCycle)obj).regions);
    }

    public @NonNull Iterable<@NonNull Region> getRegions() {
        return this.regions;
    }

    public int hashCode() {
        return this.regions.hashCode();
    }

    public @NonNull String toString() {
        String name2 = this.name;
        if (name2 == null) {
            ArrayList<@NonNull String> names = new ArrayList<String>();
            Collections.sort(names);
            for (Region region : this.regions) {
                names.add(region.getName());
            }
            Collections.sort(names);
            StringBuilder s = null;
            for (String name : names) {
                if (s == null) {
                    s = new StringBuilder();
                } else {
                    s.append(", ");
                }
                s.append(name);
            }
            assert (s != null);
            name2 = this.name = "[" + s.toString() + "]";
        }
        return name2;
    }

    private static final class CycleComparator
    implements Comparator<RegionCycle> {
        private CycleComparator() {
        }

        @Override
        public int compare(@NonNull RegionCycle o1, @NonNull RegionCycle o2) {
            return o1.regions.size() - o2.regions.size();
        }
    }
}

