/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.QVTRelation.operations;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.operations.TransformationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.Key;
import org.eclipse.qvt.declarative.ecore.QVTRelation.RelationalTransformation;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.AbstractQVTRelationOperations;
import org.eclipse.qvt.declarative.ecore.QVTRelation.operations.QVTRelationMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyOperations
extends AbstractQVTRelationOperations {
    public static KeyOperations INSTANCE = new KeyOperations();

    public boolean checkAtLeastOnePart(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int partCount = key.getPart().size() + key.getOppositePart().size();
        if (partCount > 0) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)key, context)};
        this.appendError(diagnostics, key, QVTRelationMessages._UI_Key_NoParts, messageSubstitutions);
        return false;
    }

    public boolean checkIdentifiesTypeIsDeclaredByTransformation(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass identifiedClass = key.getIdentifies();
        if (identifiedClass == null) {
            return true;
        }
        RelationalTransformation transformation = key.getTransformation();
        if (TransformationOperations.INSTANCE.declaresType((Transformation)transformation, identifiedClass)) {
            return true;
        }
        Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)identifiedClass, context), this.getObjectLabel((EObject)transformation, context)};
        this.appendError(diagnostics, key, QVTRelationMessages._UI_Key_IdentifiesTypeIsNotDeclaredByTransformation, messageSubstitutions);
        return false;
    }

    public boolean checkEveryPartIsDeclaredByIdentifies(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass identifiedClass = key.getIdentifies();
        if (identifiedClass == null) {
            return true;
        }
        boolean allOk = true;
        for (EStructuralFeature part : key.getPart()) {
            if (this.definesProperty(identifiedClass, part)) continue;
            allOk = false;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)part, context), this.getObjectLabel((EObject)key, context), this.getObjectLabel((EObject)identifiedClass, context)};
            this.appendError(diagnostics, key, QVTRelationMessages._UI_Key_PartIsNotDeclaredByIdentifies, messageSubstitutions);
        }
        return allOk;
    }

    public boolean checkEveryOppositePartReferencesIdentifies(Key key, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass identifiedClass = key.getIdentifies();
        if (identifiedClass == null) {
            return true;
        }
        boolean allOk = true;
        for (EReference oppositePart : key.getOppositePart()) {
            if (this.definesOppositeProperty(identifiedClass, oppositePart)) continue;
            allOk = false;
            Object[] messageSubstitutions = new Object[]{this.getObjectLabel((EObject)oppositePart, context), this.getObjectLabel((EObject)key, context), this.getObjectLabel((EObject)identifiedClass, context)};
            this.appendError(diagnostics, key, QVTRelationMessages._UI_Key_OppositePartDoesNotReferenceIdentifies, messageSubstitutions);
        }
        return allOk;
    }
}

