/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.services.base;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IFoldingUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FolderBase
implements IFoldingUpdater {
    protected HashMap<Annotation, Position> newAnnotations = new HashMap();
    protected List<Annotation> annotations = new ArrayList<Annotation>();
    protected IParseController parseController = null;
    private ArrayList<Annotation> oldAnnotationsList = null;
    private Annotation[] oldAnnotationsArray;
    protected boolean fDebugMode = false;

    public void makeAnnotation(Object n) {
        ISourcePositionLocator nodeLocator = this.parseController.getSourcePositionLocator();
        int startOffset = 0;
        int endOffset = 0;
        try {
            startOffset = nodeLocator.getStartOffset(n);
            endOffset = nodeLocator.getEndOffset(n);
        }
        catch (Exception e) {
            RuntimePlugin.getInstance().logException("Error while attempting to determine position of a foldable source entity", e);
            return;
        }
        this.makeAnnotation(startOffset, endOffset - startOffset + 1);
    }

    public void makeAnnotation(int start, int len) {
        if (this.fDebugMode) {
            PrintStream cons = RuntimePlugin.getInstance().getConsoleStream();
            cons.println("Adding folding annotation for extent [" + start + ":" + len + "]");
        }
        ProjectionAnnotation annotation = new ProjectionAnnotation();
        this.newAnnotations.put((Annotation)annotation, new Position(start, len));
        this.annotations.add((Annotation)annotation);
    }

    @Override
    public synchronized void updateFoldingStructure(IParseController parseController, ProjectionAnnotationModel annotationModel) {
        if (this.fDebugMode) {
            PrintStream cons = RuntimePlugin.getInstance().getConsoleStream();
            cons.println("Collecting folding annotations");
        }
        if (parseController != null) {
            this.parseController = parseController;
        }
        try {
            Object ast = parseController.getCurrentAst();
            if (ast == null) {
                return;
            }
            this.sendVisitorToAST(this.newAnnotations, this.annotations, ast);
            boolean updateNeeded = false;
            updateNeeded = this.oldAnnotationsList == null ? true : this.differ(this.oldAnnotationsList, this.annotations);
            if (updateNeeded) {
                this.oldAnnotationsList = new ArrayList();
                int i = 0;
                while (i < this.annotations.size()) {
                    this.oldAnnotationsList.add(this.annotations.get(i));
                    ++i;
                }
            }
            if (updateNeeded) {
                annotationModel.modifyAnnotations(this.oldAnnotationsArray, this.newAnnotations, null);
                this.oldAnnotationsArray = this.annotations.toArray(new Annotation[this.annotations.size()]);
            }
            this.newAnnotations.clear();
            this.annotations.clear();
        }
        catch (Exception e) {
            ErrorHandler.reportError("FolderBase.updateFoldingStructure:  EXCEPTION", e);
        }
    }

    protected boolean differ(List<Annotation> list1, List<Annotation> list2) {
        return list1.size() != list2.size();
    }

    protected abstract void sendVisitorToAST(HashMap<Annotation, Position> var1, List<Annotation> var2, Object var3);

    protected void dumpAnnotations(List<Annotation> annotations, HashMap<Annotation, Position> newAnnotations) {
        int i = 0;
        while (i < annotations.size()) {
            Annotation a = annotations.get(i);
            Position p = newAnnotations.get(a);
            if (p == null) {
                System.out.println("Annotation position is null");
            } else {
                System.out.println("Annotation @ " + p.offset + ":" + p.length);
            }
            ++i;
        }
    }
}

