/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.preferences.fields;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.preferences.PreferencesTab;
import org.eclipse.imp.preferences.fields.StringFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    protected double minValidValue = Double.MIN_VALUE;
    protected double maxValidValue = Double.MAX_VALUE;
    protected static final int DEFAULT_TEXT_LIMIT = 15;
    protected String errorMessage = "Value must be a double-precision floating-point number between " + this.minValidValue + " and " + this.maxValidValue;

    public DoubleFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, int strategy, Composite parent) {
        super(page, tab, service, level, name, labelText, width, strategy, parent);
    }

    public DoubleFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, int width, Composite parent) {
        super(page, tab, service, level, name, labelText, width, 0, parent);
    }

    public DoubleFieldEditor(PreferencePage page, PreferencesTab tab, IPreferencesService service, String level, String name, String labelText, Composite parent) {
        super(page, tab, service, level, name, labelText, 15, parent);
    }

    public void setValidRange(double min, double max) {
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    public double getDoubleValue() throws NumberFormatException {
        return Double.parseDouble(this.getStringValue());
    }

    protected boolean checkState() {
        block5: {
            Text text = this.getTextControl(this.parent);
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            if (numberString == null || numberString.equals("")) {
                numberString = "0";
            }
            try {
                double number = Double.valueOf(numberString);
                if (!(number >= this.minValidValue) || !(number <= this.maxValidValue)) break block5;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(String.valueOf(this.getLevelName()) + ":  " + this.getLabelText() + "  " + "Number format exception");
                return false;
            }
        }
        this.setErrorMessage(String.valueOf(this.getLevelName()) + ":  " + this.getLabelText() + "  " + this.errorMessage);
        return false;
    }

    public String getLevelName() {
        if (this.preferencesLevel.equals("default")) {
            return "Default";
        }
        if (this.preferencesLevel.equals("configuration")) {
            return "Configuration";
        }
        if (this.preferencesLevel.equals("instance")) {
            return "Workspace";
        }
        if (this.preferencesLevel.equals("project")) {
            return "Project";
        }
        return "";
    }
}

