/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.editor.EditorUtility;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceEntity;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof ISourceEntity) {
            EditorUtility.revealInEditor(part, (ISourceEntity)element);
        }
    }

    public static List<ISourceEntity> filterResolveResults(ISourceEntity[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<ISourceEntity> refs = new ArrayList<ISourceEntity>(nResults);
        int i = 0;
        while (i < nResults) {
            refs.add(codeResolveResults[i]);
            ++i;
        }
        return refs;
    }

    public static ISourceEntity selectSourceEntity(ISourceEntity[] entities, Shell shell, String title, String message, Language lang) {
        Object[] selection;
        int nResults = entities.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return entities[0];
        }
        ILabelProvider labelProvider = ServiceFactory.getInstance().getLabelProvider(lang);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (org.eclipse.jface.viewers.ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])entities);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof ISourceEntity) {
                    return (ISourceEntity)current;
                }
                ++i;
            }
        }
        return null;
    }
}

