/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.services.ILabelProvider;
import org.eclipse.imp.utils.MarkerUtils;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.qvt.declarative.editor.AbstractLabelElement;
import org.eclipse.qvt.declarative.editor.EcoreLabelElement;
import org.eclipse.qvt.declarative.editor.JavaLabelElement;
import org.eclipse.qvt.declarative.editor.LabelBehavior;
import org.eclipse.qvt.declarative.editor.OutlineGroup;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonEditorDefinition;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonParseResult;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.eclipse.qvt.declarative.editor.util.FormatProvider;
import org.eclipse.qvt.declarative.editor.util.ImageProvider;
import org.eclipse.qvt.declarative.editor.util.TextProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonLabelProvider
implements ILabelProvider {
    private Set<ILabelProviderListener> fListeners = new HashSet<ILabelProviderListener>();
    protected ExtendedImageRegistry imageRegistry = new ExtendedImageRegistry();
    private Image errorImageOverlay = null;
    private Image warningImageOverlay = null;

    public void addListener(ILabelProviderListener listener) {
        this.fListeners.add(listener);
    }

    protected Object checkedGet(Object object, EStructuralFeature path) {
        if (path == null) {
            throw new NullPointerException("Null path element");
        }
        if (object == null) {
            throw new NullPointerException("Null path object");
        }
        if (!(object instanceof EObject)) {
            throw new ClassCastException("Non EObject");
        }
        EClass objectEClass = ((EObject)object).eClass();
        EClass pathEClass = path.getEContainingClass();
        if (!pathEClass.isSuperTypeOf(objectEClass)) {
            throw new IllegalArgumentException("Incompatible " + objectEClass.getName() + " for " + pathEClass.getName());
        }
        return ((EObject)object).eGet(path);
    }

    public void dispose() {
    }

    protected String formatEcoreLabelElement(Object node, EcoreLabelElement labelElement) {
        StringBuffer s = new StringBuffer();
        s.append(labelElement.getPrefix());
        int prefixSize = s.length();
        this.formatEcoreLabelElementStep(s, node, labelElement, 0);
        if (labelElement.isHideIfBlank() && prefixSize == s.length()) {
            return "";
        }
        s.append(labelElement.getSuffix());
        return s.toString();
    }

    protected void formatEcoreLabelElementStep(StringBuffer s, Object object, EcoreLabelElement labelElement, int step) {
        EList path = labelElement.getPath();
        int maxStep = path.size();
        if (step < maxStep) {
            EReference feature = (EReference)path.get(step);
            Object nextObject = this.checkedGet(object, (EStructuralFeature)feature);
            if (feature.isMany()) {
                boolean isFirst = true;
                for (Object childObject : (Collection)nextObject) {
                    if (!isFirst) {
                        s.append(labelElement.getSeparator());
                    }
                    this.formatEcoreLabelElementStep(s, childObject, labelElement, step + 1);
                    isFirst = false;
                }
            } else if (nextObject != null) {
                this.formatEcoreLabelElementStep(s, nextObject, labelElement, step + 1);
            }
        } else {
            TextProvider textProvider = null;
            try {
                Class textProviderClass = labelElement.getTextProvider();
                textProvider = textProviderClass != null ? (TextProvider)textProviderClass.newInstance() : null;
            }
            catch (Exception exception) {}
            EStructuralFeature feature = labelElement.getEnd();
            if (object instanceof EObject) {
                if (feature == null) {
                    String text = null;
                    if (textProvider != null) {
                        text = textProvider.getText(object);
                    }
                    if (text == null) {
                        s.append("<" + ((EObject)object).eClass().getName() + ">");
                    }
                    s.append(text);
                } else {
                    Object nextObject = this.checkedGet(object, feature);
                    if (feature.isMany()) {
                        boolean isFirst = true;
                        for (Object childObject : (Collection)nextObject) {
                            if (!isFirst) {
                                s.append(labelElement.getSeparator());
                            }
                            String text = null;
                            if (textProvider != null) {
                                text = textProvider.getText(childObject);
                            }
                            if (text == null) {
                                text = this.formatObject(childObject);
                            }
                            s.append(text);
                            isFirst = false;
                        }
                    } else {
                        String text = null;
                        if (textProvider != null) {
                            text = textProvider.getText(nextObject);
                        }
                        if (text == null) {
                            text = this.formatObject(nextObject);
                        }
                        s.append(text);
                    }
                }
            } else {
                s.append("<" + object.getClass().getName() + ">");
            }
        }
    }

    protected String formatEnum(Enum<?> object) {
        return object.toString();
    }

    protected String formatException(Throwable e, Object node, int index) {
        return "<!" + e.getClass().getSimpleName() + "!>";
    }

    /*
     * Unable to fully structure code
     */
    protected Object formatJavaLabelElement(Object node, JavaLabelElement labelElement) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        methodName = labelElement.getMethod();
        className = labelElement.getClass_();
        if (className == null) {
            methodClass = node.getClass();
            method = methodClass.getMethod(methodName, new Class[0]);
            return String.valueOf(method.invoke(node, new Object[0]));
        }
        methodClass = Class.forName(className);
        nodeClass = node.getClass();
        while (nodeClass != null) {
            try {
                method = methodClass.getMethod(methodName, new Class[]{nodeClass});
                return String.valueOf(method.invoke(null, new Object[]{node}));
            }
            catch (NoSuchMethodException v0) {
                var10_12 = nodeClass.getInterfaces();
                var9_11 = var10_12.length;
                var8_10 = 0;
                ** while (var8_10 < var9_11)
            }
lbl-1000:
            // 1 sources

            {
                nodeInterface = var10_12[var8_10];
                try {
                    method = methodClass.getMethod(methodName, new Class[]{nodeInterface});
                    return String.valueOf(method.invoke(null, new Object[]{node}));
                }
                catch (NoSuchMethodException v1) {
                    ++var8_10;
                }
                continue;
            }
lbl25:
            // 1 sources

            nodeClass = nodeClass.getSuperclass();
        }
        method = methodClass.getMethod(methodName, new Class[]{node.getClass()});
        return String.valueOf(method.invoke(null, new Object[]{node}));
    }

    protected String formatNull() {
        return "";
    }

    protected String formatNumber(Number number) {
        return String.valueOf(number);
    }

    protected String formatObject(Object node) {
        if (node == null) {
            return this.formatNull();
        }
        if (node instanceof Enum) {
            return this.formatEnum((Enum)node);
        }
        if (node instanceof Number) {
            return this.formatNumber((Number)node);
        }
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof OutlineGroup) {
            return ((OutlineGroup)node).getName();
        }
        CommonEditorDefinition commonEditorDefinition = this.getPlugin().getEditorDefinition();
        LabelBehavior behavior = commonEditorDefinition.getBehavior(node, LabelBehavior.class);
        if (behavior == null) {
            return "<" + String.valueOf(node) + ">";
        }
        String format = null;
        Class formatProviderClass = behavior.getFormatProvider();
        if (formatProviderClass != null) {
            try {
                format = ((FormatProvider)formatProviderClass.newInstance()).getFormat(node);
            }
            catch (Exception exception) {}
        }
        if (format == null) {
            format = behavior.getFormat();
        }
        EList labelElements = behavior.getElements();
        int iMax = labelElements.size();
        Object[] strings = new String[iMax];
        int i = 0;
        while (i < iMax) {
            try {
                AbstractLabelElement labelElement = (AbstractLabelElement)labelElements.get(i);
                strings[i] = labelElement instanceof EcoreLabelElement ? this.formatEcoreLabelElement(node, (EcoreLabelElement)labelElement) : (labelElement instanceof JavaLabelElement ? this.formatJavaLabelElement(node, (JavaLabelElement)labelElement) : "<?" + labelElement.getClass().getSimpleName() + "?>");
            }
            catch (Throwable e) {
                strings[i] = this.formatException(e, node, i);
            }
            ++i;
        }
        return NLS.bind((String)format, (Object[])strings);
    }

    protected Object getASTorCSTNode(Object element) {
        if (element instanceof ModelTreeNode) {
            return ((ModelTreeNode)element).getASTNode();
        }
        if (element instanceof ICommonParseResult) {
            return ((ICommonParseResult)element).getCST();
        }
        return element;
    }

    public CommonEditorDefinition getEditorDefinition() {
        return this.getPlugin().getEditorDefinition();
    }

    protected Image getErrorImageOverlay() {
        if (this.errorImageOverlay == null) {
            this.errorImageOverlay = this.getImage(QVTEditorPlugin.getDefault().getBundle(), "icons/error_ovr.gif");
        }
        return this.errorImageOverlay;
    }

    public Image getImage(Object element) {
        String imageName = null;
        if (element instanceof ModelTreeNode) {
            ModelTreeNode treeNode = (ModelTreeNode)element;
            int category = treeNode.getCategory();
            OutlineGroup outlineGroup = this.getEditorDefinition().getOutlineGroup(category);
            if (outlineGroup != null) {
                imageName = outlineGroup.getImage();
            }
        }
        Object node = this.getASTorCSTNode(element);
        if (imageName == null) {
            imageName = this.getImageName(node);
        }
        if (imageName == null) {
            return null;
        }
        Image image = this.getImage(this.getPlugin().getBundle(), imageName);
        if (image == null) {
            return null;
        }
        Collection<Image> overlays = this.getOverlayImages(node);
        if (overlays == null || overlays.isEmpty()) {
            return image;
        }
        ArrayList<Image> images = new ArrayList<Image>(overlays.size() + 1);
        images.add(image);
        images.addAll(overlays);
        return this.imageRegistry.getImage((Object)new ComposedImage(images));
    }

    protected Image getImage(Bundle defaultBundle, String imagePath) {
        Path path;
        URL url;
        int index;
        Bundle bundle = defaultBundle;
        String imageFile = imagePath;
        if (imagePath.startsWith("/") && (index = imagePath.indexOf(47, 1)) > 1) {
            imageFile = imagePath.substring(index + 1);
            String bundlePath = imagePath.substring(1, index);
            bundle = Platform.getBundle((String)bundlePath);
            if (bundle == null) {
                this.getPlugin().logException("No such bundle '" + bundlePath + "'", null);
                return null;
            }
        }
        if ((url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(imageFile)), null)) == null) {
            return null;
        }
        Image image = this.imageRegistry.getImage((Object)url);
        return image;
    }

    public String getImageName(Object node) {
        if (node instanceof OutlineGroup) {
            return ((OutlineGroup)node).getImage();
        }
        CommonEditorDefinition commonEditorDefinition = this.getPlugin().getEditorDefinition();
        LabelBehavior behavior = commonEditorDefinition.getBehavior(node, LabelBehavior.class);
        if (behavior == null) {
            return null;
        }
        String imageName = null;
        Class imageProviderClass = behavior.getImageProvider();
        if (imageProviderClass != null) {
            try {
                imageName = ((ImageProvider)imageProviderClass.newInstance()).getImage(node);
            }
            catch (Exception exception) {}
        }
        if (imageName == null) {
            imageName = behavior.getImage();
        }
        return imageName;
    }

    protected Collection<Image> getOverlayImages(Object node) {
        if (node instanceof IFile) {
            IFile file = (IFile)node;
            int sev = MarkerUtils.getMaxProblemMarkerSeverity((IResource)file, (int)1);
            switch (sev) {
                case 2: {
                    return Collections.singletonList(this.getErrorImageOverlay());
                }
                case 1: {
                    return Collections.singletonList(this.getWarningImageOverlay());
                }
            }
        }
        return null;
    }

    protected Image getWarningImageOverlay() {
        if (this.warningImageOverlay == null) {
            this.warningImageOverlay = this.getImage(QVTEditorPlugin.getDefault().getBundle(), "icons/warn_ovr.gif");
        }
        return this.warningImageOverlay;
    }

    protected abstract ICommonPlugin getPlugin();

    public String getText(Object element) {
        Object node = this.getASTorCSTNode(element);
        String text = this.formatObject(node);
        if (text == null) {
            return "<!null!>";
        }
        if (!(element instanceof ModelTreeNode)) {
            return text;
        }
        ModelTreeNode treeNode = (ModelTreeNode)element;
        int category = treeNode.getCategory();
        OutlineGroup outlineGroup = this.getEditorDefinition().getOutlineGroup(category);
        if (outlineGroup == null) {
            return text;
        }
        return String.valueOf(outlineGroup.getName()) + text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.fListeners.remove(listener);
    }
}

