/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;

public abstract class CommonDocumentationProvider
implements IDocumentationProvider,
ILanguageService {
    public static String getSubstring(CommonParseController parseController, int start, int end) {
        return new String(parseController.getLexer().getInputChars(), start, end - start + 1);
    }

    public static String getSubstring(CommonParseController parseController, CSTNode cstNode) {
        return CommonDocumentationProvider.getSubstring(parseController, cstNode.getStartOffset(), cstNode.getEndOffset());
    }

    public String getDocumentation(Object node, IParseController controller) {
        if (node == null) {
            return null;
        }
        if (node instanceof CSTNode) {
            CommonParseController parseController = (CommonParseController)controller;
            CSTNode cstNode = (CSTNode)node;
            CommonParseController.TokenKind tokenKind = parseController.getTokenKind(this.getTokenKindForNode(cstNode));
            switch (tokenKind) {
                case IDENTIFIER: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is an identifier";
                }
                case INTEGER: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is an integer number";
                }
                case REAL: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is a floating point number";
                }
                case KEYWORD: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is a keyword";
                }
                case LINE_COMMENT: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is a line comment";
                }
                case PARAGRAPH_COMMENT: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is a paragraph comment";
                }
                case STRING: {
                    return "'" + CommonDocumentationProvider.getSubstring(parseController, cstNode) + "' is a string";
                }
            }
            return null;
        }
        return null;
    }

    public int getTokenKindForNode(CSTNode node) {
        return node.getEndToken().getKind();
    }
}

