/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.compilation;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.qvt.declarative.common.framework.service.Operation;
import org.eclipse.qvt.declarative.common.framework.service.Provider;
import org.eclipse.qvt.declarative.common.framework.service.ProviderDescriptor;
import org.eclipse.qvt.declarative.compilation.CompilationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileOperation
implements Operation {
    protected Object abstractSyntaxTree;
    protected Map<String, String> parameters;
    protected List<File> sourceFolders;
    protected File binFolder;

    public CompileOperation(Object abstractSyntaxTree, Map<String, String> parameters, List<File> sourceFolders, File buildFolder) {
        this.abstractSyntaxTree = abstractSyntaxTree;
        this.parameters = parameters;
        this.sourceFolders = sourceFolders;
        this.binFolder = buildFolder;
    }

    public List<File> execute(Provider provider) throws Exception {
        List<File> result = null;
        if (provider instanceof ProviderDescriptor) {
            ProviderDescriptor descriptor = (ProviderDescriptor)provider;
            provider = descriptor.getDescribedProvider();
        }
        if (provider instanceof CompilationProvider) {
            CompilationProvider compilationProvider = (CompilationProvider)provider;
            result = compilationProvider.compile(this.abstractSyntaxTree, this.parameters, this.sourceFolders, this.binFolder);
        }
        return result;
    }

    public Object getSource() {
        return this.abstractSyntaxTree;
    }

    public void setSource(Object source) {
        this.abstractSyntaxTree = source;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public List<File> getSourceFolders() {
        return this.sourceFolders;
    }

    public void setSourceFolder(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public void setBinFolder(File binFolder) {
        this.binFolder = binFolder;
    }
}

