/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.HoverHelper;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IHoverHelper;
import org.eclipse.imp.services.base.HoverHelperBase;
import org.eclipse.imp.utils.AnnotationUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;

public class HoverHelpController
implements ITextHover,
IModelListener {
    private IParseController controller;
    private IHoverHelper hoverHelper;

    public HoverHelpController(Language language) {
        this.hoverHelper = ServiceFactory.getInstance().getHoverHelper(language);
        if (this.hoverHelper == null) {
            this.hoverHelper = new HoverHelper(language);
        } else if (this.hoverHelper instanceof HoverHelperBase) {
            ((HoverHelperBase)this.hoverHelper).setLanguage(language);
        }
    }

    public IModelListener.AnalysisRequired getAnalysisRequired() {
        return IModelListener.AnalysisRequired.NAME_ANALYSIS;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        try {
            int offset = hoverRegion.getOffset();
            String help = null;
            if (this.controller != null && this.hoverHelper != null) {
                help = this.hoverHelper.getHoverHelpAt(this.controller, (ISourceViewer)textViewer, offset);
            }
            if (help == null) {
                help = AnnotationUtils.formatAnnotationList(AnnotationUtils.getAnnotationsForOffset((ISourceViewer)textViewer, offset));
            }
            return help;
        }
        catch (Throwable e) {
            ErrorHandler.reportError("Universal Editor Error", e);
            return null;
        }
    }

    public void update(IParseController controller, IProgressMonitor monitor) {
        this.controller = controller;
    }
}

