/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.help.IContextProvider;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.EditorInputUtils;
import org.eclipse.imp.editor.GotoMatchingFenceAction;
import org.eclipse.imp.editor.IRegionSelectionService;
import org.eclipse.imp.editor.LanguageServiceManager;
import org.eclipse.imp.editor.OutlineInformationControl;
import org.eclipse.imp.editor.ParserScheduler;
import org.eclipse.imp.editor.ServiceControllerManager;
import org.eclipse.imp.editor.StructuredSourceViewer;
import org.eclipse.imp.editor.internal.AnnotationCreator;
import org.eclipse.imp.editor.internal.EditorErrorTickUpdater;
import org.eclipse.imp.editor.internal.FoldingController;
import org.eclipse.imp.editor.internal.ProblemMarkerManager;
import org.eclipse.imp.editor.internal.ToggleBreakpointsAdapter;
import org.eclipse.imp.help.IMPHelp;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.LanguageRegistry;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.preferences.PreferenceCache;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.services.IASTFindReplaceTarget;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.imp.services.IDocumentationProvider;
import org.eclipse.imp.services.IEditorService;
import org.eclipse.imp.services.ILanguageActionsContributor;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.imp.services.IOccurrenceMarker;
import org.eclipse.imp.services.IRefactoringContributor;
import org.eclipse.imp.services.base.DefaultAnnotationHover;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.imp.ui.DefaultPartListener;
import org.eclipse.imp.ui.textPresentation.HTMLTextPresenter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class UniversalEditor
extends TextEditor
implements IASTFindReplaceTarget {
    public static final String FORMAT_SOURCE_COMMAND = "org.eclipse.imp.runtime.formatSource";
    public static final String TOGGLE_COMMENT_COMMAND = "org.eclipse.imp.runtime.toggleComment";
    public static final String SHOW_OUTLINE_COMMAND = "org.eclipse.imp.runtime.showOutlineCommand";
    public static final String INDENT_SELECTION_COMMAND = "org.eclipse.imp.runtime.indentSelection";
    public static final String GOTO_MATCHING_FENCE_COMMAND = "org.eclipse.imp.runtime.gotoMatchingFence";
    public static final String MESSAGE_BUNDLE = "org.eclipse.imp.editor.messages";
    public static final String EDITOR_ID = "org.eclipse.imp.runtime.impEditor";
    public static final String PARSE_ANNOTATION_TYPE = "org.eclipse.imp.editor.parseAnnotation";
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public Language fLanguage;
    public ParserScheduler fParserScheduler;
    protected LanguageServiceManager fLanguageServiceManager;
    protected ServiceControllerManager fServiceControllerManager;
    private ProjectionAnnotationModel fAnnotationModel;
    private ProblemMarkerManager fProblemMarkerManager;
    private ICharacterPairMatcher fBracketMatcher;
    private SubActionBars fActionBars;
    private DefaultPartListener fRefreshContributions;
    private static final String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.imp.editor.messages";
    private static final String IMP_EDITOR_CONTEXT = "org.eclipse.imp.runtime.imp_editor_context";
    static ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle("org.eclipse.imp.editor.messages");
    private BracketInserter fBracketInserter;
    private final String CLOSE_FENCES = "closeFences";
    private static final int REPARSE_SCHEDULE_DELAY = 100;
    public final String PARSE_ANNOTATION = "Parse_Annotation";
    private Map<IMarker, Annotation> markerParseAnnotations = new HashMap<IMarker, Annotation>();
    private Map<IMarker, MarkerAnnotation> markerMarkerAnnotations = new HashMap<IMarker, MarkerAnnotation>();
    private IMessageHandler fAnnotationCreator = new AnnotationCreator((ITextEditor)this, "org.eclipse.imp.editor.parseAnnotation");
    private final IPropertyChangeListener fPrefStoreListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("sourceFont")) {
                FontRegistry fontReg = RuntimePlugin.getInstance().getFontRegistry();
                fontReg.put("sourceFont", (FontData[])event.getNewValue());
                Font sourceFont = fontReg.get("sourceFont");
                if (UniversalEditor.this.getSourceViewer() != null) {
                    UniversalEditor.this.getSourceViewer().getTextWidget().setFont(sourceFont);
                }
            } else if (event.getProperty().equals("tabWidth")) {
                int newTab;
                PreferenceCache.tabWidth = newTab = event.getNewValue() instanceof String ? Integer.parseInt((String)event.getNewValue()) : (Integer)event.getNewValue();
                if (UniversalEditor.this.getSourceViewer() != null) {
                    UniversalEditor.this.getSourceViewer().getTextWidget().setTabs(PreferenceCache.tabWidth);
                }
            } else if (event.getProperty().equals("emitMessages")) {
                PreferenceCache.emitMessages = (Boolean)event.getNewValue();
            } else if (event.getProperty().equals("dumpTokens")) {
                PreferenceCache.dumpTokens = (Boolean)event.getNewValue();
            }
        }
    };
    private final IRegionSelectionService fRegionSelector = new IRegionSelectionService(){

        public void selectAndReveal(int startOffset, int length) {
            IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            AbstractTextEditor textEditor = (AbstractTextEditor)activeEditor;
            textEditor.selectAndReveal(startOffset, length);
        }
    };
    private EditorErrorTickUpdater fEditorErrorTickUpdater;

    public UniversalEditor() {
        if (PreferenceCache.emitMessages) {
            RuntimePlugin.getInstance().writeInfoMsg("Creating UniversalEditor instance");
        }
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new StructuredSourceViewerConfiguration());
        this.configureInsertMode(SMART_INSERT, true);
        this.setInsertMode(SMART_INSERT);
        this.fProblemMarkerManager = new ProblemMarkerManager();
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.fServiceControllerManager.getOutlineController();
        }
        if (IToggleBreakpointsTarget.class.equals((Object)required)) {
            return new ToggleBreakpointsAdapter(this);
        }
        if (IRegionSelectionService.class.equals((Object)required)) {
            return this.fRegionSelector;
        }
        if (IContextProvider.class.equals((Object)required)) {
            return IMPHelp.getHelpContextProvider((IWorkbenchPart)this, this.fLanguageServiceManager, IMP_EDITOR_CONTEXT);
        }
        return super.getAdapter(required);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.imp.editor.messages");
        Object action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        action = new TextOperationAction(bundle, "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId(FORMAT_SOURCE_COMMAND);
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        action = new TextOperationAction(bundle, "ShowOutline.", (ITextEditor)this, 51);
        action.setActionDefinitionId(SHOW_OUTLINE_COMMAND);
        this.setAction(SHOW_OUTLINE_COMMAND, (IAction)action);
        action = new TextOperationAction(bundle, "ToggleComment.", (ITextEditor)this, 54);
        action.setActionDefinitionId(TOGGLE_COMMENT_COMMAND);
        this.setAction(TOGGLE_COMMENT_COMMAND, (IAction)action);
        action = new TextOperationAction(bundle, "IndentSelection.", (ITextEditor)this, 60);
        action.setActionDefinitionId(INDENT_SELECTION_COMMAND);
        this.setAction(INDENT_SELECTION_COMMAND, (IAction)action);
        action = new GotoMatchingFenceAction(this);
        action.setActionDefinitionId(GOTO_MATCHING_FENCE_COMMAND);
        this.setAction(GOTO_MATCHING_FENCE_COMMAND, (IAction)action);
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.contributeRefactoringActions(menu);
        this.contributeLanguageActions(menu);
    }

    private void contributeRefactoringActions(IMenuManager menu) {
        Set<IRefactoringContributor> contributors = this.fLanguageServiceManager.getRefactoringContributors();
        if (contributors != null && !contributors.isEmpty()) {
            ArrayList<IAction> editorActions = new ArrayList<IAction>();
            for (IRefactoringContributor con : contributors) {
                try {
                    IAction[] conActions = con.getEditorRefactoringActions(this);
                    int i = 0;
                    while (i < conActions.length) {
                        editorActions.add(conActions[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    RuntimePlugin.getInstance().logException("Unable to create refactoring actions for contributor " + con, e);
                }
            }
            Separator refGroup = new Separator("group.refactor");
            MenuManager refMenu = new MenuManager("Refac&tor");
            menu.add((IContributionItem)refGroup);
            menu.appendToGroup("group.refactor", (IContributionItem)refMenu);
            Iterator actionIter = editorActions.iterator();
            while (actionIter.hasNext()) {
                refMenu.add((IAction)actionIter.next());
            }
        }
    }

    private void contributeLanguageActions(IMenuManager menu) {
        Set<ILanguageActionsContributor> actionContributors = this.fLanguageServiceManager.getActionContributors();
        if (!actionContributors.isEmpty()) {
            menu.add((IContributionItem)new Separator());
        }
        for (ILanguageActionsContributor con : actionContributors) {
            try {
                con.contributeToEditorMenu(this, menu);
            }
            catch (Exception e) {
                RuntimePlugin.getInstance().logException("Unable to create editor actions for contributor " + con, e);
            }
        }
    }

    protected boolean isOverviewRulerVisible() {
        return true;
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        return this.fProblemMarkerManager;
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public Annotation gotoAnnotation(boolean forward) {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        Annotation annotation = null;
        annotation = this.getNextAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    private Annotation getNextAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof MarkerAnnotation) && !a.getType().equals(PARSE_ANNOTATION_TYPE) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private void updateAnnotationViews(Annotation annotation) {
        IMarker marker = null;
        if (annotation instanceof MarkerAnnotation) {
            marker = ((MarkerAnnotation)annotation).getMarker();
        } else if (marker != null) {
            try {
                boolean isProblem = marker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
                IWorkbenchPage page = this.getSite().getPage();
                IViewPart view = page.findView(isProblem ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList");
                if (view != null) {
                    Method method = view.getClass().getMethod("setSelection", IStructuredSelection.class, Boolean.TYPE);
                    method.invoke((Object)view, new StructuredSelection((Object)marker), Boolean.TRUE);
                }
            }
            catch (CoreException coreException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void createPartControl(Composite parent) {
        this.fLanguage = LanguageRegistry.findLanguage(this.getEditorInput(), this.getDocumentProvider());
        if (this.fLanguage == null) {
            throw new NullPointerException("No language support found for files of type '" + EditorInputUtils.getPath(this.getEditorInput()).getFileExtension() + "'");
        }
        if (this.fLanguage != null) {
            this.fLanguageServiceManager = new LanguageServiceManager(this.fLanguage);
            this.fLanguageServiceManager.initialize((IEditorPart)this);
            this.fServiceControllerManager = new ServiceControllerManager((ITextEditor)this, this.fLanguageServiceManager);
            this.fServiceControllerManager.initialize();
            if (this.fLanguageServiceManager.getParseController() != null) {
                IEditorInput editorInput = this.getEditorInput();
                IFile file = EditorInputUtils.getFile(editorInput);
                IPath filePath = EditorInputUtils.getPath(editorInput);
                try {
                    ISourceProject srcProject = file != null ? ModelFactory.open(file.getProject()) : null;
                    this.fLanguageServiceManager.getParseController().initialize(filePath, srcProject, this.fAnnotationCreator);
                }
                catch (ModelFactory.ModelException e) {
                    ErrorHandler.reportError("Error initializing parser for input " + editorInput.getName() + ":", e);
                }
            }
        }
        super.createPartControl(parent);
        if (this.fLanguageServiceManager.getParseController() != null) {
            this.fServiceControllerManager.setSourceViewer(this.getSourceViewer());
            this.initiateServiceControllers();
        }
        this.setTitleImageFromLanguageIcon();
        IPreferenceStore prefStore = this.setSourceFontFromPreference();
        this.setupBracketCloser(prefStore);
        prefStore.addPropertyChangeListener(this.fPrefStoreListener);
        this.initializeEditorContributors();
        this.watchForSourceMove();
    }

    private void watchDocument(final long reparse_schedule_delay) {
        if (this.fLanguageServiceManager.getParseController() == null) {
            return;
        }
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        doc.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                UniversalEditor.this.fParserScheduler.cancel();
                UniversalEditor.this.fParserScheduler.schedule(reparse_schedule_delay);
            }
        });
    }

    private void setupBracketCloser(IPreferenceStore preferenceStore) {
    }

    private void watchForSourceMove() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IParseController pc = UniversalEditor.this.fLanguageServiceManager.getParseController();
                if (pc == null) {
                    return;
                }
                IPath oldWSRelPath = pc.getProject().getRawProject().getFullPath().append(pc.getPath());
                IResourceDelta rd = event.getDelta().findMember(oldWSRelPath);
                if (rd != null && (rd.getFlags() & 0x2000) == 8192) {
                    IPath newPath = rd.getMovedToPath();
                    IPath newProjRelPath = newPath.removeFirstSegments(1);
                    String newProjName = newPath.segment(0);
                    boolean sameProj = pc.getProject().getRawProject().getName().equals(newProjName);
                    try {
                        ISourceProject proj = sameProj ? pc.getProject() : ModelFactory.open(ResourcesPlugin.getWorkspace().getRoot().getProject(newProjName));
                        pc.initialize(newProjRelPath, proj, UniversalEditor.this.fAnnotationCreator);
                    }
                    catch (ModelFactory.ModelException e) {
                        RuntimePlugin.getInstance().logException("Error tracking resource move", e);
                    }
                }
            }
        });
    }

    private IPreferenceStore setSourceFontFromPreference() {
        Font sourceFont;
        IPreferenceStore prefStore = RuntimePlugin.getInstance().getPreferenceStore();
        String fontName = prefStore.getString("sourceFont");
        FontRegistry fontRegistry = RuntimePlugin.getInstance().getFontRegistry();
        if (!fontRegistry.hasValueFor(fontName)) {
            fontRegistry.put(fontName, PreferenceConverter.readFontData((String)fontName));
        }
        if ((sourceFont = fontRegistry.get(fontName)) != null) {
            this.getSourceViewer().getTextWidget().setFont(sourceFont);
        }
        return prefStore;
    }

    private void initiateServiceControllers() {
        try {
            StructuredSourceViewer sourceViewer = (StructuredSourceViewer)this.getSourceViewer();
            if (PreferenceCache.emitMessages) {
                RuntimePlugin.getInstance().writeInfoMsg("Creating language service controllers for " + this.fLanguage.getName());
            }
            this.fEditorErrorTickUpdater = new EditorErrorTickUpdater(this);
            this.fProblemMarkerManager.addListener(this.fEditorErrorTickUpdater);
            this.fParserScheduler = new ParserScheduler(this.fLanguageServiceManager.getParseController(), (IEditorPart)this, this.getDocumentProvider(), this.fAnnotationCreator);
            sourceViewer.setTextHover(this.fServiceControllerManager.getHoverHelpController(), "__dftl_partition_content_type");
            ContentFormatter formatter = new ContentFormatter();
            formatter.setFormattingStrategy((IFormattingStrategy)this.fServiceControllerManager.getFormattingController(), "__dftl_partition_content_type");
            sourceViewer.setFormatter((IContentFormatter)formatter);
            this.fServiceControllerManager.getPresentationController().damage((IRegion)new Region(0, sourceViewer.getDocument().getLength()));
            sourceViewer.setParseController(this.fLanguageServiceManager.getParseController());
            if (this.fLanguageServiceManager.getFoldingUpdater() != null) {
                StructuredSourceViewer projViewer = sourceViewer;
                ProjectionSupport projectionSupport = new ProjectionSupport((ProjectionViewer)projViewer, this.getAnnotationAccess(), this.getSharedColors());
                projectionSupport.install();
                projViewer.doOperation(19);
                this.fAnnotationModel = projViewer.getProjectionAnnotationModel();
                this.fParserScheduler.addModelListener(new FoldingController(this.fAnnotationModel, this.fLanguageServiceManager.getFoldingUpdater()));
            }
            this.fParserScheduler.addModelListener(new AnnotationCreatorListener());
            this.fServiceControllerManager.setupModelListeners(this.fParserScheduler);
            this.installExternalEditorServices();
            this.watchDocument(100L);
            this.fParserScheduler.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            ErrorHandler.reportError("Error while creating service controllers", e);
        }
    }

    private void setTitleImageFromLanguageIcon() {
        if (this.fLanguageServiceManager.getLabelProvider() != null) {
            IEditorInput editorInput = this.getEditorInput();
            IFile file = EditorInputUtils.getFile(editorInput);
            this.setTitleImage(this.fLanguageServiceManager.getLabelProvider().getImage((Object)file));
        }
    }

    private void installExternalEditorServices() {
        Set<IModelListener> editorServices = this.fLanguageServiceManager.getEditorServices();
        for (ILanguageService iLanguageService : editorServices) {
            if (iLanguageService instanceof IEditorService) {
                ((IEditorService)iLanguageService).setEditor(this);
            }
            this.fParserScheduler.addModelListener((IModelListener)iLanguageService);
        }
    }

    private void initializeEditorContributors() {
        if (this.fLanguage != null) {
            this.addEditorActions();
            this.registerEditorContributionsActivator();
        }
    }

    private void registerEditorContributionsActivator() {
        this.fRefreshContributions = new DefaultPartListener(){
            private UniversalEditor editor;
            {
                this.editor = UniversalEditor.this;
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == this.editor) {
                    this.editor.fActionBars.activate();
                    this.editor.fActionBars.updateActionBars();
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
                if (part == this.editor) {
                    this.editor.fActionBars.deactivate();
                    this.editor.fActionBars.updateActionBars();
                }
            }
        };
        this.getSite().getPage().addPartListener((IPartListener)this.fRefreshContributions);
    }

    private void unregisterEditorContributionsActivator() {
        this.getSite().getPage().removePartListener((IPartListener)this.fRefreshContributions);
        this.fRefreshContributions = null;
    }

    private void addEditorActions() {
        IActionBars allActionBars = this.getEditorSite().getActionBars();
        if (this.fActionBars == null) {
            Set<ILanguageActionsContributor> contributors = ServiceFactory.getInstance().getLanguageActionsContributors(this.fLanguage);
            this.fActionBars = new SubActionBars(allActionBars);
            IStatusLineManager status = this.fActionBars.getStatusLineManager();
            IToolBarManager toolbar = this.fActionBars.getToolBarManager();
            IMenuManager menu = this.fActionBars.getMenuManager();
            for (ILanguageActionsContributor c : contributors) {
                c.contributeToStatusLine(this, status);
                c.contributeToToolBar(this, toolbar);
                c.contributeToMenuBar(this, menu);
            }
            this.fActionBars.updateActionBars();
            allActionBars.updateActionBars();
        }
        allActionBars.updateActionBars();
    }

    public void dispose() {
        RuntimePlugin.getInstance().getPreferenceStore().removePropertyChangeListener(this.fPrefStoreListener);
        this.unregisterEditorContributionsActivator();
        if (this.fEditorErrorTickUpdater != null) {
            this.fProblemMarkerManager.removeListener(this.fEditorErrorTickUpdater);
        }
        if (this.fActionBars != null) {
            this.fActionBars.dispose();
            this.fActionBars = null;
        }
        super.dispose();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StructuredSourceViewer viewer = new StructuredSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        if (this.fLanguageServiceManager.getParseController() != null) {
            IMPHelp.setHelp(this.fLanguageServiceManager, (ITextEditor)this, viewer.getTextWidget(), IMP_EDITOR_CONTEXT);
        }
        return viewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        String[][] fences;
        if (this.fLanguage == null || this.fLanguageServiceManager == null) {
            return;
        }
        IParseController parseController = this.fLanguageServiceManager.getParseController();
        if (parseController == null) {
            return;
        }
        ILanguageSyntaxProperties syntaxProps = parseController.getSyntaxProperties();
        this.getPreferenceStore().setValue(MATCHING_BRACKETS, true);
        if (syntaxProps != null && (fences = syntaxProps.getFences()) != null) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < fences.length) {
                sb.append(fences[i][0]);
                sb.append(fences[i][1]);
                ++i;
            }
            this.fBracketMatcher = new DefaultCharacterPairMatcher(sb.toString().toCharArray());
            support.setCharacterPairMatcher(this.fBracketMatcher);
            support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        }
        super.configureSourceViewerDecorationSupport(support);
    }

    public void gotoMatchingFence() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage("Invalid selection");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (this.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage("No matching fence!");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage("Matching fence is outside the currently selected element.");
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    private boolean isBracket(char character) {
        ILanguageSyntaxProperties syntaxProps = this.fLanguageServiceManager.getParseController().getSyntaxProperties();
        String[][] fences = syntaxProps.getFences();
        int i = 0;
        while (i != fences.length) {
            if (fences[i][0].indexOf(character) >= 0) {
                return true;
            }
            if (fences[i][1].indexOf(character) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return this.isBracket(document.getChar(offset - 1)) && this.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = UniversalEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public void refreshMarkerAnnotations(String problemMarkerType) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator annIter = model.getAnnotationIterator();
        ArrayList<MarkerAnnotation> markerAnnotations = new ArrayList<MarkerAnnotation>();
        while (annIter.hasNext()) {
            Object ann = annIter.next();
            if (!(ann instanceof MarkerAnnotation)) continue;
            markerAnnotations.add((MarkerAnnotation)ann);
        }
        int i = 0;
        while (i < markerAnnotations.size()) {
            block7: {
                IMarker marker;
                block6: {
                    marker = ((MarkerAnnotation)markerAnnotations.get(i)).getMarker();
                    try {
                        String markerType = marker.getType();
                        if (!markerType.endsWith(problemMarkerType)) {
                        }
                        break block6;
                    }
                    catch (CoreException coreException) {
                        model.removeAnnotation((Annotation)markerAnnotations.get(i));
                    }
                    break block7;
                }
                if (this.markerParseAnnotations.get(marker) == null) {
                    model.removeAnnotation((Annotation)markerAnnotations.get(i));
                }
            }
            ++i;
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            super.doSetInput(input);
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        this.setInsertMode(SMART_INSERT);
        IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)input);
        if (annotationModel != null) {
            annotationModel.addAnnotationModelListener((IAnnotationModelListener)new InputAnnotationModelListener());
        }
    }

    public void addModelListener(IModelListener listener) {
        this.fParserScheduler.addModelListener(listener);
    }

    public String getSelectionText() {
        Point sel = this.getSelection();
        IFileEditorInput fileEditorInput = (IFileEditorInput)this.getEditorInput();
        IDocument document = this.getDocumentProvider().getDocument((Object)fileEditorInput);
        try {
            return document.get(sel.x, sel.y);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public Point getSelection() {
        ISelection sel = this.getSelectionProvider().getSelection();
        ITextSelection textSel = (ITextSelection)sel;
        return new Point(textSel.getOffset(), textSel.getLength());
    }

    public boolean canPerformFind() {
        return true;
    }

    public IParseController getParseController() {
        return this.fLanguageServiceManager.getParseController();
    }

    public IOccurrenceMarker getOccurrenceMarker() {
        return this.fLanguageServiceManager.getOccurrenceMarker();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
    }

    public void removeParserAnnotations() {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.getType().equals(PARSE_ANNOTATION_TYPE)) continue;
            model.removeAnnotation(a);
        }
    }

    public String toString() {
        String langName = this.fLanguage != null ? " for " + this.fLanguage.getName() : "";
        String inputDesc = this.fParserScheduler != null && this.fLanguageServiceManager.getParseController() != null && this.fLanguageServiceManager.getParseController().getPath() != null ? "source " + this.fLanguageServiceManager.getParseController().getPath().toPortableString() : "";
        return "Universal Editor" + langName + " on " + inputDesc + this.getEditorInput();
    }

    private class AnnotationCreatorListener
    implements IModelListener {
        private AnnotationCreatorListener() {
        }

        public IModelListener.AnalysisRequired getAnalysisRequired() {
            return IModelListener.AnalysisRequired.NONE;
        }

        public void update(IParseController parseController, IProgressMonitor monitor) {
            IAnnotationTypeInfo annotationTypeInfo = UniversalEditor.this.fLanguageServiceManager.getParseController().getAnnotationTypeInfo();
            if (annotationTypeInfo != null) {
                List problemMarkerTypes = annotationTypeInfo.getProblemMarkerTypes();
                int i = 0;
                while (i < problemMarkerTypes.size()) {
                    UniversalEditor.this.refreshMarkerAnnotations((String)problemMarkerTypes.get(i));
                    ++i;
                }
            }
        }
    }

    private class BracketInserter
    implements VerifyKeyListener {
        private final Map<String, String> fFencePairs = new HashMap<String, String>();
        private final String fOpenFences;
        private final Map<Character, Boolean> fCloseFenceMap = new HashMap<Character, Boolean>();

        public BracketInserter() {
            String[][] pairs = UniversalEditor.this.fLanguageServiceManager.getParseController().getSyntaxProperties().getFences();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < pairs.length) {
                sb.append(pairs[i][0]);
                this.fFencePairs.put(pairs[i][0], pairs[i][1]);
                ++i;
            }
            this.fOpenFences = sb.toString();
        }

        public void setCloseFenceEnabled(char openingFence, boolean enabled) {
            this.fCloseFenceMap.put(Character.valueOf(openingFence), enabled);
        }

        public void setCloseFencesEnabled(boolean enabled) {
            int i = 0;
            while (i < this.fOpenFences.length()) {
                this.fCloseFenceMap.put(Character.valueOf(this.fOpenFences.charAt(i)), enabled);
                ++i;
            }
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || UniversalEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            if (this.fOpenFences.indexOf(event.character) < 0) {
                return;
            }
            ISourceViewer sourceViewer = UniversalEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
                if (!"__dftl_partition_content_type".equals(partition.getType())) {
                    return;
                }
                if (!UniversalEditor.this.validateEditorInputState()) {
                    return;
                }
                String inputStr = new String(new char[]{event.character});
                String closingFence = this.fFencePairs.get(inputStr);
                StringBuffer buffer = new StringBuffer();
                buffer.append(inputStr);
                buffer.append(closingFence);
                document.replace(offset, length, buffer.toString());
                sourceViewer.setSelectedRange(offset + inputStr.length(), 0);
                event.doit = false;
            }
            catch (BadLocationException e) {
                RuntimePlugin.getInstance().logException(e.getMessage(), e);
            }
        }
    }

    protected class InputAnnotationModelListener
    implements IAnnotationModelListener {
        protected InputAnnotationModelListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            IMarker marker;
            ArrayList<Annotation> currentParseAnnotations = new ArrayList<Annotation>();
            ArrayList<IMarker> currentMarkers = new ArrayList<IMarker>();
            UniversalEditor.this.markerParseAnnotations = new HashMap();
            UniversalEditor.this.markerMarkerAnnotations = new HashMap();
            Iterator annotations = model.getAnnotationIterator();
            while (annotations.hasNext()) {
                Annotation annotation;
                Object ann = annotations.next();
                if (ann instanceof MarkerAnnotation) {
                    marker = ((MarkerAnnotation)ann).getMarker();
                    if (marker.exists()) {
                        currentMarkers.add(marker);
                    }
                    UniversalEditor.this.markerMarkerAnnotations.put(marker, (MarkerAnnotation)ann);
                    continue;
                }
                if (!(ann instanceof Annotation) || !(annotation = (Annotation)ann).getType().equals(UniversalEditor.PARSE_ANNOTATION_TYPE)) continue;
                currentParseAnnotations.add(annotation);
            }
            int i = 0;
            while (i < currentMarkers.size()) {
                marker = (IMarker)currentMarkers.get(i);
                Annotation annotation = this.findParseAnnotationForMarker(model, marker, currentParseAnnotations);
                if (annotation != null) {
                    UniversalEditor.this.markerParseAnnotations.put(marker, annotation);
                }
                ++i;
            }
        }

        public Annotation findParseAnnotationForMarker(IAnnotationModel model, IMarker marker, List parseAnnotations) {
            Integer markerStartAttr = null;
            Integer markerEndAttr = null;
            try {
                markerStartAttr = (Integer)marker.getAttribute("charStart");
                markerEndAttr = (Integer)marker.getAttribute("charEnd");
                if (markerStartAttr == null || markerEndAttr == null) {
                    return null;
                }
            }
            catch (CoreException e) {
                RuntimePlugin.getInstance().logException("UniversalEditor.findParseAnnotationForMarker:  CoreException getting marker start and end attributes", e);
                return null;
            }
            catch (NullPointerException e) {
                RuntimePlugin.getInstance().logException("UniversalEditor.findParseAnnotationForMarker:  NullPointerException getting marker start and end attributes", e);
                return null;
            }
            int markerStart = markerStartAttr;
            int markerEnd = markerEndAttr;
            int markerLength = markerEnd - markerStart;
            int j = 0;
            while (j < parseAnnotations.size()) {
                Annotation parseAnnotation = (Annotation)parseAnnotations.get(j);
                Position pos = model.getPosition(parseAnnotation);
                if (pos != null) {
                    int annotationStart = pos.offset;
                    int annotationLength = pos.length;
                    if (markerStart == annotationStart && markerLength == annotationLength) {
                        return parseAnnotation;
                    }
                }
                ++j;
            }
            return null;
        }
    }

    private class PresentationDamager
    implements IPresentationDamager {
        private PresentationDamager() {
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
            return partition;
        }

        public void setDocument(IDocument document) {
        }
    }

    private class PresentationRepairer
    implements IPresentationRepairer {
        ITypedRegion previousDamage = null;
        private final IProgressMonitor fProgressMonitor = new NullProgressMonitor();

        private PresentationRepairer() {
        }

        public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
            boolean hyperlinkRestore = false;
            if (this.previousDamage != null && damage.getOffset() == this.previousDamage.getOffset() && damage.getLength() == this.previousDamage.getLength()) {
                hyperlinkRestore = true;
            }
            this.previousDamage = damage;
            try {
                if (UniversalEditor.this.fServiceControllerManager.getPresentationController() != null) {
                    UniversalEditor.this.fServiceControllerManager.getPresentationController().damage((IRegion)damage);
                    if (hyperlinkRestore) {
                        UniversalEditor.this.fServiceControllerManager.getPresentationController().update(UniversalEditor.this.fLanguageServiceManager.getParseController(), this.fProgressMonitor);
                    }
                }
            }
            catch (Exception e) {
                ErrorHandler.reportError("Could not repair damage ", e);
            }
        }

        public void setDocument(IDocument document) {
        }
    }

    class StructuredSourceViewerConfiguration
    extends TextSourceViewerConfiguration {
        private InformationPresenter fInfoPresenter;
        private IInformationProvider fOutlineElementProvider = new OutlineInformationProvider();

        StructuredSourceViewerConfiguration() {
        }

        public int getTabWidth(ISourceViewer sourceViewer) {
            return PreferenceCache.tabWidth;
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            PresentationReconciler reconciler = new PresentationReconciler();
            reconciler.setRepairer((IPresentationRepairer)new PresentationRepairer(), "__dftl_partition_content_type");
            reconciler.setDamager((IPresentationDamager)new PresentationDamager(), "__dftl_partition_content_type");
            return reconciler;
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            ContentAssistant ca = new ContentAssistant();
            ca.setContentAssistProcessor((IContentAssistProcessor)UniversalEditor.this.fServiceControllerManager.getCompletionProcessor(), "__dftl_partition_content_type");
            ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return ca;
        }

        public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
            IAnnotationHover hover = UniversalEditor.this.fLanguageServiceManager.getAnnotationHover();
            if (hover == null) {
                hover = new DefaultAnnotationHover();
            }
            return hover;
        }

        public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
            IAutoEditStrategy autoEdit = UniversalEditor.this.fLanguageServiceManager.getAutoEditStrategy();
            if (autoEdit == null) {
                autoEdit = super.getAutoEditStrategies(sourceViewer, contentType)[0];
            }
            return new IAutoEditStrategy[]{autoEdit};
        }

        public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager.getFormattingController() == null) {
                return null;
            }
            ContentFormatter formatter = new ContentFormatter();
            formatter.setFormattingStrategy((IFormattingStrategy)UniversalEditor.this.fServiceControllerManager.getFormattingController(), "__dftl_partition_content_type");
            return formatter;
        }

        public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
            return super.getDefaultPrefixes(sourceViewer, contentType);
        }

        public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
            return super.getDoubleClickStrategy(sourceViewer, contentType);
        }

        public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
            if (UniversalEditor.this.fServiceControllerManager.getHyperLinkController() != null) {
                return new IHyperlinkDetector[]{UniversalEditor.this.fServiceControllerManager.getHyperLinkController()};
            }
            return super.getHyperlinkDetectors(sourceViewer);
        }

        public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
            return super.getHyperlinkPresenter(sourceViewer);
        }

        public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
            return super.getIndentPrefixes(sourceViewer, contentType);
        }

        public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    int style = 0;
                    return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), "Press 'F2' for focus");
                }
            };
        }

        public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
            if (this.fInfoPresenter == null) {
                this.fInfoPresenter = new InformationPresenter(this.getInformationControlCreator(sourceViewer));
                this.fInfoPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
                this.fInfoPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
                IInformationProvider provider = new IInformationProvider(){
                    private IDocumentationProvider fDocProvider;
                    private IParseController fParseController;
                    private ISourcePositionLocator fNodeLocator;
                    {
                        this.fDocProvider = ((StructuredSourceViewerConfiguration)StructuredSourceViewerConfiguration.this).UniversalEditor.this.fLanguageServiceManager.getDocProvider();
                        this.fParseController = ((StructuredSourceViewerConfiguration)StructuredSourceViewerConfiguration.this).UniversalEditor.this.fLanguageServiceManager.getParseController();
                        this.fNodeLocator = this.fParseController.getNodeLocator();
                    }

                    public IRegion getSubject(ITextViewer textViewer, int offset) {
                        Object selNode = this.fNodeLocator.findNode(this.fParseController.getCurrentAst(), offset);
                        return new Region(this.fNodeLocator.getStartOffset(selNode), this.fNodeLocator.getLength(selNode));
                    }

                    public String getInformation(ITextViewer textViewer, IRegion subject) {
                        Object selNode = this.fNodeLocator.findNode(this.fParseController.getCurrentAst(), subject.getOffset());
                        return this.fDocProvider != null ? this.fDocProvider.getDocumentation(selNode, this.fParseController) : "No documentation available on the selected entity.";
                    }
                };
                this.fInfoPresenter.setInformationProvider(provider, "__dftl_partition_content_type");
                this.fInfoPresenter.setSizeConstraints(60, 10, true, false);
                this.fInfoPresenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
            }
            return this.fInfoPresenter;
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
            return UniversalEditor.this.fServiceControllerManager.getHoverHelpController();
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
            return super.getTextHover(sourceViewer, contentType, stateMask);
        }

        public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
            return super.getUndoManager(sourceViewer);
        }

        public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
            return super.getOverviewRulerAnnotationHover(sourceViewer);
        }

        public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
            TreeModelBuilderBase modelBuilder = UniversalEditor.this.fLanguageServiceManager.getModelBuilder();
            if (modelBuilder == null) {
                return null;
            }
            InformationPresenter presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.eclipse.jdt.ui.edit.text.java.show.outline"));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            IInformationProvider provider = this.fOutlineElementProvider;
            presenter.setInformationProvider(provider, "__dftl_partition_content_type");
            presenter.setSizeConstraints(50, 20, true, false);
            presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
            return presenter;
        }

        private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    int shellStyle = 16;
                    int treeStyle = 768;
                    return new OutlineInformationControl(parent, shellStyle, treeStyle, commandId, ((StructuredSourceViewerConfiguration)StructuredSourceViewerConfiguration.this).UniversalEditor.this.fLanguage);
                }
            };
        }

        public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
            InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator(sourceViewer));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            IInformationProvider provider = null;
            presenter.setInformationProvider(provider, "__dftl_partition_content_type");
            presenter.setSizeConstraints(50, 20, true, false);
            presenter.setRestoreInformationControlBounds(this.getSettings("hierarchy_presenter_bounds"), true, true);
            return presenter;
        }

        private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            };
        }

        private IDialogSettings getSettings(String sectionName) {
            IDialogSettings settings = RuntimePlugin.getInstance().getDialogSettings().getSection(sectionName);
            if (settings == null) {
                settings = RuntimePlugin.getInstance().getDialogSettings().addNewSection(sectionName);
            }
            return settings;
        }

        private class OutlineInformationProvider
        implements IInformationProvider,
        IInformationProviderExtension {
            private TreeModelBuilderBase fBuilder;

            private OutlineInformationProvider() {
            }

            public IRegion getSubject(ITextViewer textViewer, int offset) {
                return new Region(offset, 0);
            }

            public String getInformation(ITextViewer textViewer, IRegion subject) {
                return "never called?!?";
            }

            public Object getInformation2(ITextViewer textViewer, IRegion subject) {
                if (this.fBuilder == null) {
                    this.fBuilder = ((StructuredSourceViewerConfiguration)StructuredSourceViewerConfiguration.this).UniversalEditor.this.fLanguageServiceManager.getModelBuilder();
                }
                return this.fBuilder.buildTree(((StructuredSourceViewerConfiguration)StructuredSourceViewerConfiguration.this).UniversalEditor.this.fLanguageServiceManager.getParseController().getCurrentAst());
            }
        }
    }
}

