/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.actions.GotoMatchingBracketAction;
import org.eclipse.m2m.atl.adt.ui.actions.IndentAction;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditorMessages;
import org.eclipse.m2m.atl.adt.ui.outline.AtlContentOutlinePage;
import org.eclipse.m2m.atl.adt.ui.outline.AtlEMFConstants;
import org.eclipse.m2m.atl.adt.ui.properties.AtlPropertySourceProvider;
import org.eclipse.m2m.atl.adt.ui.text.AtlContentAssistPreference;
import org.eclipse.m2m.atl.adt.ui.text.AtlPairMatcher;
import org.eclipse.m2m.atl.adt.ui.text.AtlSourceViewerConfiguration;
import org.eclipse.m2m.atl.adt.ui.text.IAtlLexems;
import org.eclipse.m2m.atl.adt.ui.viewsupport.AtlEditorTickErrorUpdater;
import org.eclipse.m2m.atl.engine.AtlNbCharFile;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class AtlEditor
extends TextEditor {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    protected AtlPairMatcher bracketMatcher = new AtlPairMatcher(IAtlLexems.BRACKETS);
    private EditorSelectionChangedListener editorSelectionChangedListener;
    private BracketInserter fBracketInserter = new BracketInserter();
    private TabConverter fTabConverter;
    private AtlNbCharFile help;
    private AtlContentOutlinePage outlinePage;
    private PropertySheetPage propertySheetPage;
    private SelectionChangedListener selectionChangedListener;
    private AtlEditorTickErrorUpdater tickErrorUpdater = new AtlEditorTickErrorUpdater(this);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': 
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != IAtlLexems.BRACKETS.length) {
            if (character == IAtlLexems.BRACKETS[i].toCharArray()[0]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return AtlEditor.isBracket(document.getChar(offset - 1)) && AtlEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AtlSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("Atl.AppearanceHighlightMatchingBrackets", "Atl.AppearanceHighlightMatchingBrackets.Color");
        super.configureSourceViewerDecorationSupport(support);
    }

    private void configureTabConverter() {
        if (this.fTabConverter != null) {
            IDocumentProvider provider = this.getDocumentProvider();
            boolean cfr_ignored_0 = provider instanceof IDocumentProvider;
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = AtlEditorMessages.getResourceBundle();
        Object action = new GotoMatchingBracketAction(this);
        this.setAction("org.eclipse.m2m.atl.adt.ui.actions.GotoMatchingBracket", (IAction)action);
        action = new IndentAction(resourceBundle, "Indent.", (ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.m2m.atl.adt.ui.actions.Indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        action = new IndentAction(AtlEditorMessages.getResourceBundle(), "Indent.", (ITextEditor)this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        if (this.getPreferenceStore().getBoolean("Atl.Typing.SmartTab")) {
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
    }

    protected AtlContentOutlinePage createOutlinePage() {
        AtlContentOutlinePage page = new AtlContentOutlinePage((ITextEditor)this, this.getEditorInput(), this.getDocumentProvider());
        this.selectionChangedListener = new SelectionChangedListener();
        page.addPostSelectionChangedListener(this.selectionChangedListener);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.editorSelectionChangedListener = new EditorSelectionChangedListener();
        IPostSelectionProvider editorSelectionProvider = (IPostSelectionProvider)this.getSelectionProvider();
        editorSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this.editorSelectionChangedListener);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        this.fBracketInserter.setCloseBracketsEnabled(preferenceStore.getBoolean("Atl.Typing.ClolseBrackets"));
        this.fBracketInserter.setCloseStringsEnabled(preferenceStore.getBoolean("Atl.Typing.CloseStrings"));
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    protected PropertySheetPage createPropertySheetPage() {
        PropertySheetPage page = new PropertySheetPage();
        AtlPropertySourceProvider apsp = new AtlPropertySourceProvider();
        page.setPropertySourceProvider((IPropertySourceProvider)apsp);
        return page;
    }

    public void dispose() {
        super.dispose();
        this.tickErrorUpdater.dispose();
        if (this.bracketMatcher != null) {
            this.bracketMatcher.dispose();
            this.bracketMatcher = null;
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (this.outlinePage != null) {
            this.outlinePage.setUnit();
        }
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        if (this.isAtlOutlinePageActive()) {
            this.setSelection(event);
        }
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
            }
            return this.outlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = this.createPropertySheetPage();
            }
            return this.propertySheetPage;
        }
        return super.getAdapter(required);
    }

    public String getDocumentProviderContent() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getEditorInputContent() {
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        IFile ifi = editorInput.getFile();
        StringBuffer content = new StringBuffer();
        InputStream is = null;
        try {
            try {
                int c;
                is = ifi.getContents();
                while ((c = is.read()) != -1) {
                    content.append((char)c);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e1) {
                logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
            }
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
            return content.toString();
        }
        is.close();
        return content.toString();
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = AtlEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    public IResource getUnderlyingResource() {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        if (input == null) {
            return null;
        }
        return input.getFile();
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(AtlEditorMessages.getString("GotoMatchingBracket.error.invalidSelection"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (AtlEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.bracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(AtlEditorMessages.getString("GotoMatchingBracket.error.noMatchingBracket"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.bracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(AtlEditorMessages.getString("GotoMatchingBracket.error.bracketOutsideSelectedElement"));
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            block12: {
                IContentAssistant c;
                AtlSourceViewerConfiguration sourceViewerConfiguration;
                String property;
                ISourceViewer sourceViewer;
                block16: {
                    block14: {
                        block15: {
                            block13: {
                                sourceViewer = this.getSourceViewer();
                                if (sourceViewer == null) break block12;
                                property = event.getProperty();
                                sourceViewerConfiguration = (AtlSourceViewerConfiguration)this.getSourceViewerConfiguration();
                                sourceViewerConfiguration.handlePropertyChangeEvent(event);
                                if (!"Atl.Typing.ClolseBrackets".equals(property)) break block13;
                                this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(property));
                                break block14;
                            }
                            if (!"Atl.Typing.CloseStrings".equals(property)) break block15;
                            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(property));
                            break block14;
                        }
                        if (!"Atl.Typing.SpacesForTabs".equals(property)) break block16;
                        if (this.isTabConversionEnabled()) {
                            this.startTabConversion();
                        } else {
                            this.stopTabConversion();
                        }
                    }
                    Object var6_5 = null;
                    super.handlePreferenceStoreChanged(event);
                    return;
                }
                if ("Atl.Typing.SmartTab".equals(property)) {
                    if (this.getPreferenceStore().getBoolean("Atl.Typing.SmartTab")) {
                        this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
                    } else {
                        this.removeActionActivationCode("IndentOnTab");
                    }
                }
                if ((c = sourceViewerConfiguration.getContentAssistant(sourceViewer)) instanceof ContentAssistant) {
                    AtlContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            super.handlePreferenceStoreChanged(event);
            throw throwable;
        }
        super.handlePreferenceStoreChanged(event);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.tickErrorUpdater.updateEditorImage(this.getUnderlyingResource());
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(new AtlSourceViewerConfiguration(AtlUIPlugin.getDefault().getTextTools(), (ITextEditor)this));
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals((Object)this);
    }

    private boolean isAtlOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.outlinePage;
    }

    private boolean isTabConversionEnabled() {
        return this.getPreferenceStore().getBoolean("Atl.Typing.SpacesForTabs");
    }

    public void setHelp(AtlNbCharFile help) {
        this.help = help;
    }

    protected void setNewPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.getSourceViewerConfiguration() instanceof AtlSourceViewerConfiguration) {
            ((AtlSourceViewerConfiguration)this.getSourceViewerConfiguration()).setNewPreferenceStore(store);
        }
    }

    private void setSelection(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else {
            EObject element = (EObject)selection.getFirstElement();
            String location = (String)element.eGet(AtlEMFConstants.sfLocation);
            if (location == null) {
                return;
            }
            int[] sl = this.help.getIndexChar(location);
            int start = sl[0];
            int length = sl[1] - sl[0];
            try {
                this.setHighlightRange(start, length, false);
                this.selectAndReveal(start, length);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.resetHighlightRange();
            }
        }
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    protected void setStatusLineMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(false, msg, null);
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.configureTabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("tabWidth"));
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            this.fTabConverter = null;
        }
    }

    public void synchronizeOutlinePageSelection() {
        if (this.isActivePart() && this.outlinePage != null) {
            this.outlinePage.removePostSelectionChangedListener(this.selectionChangedListener);
            this.outlinePage.setSelection(this.getCursorPosition());
            this.outlinePage.addPostSelectionChangedListener(this.selectionChangedListener);
        }
    }

    public void updateTitleImage(Image image) {
        this.setTitleImage(image);
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private final String CATEGORY = this.toString();
        private Stack fBracketLevelStack = new Stack();
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);

        private BracketInserter() {
        }

        private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && document.getChar(end) == character;
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
            try {
                int start = offset;
                IRegion startLine = document.getLineInformationOfOffset(start);
                int minStart = startLine.getOffset();
                while (start != minStart && Character.isWhitespace(document.getChar(start - 1))) {
                    --start;
                }
                return start != minStart && Character.isJavaIdentifierPart(document.getChar(start - 1));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        private boolean hasIdentifierToTheRight(IDocument document, int offset) {
            try {
                int end = offset;
                IRegion endLine = document.getLineInformationOfOffset(end);
                int maxEnd = endLine.getOffset() + endLine.getLength();
                while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                    ++end;
                }
                return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
            }
            catch (BadLocationException badLocationException) {
                return true;
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = AtlEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(this, level, document){
                    final /* synthetic */ BracketInserter this$1;
                    private final /* synthetic */ BracketLevel val$level;
                    private final /* synthetic */ IDocument val$document;
                    {
                        this.this$1 = bracketInserter;
                        this.val$level = bracketLevel;
                        this.val$document = iDocument;
                    }

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((this.val$level.fFirstPosition.isDeleted || this.val$level.fFirstPosition.length == 0) && !this.val$level.fSecondPosition.isDeleted && this.val$level.fSecondPosition.offset == this.val$level.fFirstPosition.offset) {
                            try {
                                this.val$document.replace(this.val$level.fSecondPosition.offset, this.val$level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        if (BracketInserter.access$1(this.this$1).size() == 0) {
                            this.val$document.removePositionUpdater(BracketInserter.access$2(this.this$1));
                            try {
                                this.val$document.removePositionCategory(BracketInserter.access$3(this.this$1));
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                    }
                });
            }
        }

        public void resume(LinkedModeModel environment, int flags) {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit) {
                return;
            }
            ISourceViewer sourceViewer = AtlEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            switch (event.character) {
                case '(': {
                    if (this.hasCharacterToTheRight(document, offset + length, '(')) {
                        return;
                    }
                }
                case '[': {
                    if (!this.fCloseBrackets) {
                        return;
                    }
                    if (this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                case '\'': {
                    if (event.character == '\'') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                }
                case '\"': {
                    if (event.character == '\"') {
                        if (!this.fCloseStrings) {
                            return;
                        }
                        if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                            return;
                        }
                    }
                    try {
                        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"partitioning", (int)offset, (boolean)true);
                        if (!"__dftl_partition_content_type".equals(partition.getType())) {
                            return;
                        }
                        if (!AtlEditor.this.validateEditorInputState()) {
                            return;
                        }
                        char character = event.character;
                        char closingCharacter = AtlEditor.getPeerCharacter(character);
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(character);
                        buffer.append(closingCharacter);
                        document.replace(offset, length, buffer.toString());
                        BracketLevel level = new BracketLevel();
                        this.fBracketLevelStack.push(level);
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                        LinkedModeModel model = new LinkedModeModel();
                        model.addLinkingListener((ILinkedModeListener)this);
                        model.addGroup(group);
                        model.forceInstall();
                        level.fOffset = offset;
                        level.fLength = 2;
                        if (this.fBracketLevelStack.size() == 1) {
                            document.addPositionCategory(this.CATEGORY);
                            document.addPositionUpdater(this.fUpdater);
                        }
                        level.fFirstPosition = new Position(offset, 1);
                        level.fSecondPosition = new Position(offset + 1, 1);
                        document.addPosition(this.CATEGORY, level.fFirstPosition);
                        document.addPosition(this.CATEGORY, level.fSecondPosition);
                        level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                        level.fUI.setSimpleMode(true);
                        level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, AtlEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                        level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                        level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                        level.fUI.enter();
                        IRegion newSelection = level.fUI.getSelectedRegion();
                        sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                        event.doit = false;
                        break;
                    }
                    catch (BadLocationException e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        break;
                    }
                    catch (BadPositionCategoryException e) {
                        logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }

        static /* synthetic */ Stack access$1(BracketInserter bracketInserter) {
            return bracketInserter.fBracketLevelStack;
        }

        static /* synthetic */ IPositionUpdater access$2(BracketInserter bracketInserter) {
            return bracketInserter.fUpdater;
        }

        static /* synthetic */ String access$3(BracketInserter bracketInserter) {
            return bracketInserter.CATEGORY;
        }
    }

    private static class BracketLevel {
        Position fFirstPosition;
        int fLength;
        int fOffset;
        Position fSecondPosition;
        LinkedModeUI fUI;

        private BracketLevel() {
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AtlEditor.this.synchronizeOutlinePageSelection();
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public String getCategory() {
            return this.fCategory;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fEscapeCharacter;
        final char fExitCharacter;
        final int fSize;
        final Stack fStack;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                BracketLevel level = (BracketLevel)this.fStack.peek();
                if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                    return null;
                }
                if (level.fSecondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = AtlEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AtlEditor.this.doSelectionChanged(event);
        }
    }

    static class TabConverter
    implements ITextConverter {
        private ILineTracker fLineTracker;
        private int fTabRatio;

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }
    }
}

