/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.AtlSuperimposeModule;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInterpreter;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.ASMXMLReader;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.NetworkDebugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModule;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;

public class AtlLauncher {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static AtlLauncher defaultLauncher = null;

    public static AtlLauncher getDefault() {
        if (defaultLauncher == null) {
            defaultLauncher = new AtlLauncher();
        }
        return defaultLauncher;
    }

    private AtlLauncher() {
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose) {
        return this.launch(asmurl, libraries, models, asmParams, superimpose, Collections.EMPTY_MAP);
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose, Map options) {
        return this.launch(asmurl, libraries, models, asmParams, superimpose, options, (Debugger)new SimpleDebugger("true".equals(options.get("step")), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true, "true".equals(options.get("showSummary")), "true".equals(options.get("profile")), "true".equals(options.get("continueAfterError"))));
    }

    public Object debug(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose, Map options) {
        return this.launch(asmurl, libraries, models, asmParams, superimpose, options, (Debugger)new NetworkDebugger(6060, true));
    }

    public Object launch(URL asmurl, Map libraries, Map models, Map asmParams, List superimpose, Map options, Debugger debugger) {
        try {
            ASM asm = new ASMXMLReader().read((InputStream)new BufferedInputStream(asmurl.openStream()));
            return this.launch(asm, libraries, models, asmParams, superimpose, options, debugger);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public Object launch(ASM asm, Map libraries, Map models, Map asmParams, List superimpose, Map options, Debugger debugger) {
        ASMOclAny ret = null;
        try {
            ASMModule asmModule = new ASMModule(asm);
            ASMExecEnv env = new ASMExecEnv(asmModule, debugger, !"true".equals(options.get("disableAttributeHelperCache")));
            env.addPermission("file.read");
            env.addPermission("file.write");
            for (String mname : models.keySet()) {
                env.addModel(mname, (ASMModel)models.get(mname));
            }
            for (String lname : libraries.keySet()) {
                ASM lib;
                Object libASMOrURL = libraries.get(lname);
                if (libASMOrURL instanceof URL) {
                    URL url = (URL)libASMOrURL;
                    lib = new ASMXMLReader().read((InputStream)new BufferedInputStream(url.openStream()));
                } else {
                    lib = (ASM)libASMOrURL;
                }
                env.registerOperations(lib);
                ASMOperation op = lib.getOperation("main");
                if (op == null) continue;
                op.exec((StackFrame)ASMStackFrame.rootFrame((ASMExecEnv)env, (ASMOperation)op, Arrays.asList(asmModule)));
            }
            env.registerOperations(asm);
            for (URL url : superimpose) {
                ASM module = new ASMXMLReader().read((InputStream)new BufferedInputStream(url.openStream()));
                AtlSuperimposeModule ami = new AtlSuperimposeModule(env, module);
                ami.adaptModuleOperations();
                env.registerOperations(module);
            }
            boolean printExecutionTime = "true".equals(options.get("printExecutionTime"));
            long startTime = System.currentTimeMillis();
            ASMInterpreter ai = new ASMInterpreter(asm, asmModule, env, asmParams);
            long endTime = System.currentTimeMillis();
            if (printExecutionTime && !(debugger instanceof NetworkDebugger)) {
                logger.info(String.valueOf(asm.getName()) + " executed in " + (double)(endTime - startTime) / 1000.0 + "s.");
            }
            ret = ai.getReturnValue();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return ret;
    }
}

