/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.Bag;
import org.eclipse.m2m.atl.engine.emfvm.lib.EMFUtils;
import org.eclipse.m2m.atl.engine.emfvm.lib.EnumLiteral;
import org.eclipse.m2m.atl.engine.emfvm.lib.HasFields;
import org.eclipse.m2m.atl.engine.emfvm.lib.Model;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclParametrizedType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclSimpleType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.ReferenceModel;
import org.eclipse.m2m.atl.engine.emfvm.lib.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLink;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLinkSet;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;
import org.eclipse.m2m.atl.engine.emfvm.lib.VMException;

public class ExecEnv {
    private Map operationsByType = new HashMap();
    private boolean cacheAttributeHelperResults = true;
    private Map helperValuesByElement = new HashMap();
    private Map attributeInitializers = new HashMap();
    private Map modelsByName;
    private Map nameByModel;
    private Map modelsByResource;
    public boolean step = false;
    public boolean supportUML2Stereotypes = false;
    public PrintStream out = System.out;
    public long nbExecutedBytecodes = 0L;
    private Map supertypes = new HashMap();
    private Map vmTypeOperations;
    private ArrayList emptySequence;
    private Operation noInitializer;

    public ExecEnv(Map models) {
        this.supertypes.put(Integer.class, Arrays.asList(Double.class));
        this.supertypes.put(Boolean.class, Arrays.asList(Object.class));
        this.supertypes.put(String.class, Arrays.asList(Object.class));
        this.supertypes.put(Bag.class, Arrays.asList(Collection.class));
        this.supertypes.put(ArrayList.class, Arrays.asList(Collection.class));
        this.supertypes.put(LinkedHashSet.class, Arrays.asList(Collection.class));
        this.supertypes.put(HashSet.class, Arrays.asList(Collection.class));
        this.supertypes.put(Collection.class, Arrays.asList(Object.class));
        this.supertypes.put(Double.class, Arrays.asList(Object.class));
        this.supertypes.put(OclParametrizedType.class, Arrays.asList(OclType.class));
        this.supertypes.put(OclSimpleType.class, Arrays.asList(OclType.class));
        this.supertypes.put(EClassImpl.class, Arrays.asList(EObjectImpl.class));
        this.supertypes.put(OclUndefined.class, Arrays.asList(Object.class));
        this.supertypes.put(TransientLink.class, Arrays.asList(Object.class));
        this.supertypes.put(HashMap.class, Arrays.asList(Object.class));
        this.supertypes.put(ASMModule.class, Arrays.asList(Object.class));
        this.supertypes.put(Tuple.class, Arrays.asList(Object.class));
        this.supertypes.put(EnumLiteral.class, Arrays.asList(Object.class));
        this.vmTypeOperations = new HashMap();
        HashMap<String, Operation> operationsByName = new HashMap<String, Operation>();
        this.vmTypeOperations.put(Double.class, operationsByName);
        operationsByName.put("/", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() / ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("*", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() * ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("-", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() - ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("+", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() + ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("<", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Number)localVars[0]).doubleValue() < ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("<=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Number)localVars[0]).doubleValue() <= ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put(">", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Number)localVars[0]).doubleValue() > ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put(">=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Number)localVars[0]).doubleValue() >= ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Number)localVars[0]).doubleValue() == ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("toString", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].toString();
            }
        });
        operationsByName.put("abs", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.abs(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("round", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer((int)Math.round(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("floor", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer((int)Math.floor(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("max", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.max(((Number)localVars[0]).doubleValue(), ((Number)localVars[1]).doubleValue()));
            }
        });
        operationsByName.put("min", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.min(((Number)localVars[0]).doubleValue(), ((Number)localVars[1]).doubleValue()));
            }
        });
        operationsByName.put("acos", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.acos(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("asin", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.asin(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("atan", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.atan(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("cos", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.cos(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("sin", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.sin(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("tan", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.tan(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("toDegrees", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.toDegrees(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("toRadians", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.toRadians(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("exp", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.exp(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("log", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.log(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName.put("sqrt", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.sqrt(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Integer.class, operationsByName);
        operationsByName.put("*", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Integer((Integer)localVars[0] * (Integer)localVars[1]);
                }
                return new Double(((Number)localVars[0]).doubleValue() * ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("-", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Integer((Integer)localVars[0] - (Integer)localVars[1]);
                }
                return new Double(((Number)localVars[0]).doubleValue() - ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("+", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Integer((Integer)localVars[0] + (Integer)localVars[1]);
                }
                return new Double(((Number)localVars[0]).doubleValue() + ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("div", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer((Integer)localVars[0] / (Integer)localVars[1]);
            }
        });
        operationsByName.put("mod", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer((Integer)localVars[0] % (Integer)localVars[1]);
            }
        });
        operationsByName.put("/", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double((double)((Integer)localVars[0]).intValue() / ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("<", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Boolean((Integer)localVars[0] < (Integer)localVars[1]);
                }
                return new Boolean(((Number)localVars[0]).doubleValue() < ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("<=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Boolean((Integer)localVars[0] <= (Integer)localVars[1]);
                }
                return new Boolean(((Number)localVars[0]).doubleValue() <= ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put(">", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Boolean((Integer)localVars[0] > (Integer)localVars[1]);
                }
                return new Boolean(((Number)localVars[0]).doubleValue() > ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put(">=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Boolean((Integer)localVars[0] >= (Integer)localVars[1]);
                }
                return new Boolean(((Number)localVars[0]).doubleValue() >= ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return new Boolean(((Integer)localVars[0]).intValue() == ((Integer)localVars[1]).intValue());
                }
                return new Boolean(((Number)localVars[0]).doubleValue() == ((Number)localVars[1]).doubleValue());
            }
        });
        operationsByName.put("toString", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].toString();
            }
        });
        operationsByName.put("toHexString", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.toHexString((Integer)localVars[0]);
            }
        });
        operationsByName.put("toBinaryString", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.toBinaryString((Integer)localVars[0]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Boolean.class, operationsByName);
        operationsByName.put("not", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean((Boolean)localVars[0] == false);
            }
        });
        operationsByName.put("and", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean((Boolean)localVars[0] != false && (Boolean)localVars[1] != false);
            }
        });
        operationsByName.put("or", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean((Boolean)localVars[0] != false || (Boolean)localVars[1] != false);
            }
        });
        operationsByName.put("xor", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean((Boolean)localVars[0] ^ (Boolean)localVars[1]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(ArrayList.class, operationsByName);
        operationsByName.put("insertAt", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int index = (Integer)localVars[1];
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(index - 1, localVars[2]);
                return ret;
            }
        });
        operationsByName.put("at", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int index = (Integer)localVars[1];
                return ((List)localVars[0]).get(index - 1);
            }
        });
        operationsByName.put("subSequence", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int start = (Integer)localVars[1];
                int end = (Integer)localVars[2];
                if (end >= start) {
                    return new ArrayList(((List)localVars[0]).subList(start - 1, end));
                }
                return ExecEnv.this.emptySequence;
            }
        });
        operationsByName.put("indexOf", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer(((List)localVars[0]).indexOf(localVars[1]) + 1);
            }
        });
        operationsByName.put("prepend", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(0, localVars[1]);
                return ret;
            }
        });
        operationsByName.put("including", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("excluding", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                ret.removeAll((Collection)Arrays.asList(localVars[1]));
                return ret;
            }
        });
        operationsByName.put("append", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("union", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName.put("asSequence", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new ArrayList((Collection)localVars[0]);
            }
        });
        operationsByName.put("asBag", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag((Collection)localVars[0]);
            }
        });
        operationsByName.put("first", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                List l = (List)localVars[0];
                if (l.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                return l.get(0);
            }
        });
        operationsByName.put("last", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                List l = (List)localVars[0];
                if (l.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                return l.get(l.size() - 1);
            }
        });
        operationsByName.put("flatten", new Operation(1){

            public Object exec(StackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                ArrayList base = null;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new ArrayList();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Bag.class, operationsByName);
        operationsByName.put("including", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Bag ret = new Bag((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("excluding", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Bag ret = new Bag((Collection)localVars[0]);
                ret.removeAll(Arrays.asList(localVars[1]));
                return ret;
            }
        });
        operationsByName.put("asBag", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        operationsByName.put("flatten", new Operation(1){

            public Object exec(StackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                Bag base = null;
                Bag ret = new Bag((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new Bag();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(LinkedHashSet.class, operationsByName);
        operationsByName.put("insertAt", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int idx = (Integer)localVars[1] - 1;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int k = 0;
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    if (k++ == idx) {
                        ret.add(localVars[2]);
                    }
                    ret.add(i.next());
                }
                return ret;
            }
        });
        operationsByName.put("prepend", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int idx = 0;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int k = 0;
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    if (k++ == idx) {
                        ret.add(localVars[1]);
                    }
                    ret.add(i.next());
                }
                return ret;
            }
        });
        operationsByName.put("including", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("append", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("asOrderedSet", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        operationsByName.put("asBag", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag((Collection)localVars[0]);
            }
        });
        operationsByName.put("first", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((LinkedHashSet)localVars[0]).iterator().next();
            }
        });
        operationsByName.put("count", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object o = localVars[1];
                return ((HashSet)localVars[0]).contains(o) ? new Integer(1) : new Integer(0);
            }
        });
        operationsByName.put("union", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet ret = new LinkedHashSet((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName.put("flatten", new Operation(1){

            public Object exec(StackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                LinkedHashSet base = null;
                LinkedHashSet ret = new LinkedHashSet((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new LinkedHashSet();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(HashSet.class, operationsByName);
        operationsByName.put("including", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet<Object> ret = new HashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        operationsByName.put("intersection", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.retainAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName.put("-", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.removeAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName.put("symetricDifference", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                HashSet t = new HashSet((Collection)localVars[1]);
                t.removeAll(ret);
                ret.removeAll((Collection)localVars[1]);
                ret.addAll(t);
                return ret;
            }
        });
        operationsByName.put("asSet", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        operationsByName.put("asBag", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag((Collection)localVars[0]);
            }
        });
        operationsByName.put("flatten", new Operation(1){

            public Object exec(StackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                HashSet base = null;
                HashSet ret = new HashSet((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new HashSet();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName.put("count", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object o = localVars[1];
                return ((HashSet)localVars[0]).contains(o) ? new Integer(1) : new Integer(0);
            }
        });
        operationsByName.put("union", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Collection.class, operationsByName);
        operationsByName.put("size", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer(((Collection)localVars[0]).size());
            }
        });
        operationsByName.put("sum", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Collection c = (Collection)localVars[0];
                if (c.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                Iterator i = c.iterator();
                Object ret = i.next();
                Operation operation = ExecEnv.this.getOperation(ExecEnv.getType(ret), "+");
                while (i.hasNext()) {
                    StackFrame callee = frame.newFrame(operation);
                    callee.localVars[0] = ret;
                    callee.localVars[1] = i.next();
                    ret = operation.exec(callee);
                }
                return ret;
            }
        });
        operationsByName.put("includes", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Collection)localVars[0]).contains(localVars[1]));
            }
        });
        operationsByName.put("excludes", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(!((Collection)localVars[0]).contains(localVars[1]));
            }
        });
        operationsByName.put("count", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                int ret = 0;
                Object o = localVars[1];
                Iterator i = ((Collection)localVars[0]).iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(o)) continue;
                    ++ret;
                }
                return new Integer(ret);
            }
        });
        operationsByName.put("includesAll", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(!((Collection)localVars[0]).containsAll((Collection)localVars[1]));
            }
        });
        operationsByName.put("excludesAll", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                boolean ret = true;
                Collection s = (Collection)localVars[0];
                for (Object object : (Collection)localVars[1]) {
                    boolean bl = ret = ret && !s.contains(object);
                }
                return new Boolean(ret);
            }
        });
        operationsByName.put("isEmpty", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Collection)localVars[0]).isEmpty());
            }
        });
        operationsByName.put("notEmpty", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(!((Collection)localVars[0]).isEmpty());
            }
        });
        operationsByName.put("asSequence", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new ArrayList((Collection)localVars[0]);
            }
        });
        operationsByName.put("asSet", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                return ret;
            }
        });
        operationsByName.put("asBag", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag((Collection)localVars[0]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(String.class, operationsByName);
        operationsByName.put("size", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer(((String)localVars[0]).length());
            }
        });
        operationsByName.put("regexReplaceAll", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).replaceAll((String)localVars[1], (String)localVars[2]);
            }
        });
        operationsByName.put("replaceAll", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).replace(((String)localVars[1]).charAt(0), ((String)localVars[2]).charAt(0));
            }
        });
        operationsByName.put("split", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return Arrays.asList(((String)localVars[0]).split((String)localVars[1]));
            }
        });
        operationsByName.put("toInteger", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.valueOf((String)localVars[0]);
            }
        });
        operationsByName.put("toReal", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return Double.valueOf((String)localVars[0]);
            }
        });
        operationsByName.put("toUpper", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).toUpperCase();
            }
        });
        operationsByName.put("toLower", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).toLowerCase();
            }
        });
        operationsByName.put("toSequence", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                String tmp = (String)localVars[0];
                ArrayList<String> ret = new ArrayList<String>();
                int i = 0;
                while (i < tmp.length()) {
                    ret.add("" + tmp.charAt(i));
                    ++i;
                }
                return ret;
            }
        });
        operationsByName.put("startsWith", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).startsWith((String)localVars[1]));
            }
        });
        operationsByName.put("substring", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).substring(((Number)localVars[1]).intValue() - 1, ((Number)localVars[2]).intValue());
            }
        });
        operationsByName.put("indexOf", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer(((String)localVars[0]).indexOf((String)localVars[1]));
            }
        });
        operationsByName.put("lastIndexOf", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Integer(((String)localVars[0]).lastIndexOf((String)localVars[1]));
            }
        });
        operationsByName.put("endsWith", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).endsWith((String)localVars[1]));
            }
        });
        operationsByName.put("+", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return String.valueOf((String)localVars[0]) + localVars[1];
            }
        });
        operationsByName.put("concat", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return String.valueOf((String)localVars[0]) + localVars[1];
            }
        });
        operationsByName.put("<", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).compareTo((String)localVars[1]) < 0);
            }
        });
        operationsByName.put("<=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).compareTo((String)localVars[1]) <= 0);
            }
        });
        operationsByName.put(">", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).compareTo((String)localVars[1]) > 0);
            }
        });
        operationsByName.put(">=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).compareTo((String)localVars[1]) >= 0);
            }
        });
        operationsByName.put("=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((String)localVars[0]).equals(localVars[1]));
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Tuple.class, operationsByName);
        operationsByName.put("=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(((Tuple)localVars[0]).equals((Tuple)localVars[1]));
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Object.class, operationsByName);
        operationsByName.put("toString", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ExecEnv.this.toPrettyPrintedString(localVars[0]);
            }
        });
        operationsByName.put("refGetValue", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[0] instanceof EObject) {
                    return EMFUtils.get(frame, (EObject)localVars[0], (String)localVars[1]);
                }
                return ((HasFields)localVars[0]).get(frame, localVars[1]);
            }
        });
        operationsByName.put("refSetValue", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[0] instanceof EObject) {
                    EMFUtils.set(frame, (EObject)localVars[0], (String)localVars[1], localVars[2]);
                } else {
                    ((HasFields)localVars[0]).set(frame, localVars[1], localVars[2]);
                }
                return localVars[0];
            }
        });
        operationsByName.put("=", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[0] instanceof EEnumLiteral) {
                    return new Boolean(((EEnumLiteral)localVars[0]).getName().equals(localVars[1].toString()));
                }
                return new Boolean(localVars[0].equals(localVars[1]));
            }
        });
        operationsByName.put("<>", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Boolean(!localVars[0].equals(localVars[1]));
            }
        });
        operationsByName.put("oclIsUndefined", new Operation(1){

            public Object exec(StackFrame frame) {
                return Boolean.FALSE;
            }
        });
        operationsByName.put("oclType", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[0] instanceof EObject) {
                    return ((EObject)localVars[0]).eClass();
                }
                throw new RuntimeException(".oclType not implemented for OCL library yet");
            }
        });
        operationsByName.put("debug", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ExecEnv.this.out.print(localVars[1]);
                ExecEnv.this.out.print(": ");
                ExecEnv.this.prettyPrint(localVars[0]);
                ExecEnv.this.out.println();
                return localVars[0];
            }
        });
        operationsByName.put("oclIsKindOf", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Class) {
                    return new Boolean(((Class)localVars[1]).isInstance(localVars[0]));
                }
                if (localVars[1] instanceof OclType) {
                    if (localVars[1] instanceof OclParametrizedType) {
                        return new Boolean(localVars[0] instanceof Collection);
                    }
                    return Boolean.FALSE;
                }
                if (localVars[1] instanceof EClass) {
                    return new Boolean(((EClass)localVars[1]).isInstance(localVars[0]));
                }
                throw new RuntimeException("do not know how to handle type: " + localVars[1]);
            }
        });
        operationsByName.put("oclIsTypeOf", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Class) {
                    return new Boolean(localVars[1].equals(localVars[0].getClass()));
                }
                if (localVars[1] instanceof EClass) {
                    if (localVars[0] instanceof EObject) {
                        return new Boolean(localVars[1].equals(((EObject)localVars[0]).eClass()));
                    }
                    return Boolean.FALSE;
                }
                throw new RuntimeException("do not know how to handle type: " + localVars[1]);
            }
        });
        operationsByName.put("refImmediateComposite", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[0] instanceof EObject) {
                    Object ret = ((EObject)localVars[0]).eContainer();
                    if (ret == null) {
                        ret = OclUndefined.SINGLETON;
                    }
                    return ret;
                }
                throw new RuntimeException("refImmediateComposite only valid on model elements");
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclUndefined.class, operationsByName);
        operationsByName.put("oclIsUndefined", new Operation(1){

            public Object exec(StackFrame frame) {
                return Boolean.TRUE;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclType.class, operationsByName);
        operationsByName.put("setName", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ((OclType)localVars[0]).setName((String)localVars[1]);
                return null;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclParametrizedType.class, operationsByName);
        operationsByName.put("setElementType", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ((OclParametrizedType)localVars[0]).setElementType(localVars[1]);
                return null;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(EcorePackage.eINSTANCE.getEClass(), operationsByName);
        operationsByName.put("allInstancesFrom", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Model model = frame.execEnv.getModel(localVars[1]);
                if (model == null) {
                    throw new RuntimeException("model not found: " + localVars[1]);
                }
                return model.getElementsByType((EClass)localVars[0]);
            }
        });
        operationsByName.put("allInstances", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet ret = new LinkedHashSet();
                EClass ec = (EClass)localVars[0];
                Model rm = ExecEnv.this.getModelOf((EObject)ec);
                for (Model model : frame.execEnv.modelsByName.values()) {
                    if (model.isTarget || model.getReferenceModel() != rm) continue;
                    ret.addAll(model.getElementsByType(ec));
                }
                return ret;
            }
        });
        operationsByName.put("registerHelperAttribute", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                String name = (String)localVars[1];
                String initOperationName = (String)localVars[2];
                frame.execEnv.registerAttributeHelper(localVars[0], name, initOperationName);
                return null;
            }
        });
        operationsByName.put("newInstance", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                EClass ec = (EClass)localVars[0];
                return ExecEnv.this.newElement(frame, ec);
            }
        });
        operationsByName.put("getInstanceById", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Model model = ExecEnv.this.getModel(localVars[1]);
                Object ret = model.resource.getEObject((String)localVars[2]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Class.class, operationsByName);
        operationsByName.put("registerHelperAttribute", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                String name = (String)localVars[1];
                String initOperationName = (String)localVars[2];
                frame.execEnv.registerAttributeHelper(localVars[0], name, initOperationName);
                return null;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(TransientLink.class, operationsByName);
        operationsByName.put("setRule", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).rule = (String)localVars[1];
                return null;
            }
        });
        operationsByName.put("addSourceElement", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).sourceElements.put(localVars[1], localVars[2]);
                return null;
            }
        });
        operationsByName.put("addTargetElement", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[0];
                tl.targetElements.put(localVars[1], localVars[2]);
                tl.targetElementsList.add(localVars[2]);
                return null;
            }
        });
        operationsByName.put("getSourceElement", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLink)localVars[0]).sourceElements.get(localVars[1]);
            }
        });
        operationsByName.put("getTargetElement", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).targetElements.get(localVars[1]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("getTargetFromSource", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).targetElementsList.iterator().next();
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("getNamedTargetFromSource", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).targetElements.get(localVars[2]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("addVariable", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).variables.put(localVars[1], localVars[2]);
                return null;
            }
        });
        operationsByName.put("getVariable", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLink)localVars[0]).variables.get(localVars[1]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(TransientLinkSet.class, operationsByName);
        operationsByName.put("addLink", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[1];
                TransientLinkSet tls = (TransientLinkSet)localVars[0];
                tls.addLink(tl);
                return null;
            }
        });
        operationsByName.put("addLink2", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[1];
                TransientLinkSet tls = (TransientLinkSet)localVars[0];
                boolean isDefault = (Boolean)localVars[2];
                tls.addLink2(tl, isDefault);
                return null;
            }
        });
        operationsByName.put("getLinksByRule", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLinkSet)localVars[0]).getLinksByRule(localVars[1]);
            }
        });
        operationsByName.put("getLinkBySourceElement", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink ret = ((TransientLinkSet)localVars[0]).getLinkBySourceElement(localVars[1]);
                if (ret == null) {
                    return OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("getLinkByRuleAndSourceElement", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink ret = ((TransientLinkSet)localVars[0]).getLinkByRuleAndSourceElement(localVars[1], localVars[2]);
                if (ret == null) {
                    return OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(HashMap.class, operationsByName);
        operationsByName.put("get", new Operation(2){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((Map)localVars[0]).get(localVars[1]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("including", new Operation(3){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                HashMap<Object, Object> ret = new HashMap<Object, Object>((Map)localVars[0]);
                ret.put(localVars[1], localVars[2]);
                return ret;
            }
        });
        operationsByName.put("getKeys", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Map)localVars[0]).keySet();
            }
        });
        operationsByName.put("getValues", new Operation(1){

            public Object exec(StackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Map)localVars[0]).values();
            }
        });
        this.emptySequence = new ArrayList();
        this.noInitializer = new Operation(0){

            public Object exec(StackFrame frame) {
                return null;
            }
        };
        this.modelsByName = models;
        this.modelsByResource = new HashMap();
        this.nameByModel = new HashMap();
        for (String name : this.modelsByName.keySet()) {
            Model model = (Model)this.modelsByName.get(name);
            this.modelsByResource.put(model.resource, model);
            this.nameByModel.put(model, name);
        }
    }

    public Model getModelOf(EObject element) {
        Model ret = (Model)this.modelsByResource.get(element.eResource());
        if (ret == null) {
            Iterator i = this.modelsByName.keySet().iterator();
            while (i.hasNext() && ret == null) {
                String name = (String)i.next();
                Model model = (Model)this.modelsByName.get(name);
                if (!model.contains(element)) continue;
                ret = model;
            }
        }
        return ret;
    }

    public String getModelNameOf(EObject element) {
        return (String)this.nameByModel.get(this.getModelOf(element));
    }

    public Model getModel(Object name) {
        return (Model)this.modelsByName.get(name);
    }

    public Iterator getModels() {
        return this.modelsByName.values().iterator();
    }

    public Operation getOperation(Object type, Object name) {
        Operation ret = null;
        Map map = this.getOperations(type, false);
        if (map != null) {
            ret = (Operation)map.get(name);
        }
        if (ret == null) {
            Iterator i = this.getSupertypes(type).iterator();
            while (i.hasNext() && ret == null) {
                Object st = i.next();
                ret = this.getOperation(st, name);
            }
            if (map != null) {
                map.put(name, ret);
            }
        }
        return ret;
    }

    public List getSupertypes(Object type) {
        Object ret = null;
        if (type != null) {
            if (type instanceof EClass) {
                ret = ((EClass)type).getESuperTypes();
                if (ret.size() == 0) {
                    ret = Arrays.asList(Object.class);
                }
            } else {
                Class sc;
                ret = (List)this.supertypes.get(type);
                if (ret == null && (sc = ((Class)type).getSuperclass()) != null) {
                    ret = Arrays.asList(sc);
                }
            }
        }
        if (ret == null) {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    public void registerAttributeHelper(Object type, String name, String initOperationName) {
        Operation op = this.getOperation(type, initOperationName);
        this.getAttributeInitializers(type, true).put(name, op);
    }

    public Operation getAttributeInitializer(Object type, String name) {
        Operation ret = null;
        Map map = this.getAttributeInitializers(type, true);
        if (map != null) {
            ret = (Operation)map.get(name);
        }
        if (ret == null) {
            Iterator i = this.getSupertypes(type).iterator();
            while (i.hasNext() && ret == null) {
                Object st = i.next();
                ret = this.getAttributeInitializer(st, name);
            }
            if (map != null) {
                if (ret == null) {
                    ret = this.noInitializer;
                }
                map.put(name, ret);
            }
        }
        if (ret == this.noInitializer) {
            ret = null;
        }
        return ret;
    }

    private Map getAttributeInitializers(Object type, boolean createIfMissing) {
        HashMap ret = (HashMap)this.attributeInitializers.get(type);
        if (createIfMissing && ret == null) {
            ret = new HashMap();
            this.attributeInitializers.put(type, ret);
        }
        return ret;
    }

    private Map getHelperValues(Object element) {
        HashMap ret = (HashMap)this.helperValuesByElement.get(element);
        if (ret == null) {
            ret = new HashMap();
            this.helperValuesByElement.put(element, ret);
        }
        return ret;
    }

    public Object getHelperValue(StackFrame frame, Object type, Object element, String name) {
        Map helperValues = this.getHelperValues(element);
        Object ret = helperValues.get(name);
        if (ret == null) {
            Operation o = this.getAttributeInitializer(type, name);
            StackFrame calleeFrame = frame.newFrame(o);
            Object[] arguments = calleeFrame.localVars;
            arguments[0] = element;
            ret = o.exec(calleeFrame);
            if (this.cacheAttributeHelperResults) {
                helperValues.put(name, ret);
            }
        }
        return ret;
    }

    public void registerOperation(Object type, Operation oper, String name) {
        this.getOperations(type, true).put(name, oper);
    }

    private Map getOperations(Object type, boolean createIfMissing) {
        HashMap ret = (HashMap)this.operationsByType.get(type);
        if (ret == null) {
            Map vmops = this.getVMOperations(type);
            if (createIfMissing || vmops != null && !vmops.isEmpty()) {
                ret = new HashMap();
                this.operationsByType.put(type, ret);
                if (vmops != null) {
                    ret.putAll(vmops);
                }
            }
        }
        return ret;
    }

    private Map getVMOperations(Object type) {
        return (Map)this.vmTypeOperations.get(type);
    }

    public String toPrettyPrintedString(Object value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.prettyPrint(new PrintStream(out), value);
        return out.toString();
    }

    public void prettyPrint(Object value) {
        this.prettyPrint(this.out, value);
    }

    public void prettyPrint(PrintStream out, Object value) {
        if (value == null) {
            out.print("<null>");
        } else if (value instanceof String) {
            out.print('\'');
            out.print(value);
            out.print('\'');
        } else if (value instanceof EnumLiteral) {
            out.print('#');
            out.print(value);
        } else if (value instanceof EClass) {
            EClass c = (EClass)value;
            out.print(this.getModelNameOf((EObject)c));
            out.print('!');
            String name = c.getName();
            if (name == null) {
                name = "<unnamed>";
            }
            out.print(name);
        } else if (value instanceof EObject) {
            EObject eo = (EObject)value;
            this.prettyPrint(out, eo.eClass());
            out.print('@');
            out.print(this.getModelNameOf(eo));
        } else if (value instanceof LinkedHashSet) {
            out.print("OrderedSet {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof HashSet) {
            out.print("Set {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof ArrayList || value instanceof EList) {
            out.print("Sequence {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof Bag) {
            out.print("Bag {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof Tuple) {
            out.print("Tuple {");
            boolean first = true;
            for (Map.Entry entry : ((Tuple)value).getMap().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.print(", ");
                }
                out.print(entry.getKey());
                out.print(" = ");
                this.prettyPrint(out, entry.getValue());
            }
            out.print('}');
        } else {
            out.print(value);
        }
    }

    private void prettyPrintCollection(PrintStream out, Collection col) {
        boolean first = true;
        Iterator i = col.iterator();
        while (i.hasNext()) {
            if (!first) {
                out.print(", ");
            }
            this.prettyPrint(out, i.next());
            first = false;
        }
        out.print('}');
    }

    public static EClass findMetaElement(StackFrame frame, Object mname, Object me) {
        EClass ret = null;
        ReferenceModel referenceModel = (ReferenceModel)frame.execEnv.getModel(mname);
        if (referenceModel != null) {
            ret = referenceModel.getMetaElementByName((String)me);
            if (ret == null) {
                throw new RuntimeException("cannot find class " + me + " in reference model " + mname);
            }
        } else {
            throw new RuntimeException("cannot find reference model " + mname);
        }
        return ret;
    }

    public static Object getType(Object value) {
        if (value instanceof EObject) {
            return ((EObject)value).eClass();
        }
        if (value instanceof EList) {
            return ArrayList.class;
        }
        return value.getClass();
    }

    public Object newElement(StackFrame frame, EClass ec) {
        EObject s = null;
        Iterator i = this.getModels();
        while (i.hasNext()) {
            Model model = (Model)i.next();
            if (!model.isTarget || !model.getReferenceModel().isModelOf(ec)) continue;
            s = model.newElement(ec);
            break;
        }
        if (s == null) {
            throw new VMException(frame, "cannot create " + this.toPrettyPrintedString(ec));
        }
        return s;
    }
}

