/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.launching;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.adt.debug.core.AtlRunTarget;
import org.eclipse.m2m.atl.adt.launching.AtlLauncherTools;
import org.eclipse.m2m.atl.adt.launching.AtlVM;
import org.eclipse.m2m.atl.adt.launching.sourcelookup.AtlSourceLocator;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlRegularVM
extends AtlVM {
    private static final boolean useEMFURIs = true;

    private static InputStream fileNameToInputStream(String filePath) throws FileNotFoundException, CoreException {
        if (filePath.startsWith("ext:")) {
            File f = new File(filePath.substring(4));
            return new FileInputStream(f);
        }
        IWorkspaceRoot iwr = ResourcesPlugin.getWorkspace().getRoot();
        filePath = filePath.replace('#', '/');
        return iwr.getFile((IPath)new Path(filePath)).getContents();
    }

    private static URI fileNameToURI(String filePath) throws IllegalArgumentException {
        if (filePath.startsWith("ext:")) {
            File f = new File(filePath.substring(4));
            return URI.createFileURI((String)f.getPath());
        }
        return URI.createPlatformResourceURI((String)filePath, (boolean)true);
    }

    private static URL fileNameToURL(String filePath) throws MalformedURLException {
        if (filePath.startsWith("ext:")) {
            File f = new File(filePath.substring(4));
            return f.toURL();
        }
        IWorkspace wks = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wksroot = wks.getRoot();
        IFile currentLib = wksroot.getFile((IPath)new Path(filePath));
        return currentLib.getLocation().toFile().toURL();
    }

    private static IFile getASMFile(String atlFilePath) {
        IFile currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)atlFilePath));
        String extension = currentAtlFile.getFileExtension().toLowerCase();
        if (AtlLauncherTools.EXTENSIONS.contains(extension)) {
            String currentAsmPath = String.valueOf(currentAtlFile.getFullPath().toString().substring(0, currentAtlFile.getFullPath().toString().length() - extension.length())) + "asm";
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(currentAsmPath));
        }
        return null;
    }

    private static Map getSourceModels(Map arg, Map path, Map modelHandler, Map atlModelHandler, boolean checkSameModel, Collection toDispose) throws CoreException {
        HashMap<String, ASMModel> toReturn = new HashMap<String, ASMModel>();
        try {
            for (String mName : arg.keySet()) {
                ASMModel inputModel;
                String mmName = (String)arg.get(mName);
                AtlModelHandler amh = (AtlModelHandler)atlModelHandler.get(modelHandler.get(mmName));
                ASMModel mofmm = amh.getMof();
                toReturn.put("%" + modelHandler.get(mmName), mofmm);
                mofmm.setIsTarget(false);
                if (((String)path.get(mmName)).startsWith("#")) {
                    toReturn.put(mmName, mofmm);
                    inputModel = (ASMModel)toReturn.get(mName);
                    if (inputModel == null) {
                        inputModel = AtlRegularVM.loadModel(amh, mName, mofmm, (String)path.get(mName), toDispose);
                    }
                } else {
                    ASMModel inputMetaModel = (ASMModel)toReturn.get(mmName);
                    if (inputMetaModel == null) {
                        inputMetaModel = AtlRegularVM.loadModel(amh, mmName, mofmm, (String)path.get(mmName), toDispose);
                        toReturn.put(mmName, inputMetaModel);
                    }
                    inputMetaModel.setIsTarget(false);
                    inputModel = AtlRegularVM.loadModel(amh, mName, inputMetaModel, (String)path.get(mName), toDispose);
                }
                inputModel.setIsTarget(false);
                if (inputModel instanceof ASMEMFModel) {
                    ((ASMEMFModel)inputModel).setCheckSameModel(checkSameModel);
                }
                toReturn.put(mName, inputModel);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return toReturn;
    }

    private static Map getTargetModels(Map arg, Map path, Map modelHandler, Map atlModelHandler, Map input, boolean checkSameModel, Collection toDispose) throws CoreException {
        HashMap<String, ASMModel> toReturn = new HashMap<String, ASMModel>();
        try {
            for (String mName : arg.keySet()) {
                ASMModel outputModel;
                String mmName = (String)arg.get(mName);
                AtlModelHandler amh = (AtlModelHandler)atlModelHandler.get(modelHandler.get(mmName));
                ASMModel mofmm = amh.getMof();
                mofmm.setIsTarget(false);
                if (((String)path.get(mmName)).startsWith("#")) {
                    if (input.get(mmName) == null) {
                        toReturn.put(mmName, mofmm);
                    }
                    if ((outputModel = (ASMModel)toReturn.get(mName)) == null) {
                        outputModel = AtlRegularVM.newModel(amh, mName, mofmm, (String)path.get(mName), toDispose);
                    }
                } else {
                    ASMModel outputMetaModel = (ASMModel)input.get(mmName);
                    if (outputMetaModel == null) {
                        outputMetaModel = (ASMModel)toReturn.get(mmName);
                    }
                    if (outputMetaModel == null) {
                        outputMetaModel = AtlRegularVM.loadModel(amh, mmName, mofmm, (String)path.get(mmName), toDispose);
                        toReturn.put(mmName, outputMetaModel);
                    }
                    outputMetaModel.setIsTarget(false);
                    outputModel = AtlRegularVM.newModel(amh, mName, outputMetaModel, (String)path.get(mName), toDispose);
                }
                outputModel.setIsTarget(true);
                if (outputModel instanceof ASMEMFModel) {
                    ((ASMEMFModel)outputModel).setCheckSameModel(checkSameModel);
                }
                toReturn.put(mName, outputModel);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return toReturn;
    }

    private static ASMModel loadModel(AtlModelHandler amh, String mName, ASMModel metamodel, String path, Collection toDispose) throws CoreException, FileNotFoundException {
        ASMModel ret = null;
        if (amh instanceof AtlEMFModelHandler) {
            if (path.startsWith("uri:")) {
                ret = ((AtlEMFModelHandler)amh).loadModel(mName, metamodel, path);
            } else {
                ret = ((AtlEMFModelHandler)amh).loadModel(mName, metamodel, AtlRegularVM.fileNameToURI(path));
                toDispose.add(ret);
            }
        } else {
            ret = amh.loadModel(mName, metamodel, AtlRegularVM.fileNameToInputStream(path));
            toDispose.add(ret);
        }
        return ret;
    }

    private static ASMModel newModel(AtlModelHandler amh, String mName, ASMModel metamodel, String path, Collection toDispose) {
        ASMModel ret = amh.newModel(mName, AtlRegularVM.fileNameToURI(path).toString(), metamodel);
        toDispose.add(ret);
        return ret;
    }

    public static Map runAtlLauncher(String filePath, Map libsFromConfig, Map input, Map output, Map path, Map modelType, Map modelHandler, String mode, List superimpose, Map options) {
        boolean checkSameModel = "true".equals(options.get("checkSameModel"));
        HashMap toReturn = new HashMap();
        try {
            IFile asmFile = AtlRegularVM.getASMFile(filePath);
            URL asmUrl = asmFile.getLocation().toFile().toURL();
            HashMap<String, AtlModelHandler> atlModelHandler = new HashMap<String, AtlModelHandler>();
            Iterator i = modelHandler.keySet().iterator();
            while (i.hasNext()) {
                String currentModelHandler = (String)modelHandler.get(i.next());
                if (atlModelHandler.containsKey(currentModelHandler) || currentModelHandler.equals("")) continue;
                atlModelHandler.put(currentModelHandler, AtlModelHandler.getDefault((String)currentModelHandler));
            }
            HashMap<String, URL> libs = new HashMap<String, URL>();
            for (String libName : libsFromConfig.keySet()) {
                URL stringsUrl = AtlRegularVM.fileNameToURL((String)libsFromConfig.get(libName));
                libs.put(libName, stringsUrl);
            }
            ArrayList<URL> superimposeURLs = new ArrayList<URL>();
            Iterator i2 = superimpose.iterator();
            while (i2.hasNext()) {
                URL moduleUrl = AtlRegularVM.fileNameToURL((String)i2.next());
                superimposeURLs.add(moduleUrl);
            }
            HashSet toDispose = new HashSet();
            Map inModel = AtlRegularVM.getSourceModels(input, path, modelHandler, atlModelHandler, checkSameModel, toDispose);
            Map outModel = AtlRegularVM.getTargetModels(output, path, modelHandler, atlModelHandler, inModel, checkSameModel, toDispose);
            HashMap models = new HashMap();
            for (String mName : inModel.keySet()) {
                models.put(mName, inModel.get(mName));
            }
            for (String mName : outModel.keySet()) {
                models.put(mName, outModel.get(mName));
            }
            Map params = Collections.EMPTY_MAP;
            AtlLauncher myLauncher = AtlLauncher.getDefault();
            if (mode.equals("debug")) {
                myLauncher.debug(asmUrl, libs, models, params, superimposeURLs, options);
            } else {
                myLauncher.launch(asmUrl, libs, models, params, superimposeURLs, options);
            }
            for (String mName : outModel.keySet()) {
                ASMModel currentOutModel = (ASMModel)outModel.get(mName);
                if (modelType.get(mName) == null || !((String)modelType.get(mName)).equals("MODELOUTPUT")) continue;
                String mmName = (String)output.get(mName);
                ((AtlModelHandler)atlModelHandler.get(modelHandler.get(mmName))).saveModel(currentOutModel, (String)path.get(mName));
            }
            for (ASMModel model : toDispose) {
                AtlModelHandler.getHandler((ASMModel)model).disposeOfModel(model);
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        catch (CoreException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
        return toReturn;
    }

    public void launch(ILaunchConfiguration configurationParam, String mode, ILaunch launchParam, IProgressMonitor monitor) throws CoreException {
        final String currentMode = mode;
        final ILaunchConfiguration configuration = configurationParam;
        final ILaunch launch = launchParam;
        if (mode.equals("debug")) {
            launch.setSourceLocator((ISourceLocator)new AtlSourceLocator());
            AtlDebugTarget mTarget = new AtlDebugTarget(launchParam);
            new Thread(){

                public void run() {
                    AtlRegularVM.this.runAtlLauncher(configuration, launch, currentMode);
                }
            }.start();
            mTarget.start();
            launchParam.addDebugTarget((IDebugTarget)mTarget);
        } else {
            launchParam.setSourceLocator((ISourceLocator)new AtlSourceLocator());
            AtlRunTarget mTarget = new AtlRunTarget(launchParam);
            launchParam.addDebugTarget((IDebugTarget)mTarget);
            this.runAtlLauncher(configurationParam, launchParam, currentMode);
            mTarget.terminate();
        }
    }

    private void runAtlLauncher(ILaunchConfiguration configuration, ILaunch launch, String mode) {
        try {
            String fileName = configuration.getAttribute("ATL File Name", "<null>");
            Map input = configuration.getAttribute("Input", new HashMap());
            Map output = configuration.getAttribute("Output", new HashMap());
            Map path = configuration.getAttribute("Path", new HashMap());
            Map modelType = configuration.getAttribute("ModelType", new HashMap());
            Map libsFromConfig = configuration.getAttribute("Libs", new HashMap());
            Map modelHandler = configuration.getAttribute("Model Handler", new HashMap());
            List superimpose = configuration.getAttribute("Superimpose", new ArrayList());
            HashMap<String, String> options = new HashMap<String, String>();
            int i = 0;
            while (i < AtlLauncherTools.additionalParamIds.length) {
                boolean value = configuration.getAttribute(AtlLauncherTools.additionalParamIds[i], false);
                options.put(AtlLauncherTools.additionalParamIds[i], value ? "true" : "false");
                ++i;
            }
            AtlRegularVM.runAtlLauncher(fileName, libsFromConfig, input, output, path, modelType, modelHandler, mode, superimpose, options);
        }
        catch (CoreException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
        }
    }

    public Object launch(URL asmUrl, Map libs, Map models, Map params, List superimps, Map options) {
        return AtlLauncher.getDefault().launch(asmUrl, libs, models, params, superimps, options);
    }
}

