/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core.nestedElements;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.service.core.ServiceTransformationUtil;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;

public class Model {
    private Injector injector;
    private ASMModel asmModel;
    private String name;
    private String atlModelHandlerId;
    private String metamodelName;
    private String fileName;

    public Model(String name, ASMModel metamodel, String path, String nsUri, boolean isM3, String atlModelHandlerId, String pluginId) throws ServiceException {
        this.asmModel = ServiceTransformationUtil.loadModel(AtlModelHandler.getDefault((String)atlModelHandlerId), name, metamodel, path, nsUri, isM3, false, pluginId);
        this.name = name;
    }

    public Model(String name, ASMModel metamodel, String fileName, String atlModelHandlerId) {
        this.asmModel = AtlModelHandler.getDefault((String)atlModelHandlerId).newModel(name, fileName, metamodel);
        this.fileName = fileName;
    }

    public Model(String name, String metamodel, String modelHandler) {
        this.name = name;
        this.metamodelName = metamodel;
        this.atlModelHandlerId = modelHandler;
    }

    public Model(String name, ASMModel metamodel, String path, String nsUri, boolean isM3, String atlModelHandlerId, String pluginId, String injectorType, Map paramsInjector) {
        if (injectorType.equals("ebnf")) {
            this.asmModel = ServiceTransformationUtil.ebnfInjection(name, path, AtlModelHandler.getDefault((String)atlModelHandlerId), metamodel, paramsInjector, (String)paramsInjector.get("parserPath"), metamodel.getName(), pluginId);
        }
        this.name = name;
    }

    public Model(String name, String metamodel, String modelHandler, String injectorType, Map paramsInjector) {
        this.name = name;
        this.metamodelName = metamodel;
        this.atlModelHandlerId = modelHandler;
        Injector i = new Injector(injectorType);
        i.params = paramsInjector;
        this.injector = i;
    }

    public void loadModel(String path, ASMModel asmMetamodel, String pluginId) throws ServiceException {
        if (this.injector == null) {
            this.asmModel = ServiceTransformationUtil.loadModel(AtlModelHandler.getDefault((String)this.atlModelHandlerId), this.name, asmMetamodel, path, null, false, true, pluginId);
        } else if (this.injector.type.equals("ebnf")) {
            this.asmModel = ServiceTransformationUtil.ebnfInjection(this.name, path, AtlModelHandler.getDefault((String)this.atlModelHandlerId), asmMetamodel, this.injector.params, (String)this.injector.params.get("parserPath"), asmMetamodel.getName(), pluginId);
        }
    }

    public ASMModel getAsmModel() {
        return this.asmModel;
    }

    public String getName() {
        return this.name;
    }

    public String getMetamodelName() {
        return this.metamodelName;
    }

    public String getFileName() {
        return this.fileName;
    }

    private class Injector {
        private String type;
        private Map params;

        public Injector(String type) {
            this.type = type;
            this.params = new HashMap();
        }
    }
}

