/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.clazz.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.internal.resources.PathmapManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.uml2.diagram.clazz.action.ApplyProfileAction;
import org.eclipse.uml2.diagram.clazz.part.CustomMessages;
import org.eclipse.uml2.diagram.common.pathmap.PathMapService;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicableProfilesItemProvider
extends AbstractContributionItemProvider
implements IProvider {
    public static final String MENU_APPLY_PROFILE = "menu_apply_unapply_profile";

    protected IMenuManager createMenuManager(String menuId, IWorkbenchPartDescriptor partDescriptor) {
        if (!MENU_APPLY_PROFILE.equals(menuId)) {
            return super.createMenuManager(menuId, partDescriptor);
        }
        MenuManager menuManager = new MenuManager(CustomMessages.ApplicableProfilesItemProvider_apply_profile_menu);
        MenuBuilder builder = new MenuBuilder(partDescriptor);
        builder.buildMenu((IMenuManager)menuManager);
        menuManager.addMenuListener((IMenuListener)builder);
        return menuManager;
    }

    private List<Profile> getProfiles(Package package_) {
        final ArrayList<Profile> choiceOfValues = new ArrayList<Profile>();
        ResourceSet resourceSet = package_.eResource().getResourceSet();
        this.addStandardProfileResources(resourceSet);
        this.addResourcesFromPathMap(resourceSet);
        for (Resource resource : resourceSet.getResources()) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                new UMLSwitch<Object>(){

                    public Object caseProfile(Profile profile) {
                        if (profile.isDefined()) {
                            choiceOfValues.add(profile);
                        }
                        return profile;
                    }
                }.doSwitch((EObject)allContents.next());
            }
        }
        return choiceOfValues;
    }

    private void addStandardProfileResources(ResourceSet resourceSet) {
        try {
            this.loadResource(resourceSet, "pathmap://UML_PROFILES/Standard.profile.uml");
            this.loadResource(resourceSet, "pathmap://UML_PROFILES/Ecore.profile.uml");
        }
        catch (Exception exception) {}
    }

    private void addResourcesFromPathMap(ResourceSet resourceSet) {
        try {
            Set pathVariables = PathmapManager.getAllPathVariables();
            for (Object currVariable : pathVariables) {
                String varName = (String)currVariable;
                String varValue = PathmapManager.getRegisteredValue((String)varName);
                Collection profiles = PathMapService.getInstance().getProfiles(varName, varValue);
                for (String pathmap : profiles) {
                    this.loadResource(resourceSet, pathmap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Resource loadResource(ResourceSet resourceSet, String pathmap) {
        URI profileURI = URI.createURI((String)pathmap);
        return resourceSet.getResource(profileURI, true);
    }

    private class MenuBuilder
    implements IMenuListener {
        private final IWorkbenchPartDescriptor myWorkbenchPart;

        public MenuBuilder(IWorkbenchPartDescriptor workbenchPart) {
            this.myWorkbenchPart = workbenchPart;
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.buildMenu(manager);
        }

        public void buildMenu(IMenuManager manager) {
            manager.removeAll();
            GraphicalEditPart selected = (GraphicalEditPart)ApplicableProfilesItemProvider.this.getSelectedObject(this.myWorkbenchPart);
            Package package_ = (Package)selected.getNotationView().getElement();
            List profiles = ApplicableProfilesItemProvider.this.getProfiles(package_);
            for (Profile profile : profiles) {
                ApplyProfileAction action = new ApplyProfileAction(this.getWorkbenchPage(), package_, profile);
                action.init();
                manager.add((IAction)action);
            }
        }

        private IWorkbenchPage getWorkbenchPage() {
            return this.myWorkbenchPart.getPartPage();
        }
    }
}

