/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core;

import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.IModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.IModelingAssistantModelProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.AssistantPlugin;

public class DefaultModelingAssistantModelProvider
implements IModelingAssistantModelProvider {
    private final URI resourceURI;

    public DefaultModelingAssistantModelProvider(URI resourceURI) {
        this.resourceURI = resourceURI;
    }

    @Override
    public Iterable<? extends IModelingAssistantProvider> loadProviders(ResourceSet resourceSet) {
        Iterable<Object> result;
        Resource resource = null;
        try {
            resource = resourceSet.getResource(this.resourceURI, true);
        }
        catch (Exception e) {
            AssistantPlugin.log.error("Error loading modeling assistants model " + String.valueOf(this.resourceURI), (Throwable)e);
            resource = resourceSet.getResource(this.resourceURI, false);
        }
        if (resource != null) {
            EcoreUtil.resolveAll((Resource)resource);
            result = Iterables.filter((Iterable)resource.getContents(), IModelingAssistantProvider.class);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }
}

