/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.util;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.papyrus.gmf.common.UnexpectedBehaviourException;
import org.eclipse.papyrus.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.papyrus.gmf.internal.common.codegen.JETGIFEmitterAdapter;

public class BinaryEmitters {
    private final URL myLocation = Platform.getBundle((String)"org.eclipse.papyrus.gmf.codegen").getEntry("/templates/");

    public BinaryEmitter getShortcutImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/editor/shortcut.gif");
    }

    public BinaryEmitter getGroupIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitter("/xpt/navigator/navigatorGroup.gif");
    }

    public BinaryEmitter getDiagramIconEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/diagram.gif");
    }

    public BinaryEmitter getWizardBannerImageEmitter() throws UnexpectedBehaviourException {
        return this.newGIFEmitterAdapter("/xpt/editor/wizban.gif");
    }

    private BinaryEmitter newGIFEmitter(String relativePath) throws UnexpectedBehaviourException {
        return new org.eclipse.papyrus.gmf.internal.common.codegen.GIFEmitter(this.checkTemplateLocation(relativePath));
    }

    private BinaryEmitter newGIFEmitterAdapter(String relativePath) throws UnexpectedBehaviourException {
        return new JETGIFEmitterAdapter(new GIFEmitter(this.checkTemplateLocation(relativePath)));
    }

    private String checkTemplateLocation(String relativePath) throws UnexpectedBehaviourException {
        String[] templatesPath = new String[]{this.myLocation.toString()};
        String templateLocation = JETCompiler.find((String[])templatesPath, (String)relativePath);
        if (templateLocation == null) {
            throw new UnexpectedBehaviourException("Template " + relativePath + " not found");
        }
        return templateLocation;
    }
}

