/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateElementAndNodeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationHelper;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.UMLFactory;

public class ChangeEdgeTargetCommand
extends AbstractTransactionalCommand {
    protected CreateElementAndNodeCommand createElementAndNodeCommand;
    protected CreateConnectionViewRequest.ConnectionViewDescriptor descriptor;
    protected Edge edge;
    protected String anchorId;

    public ChangeEdgeTargetCommand(TransactionalEditingDomain editingDomain, CreateElementAndNodeCommand createElementAndNodeCommand, CreateConnectionViewRequest.ConnectionViewDescriptor descriptor, String anchorId) {
        super(editingDomain, "Change message graphical target", null);
        this.createElementAndNodeCommand = createElementAndNodeCommand;
        this.descriptor = descriptor;
        this.anchorId = anchorId;
    }

    public ChangeEdgeTargetCommand(TransactionalEditingDomain editingDomain, CreateElementAndNodeCommand createElementAndNodeCommand, Edge edge, String anchorId) {
        super(editingDomain, "Change message graphical target", null);
        this.createElementAndNodeCommand = createElementAndNodeCommand;
        this.edge = edge;
        this.anchorId = anchorId;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List points;
        if (this.descriptor != null) {
            Object obj = this.descriptor.getAdapter(Edge.class);
            if (!(obj instanceof Edge)) {
                return null;
            }
            this.edge = (Edge)obj;
        }
        View newTarget = this.createElementAndNodeCommand.getCreatedView();
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        anchor.setId(this.anchorId);
        this.edge.setTargetAnchor((Anchor)anchor);
        Bendpoints bendpoints = this.edge.getBendpoints();
        if (bendpoints instanceof RelativeBendpoints && !(points = ((RelativeBendpoints)bendpoints).getPoints()).isEmpty()) {
            ArrayList<RelativeBendpoint> newPoints = new ArrayList<RelativeBendpoint>();
            RelativeBendpoint first = (RelativeBendpoint)points.get(0);
            RelativeBendpoint last = (RelativeBendpoint)points.get(1);
            RelativeBendpoint rb1 = new RelativeBendpoint(first.getSourceX(), first.getSourceY(), first.getTargetX() - 8, first.getTargetY());
            RelativeBendpoint rb2 = new RelativeBendpoint(last.getSourceX() + 8, last.getSourceY(), last.getTargetX(), 0);
            newPoints.add(rb1);
            int i = 1;
            while (i < points.size() - 1) {
                newPoints.add((RelativeBendpoint)points.get(i));
                ++i;
            }
            newPoints.add(rb2);
            ((RelativeBendpoints)bendpoints).setPoints(newPoints);
        }
        EObject edgeElement = ViewUtil.resolveSemanticElement((View)this.edge);
        EObject targetElement = ViewUtil.resolveSemanticElement((View)newTarget);
        if (edgeElement instanceof Message && MessageSort.SYNCH_CALL_LITERAL == ((Message)edgeElement).getMessageSort() && targetElement instanceof ExecutionSpecification) {
            MessageEnd receiveEvent = ((Message)edgeElement).getReceiveEvent();
            Collection collection = EMFHelper.getUsages((EObject)receiveEvent);
            for (EStructuralFeature.Setting nonNavigableInverseReference : collection) {
                EObject eObject = nonNavigableInverseReference.getEObject();
                if (!(eObject instanceof ExecutionSpecification) || eObject == targetElement || ((ExecutionSpecification)eObject).getStart() != receiveEvent) continue;
                OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)eObject, (Element)UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification());
            }
            OccurrenceSpecificationHelper.resetExecutionStart((ExecutionSpecification)targetElement, (Element)receiveEvent);
        }
        if (edgeElement instanceof Message && MessageSort.DELETE_MESSAGE_LITERAL == ((Message)edgeElement).getMessageSort()) {
            boolean cfr_ignored_0 = targetElement instanceof DestructionOccurrenceSpecification;
        }
        return null;
    }
}

