/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.UniqueList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PopularityList<E>
extends TransformedList<E, E> {
    private UniqueList<E> uniqueList;

    public static <E extends Comparable<? super E>> PopularityList<E> create(EventList<E> source) {
        return new PopularityList<E>(UniqueList.create(source));
    }

    public PopularityList(EventList<E> source) {
        this(new UniqueList<E>(source));
    }

    public PopularityList(EventList<E> source, Comparator<E> uniqueComparator) {
        this(new UniqueList<E>(source, uniqueComparator));
    }

    private PopularityList(UniqueList<E> uniqueList) {
        super(new SortedList<E>(uniqueList, new PopularityComparator<E>(uniqueList)));
        this.uniqueList = uniqueList;
        this.source.addListEventListener(this);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    @Override
    public void dispose() {
        SortedList sortedSource = (SortedList)this.source;
        super.dispose();
        sortedSource.dispose();
        this.uniqueList.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PopularityComparator<E>
    implements Comparator<E> {
        private UniqueList<E> target;

        public PopularityComparator(UniqueList<E> target) {
            this.target = target;
        }

        @Override
        public int compare(E a, E b) {
            int aCount = this.target.getCount(a);
            int bCount = this.target.getCount(b);
            return bCount - aCount;
        }
    }
}

