/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.Map;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.views.modelexplorer.sorting.DefaultTreeViewerSorting;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SortElementState
extends State
implements IExecutableExtension {
    private String viewID;

    public Object getValue() {
        IWorkbench bench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null && bench.getWorkbenchWindowCount() > 0) {
            window = bench.getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = window == null ? null : window.getActivePage();
        IViewPart viewPart = page == null ? null : page.findView(this.viewID);
        return DefaultTreeViewerSorting.getSorting((IWorkbenchPart)viewPart).isSorted();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.viewID = SortElementState.getViewID(config, propertyName, data);
        if (this.viewID == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.views.modelexplorer", "No viewID specified in SortElementState extension."));
        }
    }

    static String getViewID(IConfigurationElement config, String propertyName, Object data) {
        String result = null;
        if (data instanceof String) {
            result = (String)data;
        } else {
            Map parameters = (Map)data;
            Object value = parameters.get("viewID");
            if (value instanceof String) {
                result = (String)value;
            }
        }
        return result;
    }
}

