/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.clientarea;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommand;
import org.eclipse.swt.events.MouseEvent;

public class ClientAreaResizeDragMode
implements IDragMode {
    protected ILayer rowHeaderIndexLayer;
    protected ILayer baseLayer;
    protected ClientAreaAdapter clientAreaAdapter;
    protected ViewportLayer[] viewportLayer;

    public ClientAreaResizeDragMode(ILayer rowHeaderIndexLayer, ILayer baseLayer, ClientAreaAdapter clientAreaAdapter, ViewportLayer ... viewportLayer) {
        this.rowHeaderIndexLayer = rowHeaderIndexLayer;
        this.baseLayer = baseLayer;
        this.clientAreaAdapter = clientAreaAdapter;
        this.viewportLayer = viewportLayer;
    }

    public void mouseDown(NatTable natTable, MouseEvent event) {
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        int baseWidth = this.baseLayer.getWidth();
        int newWidth = event.x - this.rowHeaderIndexLayer.getWidth();
        if (newWidth < 0) {
            newWidth = 1;
        } else if (newWidth > baseWidth) {
            newWidth = baseWidth;
        }
        this.clientAreaAdapter.setWidth(newWidth);
        ViewportLayer[] viewportLayerArray = this.viewportLayer;
        int n = this.viewportLayer.length;
        int n2 = 0;
        while (n2 < n) {
            ViewportLayer vp = viewportLayerArray[n2];
            vp.invalidateHorizontalStructure();
            vp.doCommand((ILayerCommand)new RecalculateScrollBarsCommand());
            ++n2;
        }
        natTable.redraw();
        natTable.getParent().layout(true, true);
    }
}

