/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PackedStrategy implements Enumerator
{
    COPY(0, "Copy", "COPY"),
    VERIFY(1, "Verify", "VERIFY"),
    UNPACK_AS_SIBLING(2, "UnpackAsSibling", "UNPACK_AS_SIBLING"),
    UNPACK(3, "Unpack", "UNPACK"),
    SKIP(4, "Skip", "SKIP");

    public static final int COPY_VALUE = 0;
    public static final int VERIFY_VALUE = 1;
    public static final int UNPACK_AS_SIBLING_VALUE = 2;
    public static final int UNPACK_VALUE = 3;
    public static final int SKIP_VALUE = 4;
    private static final PackedStrategy[] VALUES_ARRAY;
    public static final List<PackedStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PackedStrategy[]{COPY, VERIFY, UNPACK_AS_SIBLING, UNPACK, SKIP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PackedStrategy get(int value) {
        switch (value) {
            case 0: {
                return COPY;
            }
            case 1: {
                return VERIFY;
            }
            case 2: {
                return UNPACK_AS_SIBLING;
            }
            case 3: {
                return UNPACK;
            }
            case 4: {
                return SKIP;
            }
        }
        return null;
    }

    public static PackedStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackedStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PackedStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PackedStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    private PackedStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.literal;
    }
}

