/******************************************************************************
 * Copyright (c) 2008, 2008 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/
package org.eclipse.gmf.runtime.notation;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Text
 * Style</b></em>'. <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.gmf.runtime.notation.TextStyle#getTextAlignment
 * <em>Text Alignment</em>}</li>
 * </ul>
 *
 * @see org.eclipse.gmf.runtime.notation.NotationPackage#getTextStyle()
 * @model
 * @generated
 */
public interface TextStyle extends Style {
	/**
	 * Returns the value of the '<em><b>Text Alignment</b></em>' attribute. The
	 * default value is <code>"Left"</code>. The literals are from the enumeration
	 * {@link org.eclipse.gmf.runtime.notation.TextAlignment}. <!-- begin-user-doc
	 * -->
	 * <p>
	 * If the meaning of the '<em>Text Alignment</em>' attribute isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Text Alignment</em>' attribute.
	 * @see org.eclipse.gmf.runtime.notation.TextAlignment
	 * @see #setTextAlignment(TextAlignment)
	 * @see org.eclipse.gmf.runtime.notation.NotationPackage#getTextStyle_TextAlignment()
	 * @model default="Left"
	 * @generated
	 */
	TextAlignment getTextAlignment();

	/**
	 * Sets the value of the
	 * '{@link org.eclipse.gmf.runtime.notation.TextStyle#getTextAlignment <em>Text
	 * Alignment</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Text Alignment</em>' attribute.
	 * @see org.eclipse.gmf.runtime.notation.TextAlignment
	 * @see #getTextAlignment()
	 * @generated
	 */
	void setTextAlignment(TextAlignment value);

} // TextStyle
