/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.security.bundle.OM;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.AndFilter;
import org.eclipse.emf.cdo.security.Assignee;
import org.eclipse.emf.cdo.security.ClassFilter;
import org.eclipse.emf.cdo.security.ClassPermission;
import org.eclipse.emf.cdo.security.CombinedFilter;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.ExpressionFilter;
import org.eclipse.emf.cdo.security.FilterPermission;
import org.eclipse.emf.cdo.security.Group;
import org.eclipse.emf.cdo.security.LinkedFilter;
import org.eclipse.emf.cdo.security.NotFilter;
import org.eclipse.emf.cdo.security.ObjectFilter;
import org.eclipse.emf.cdo.security.ObjectPermission;
import org.eclipse.emf.cdo.security.OrFilter;
import org.eclipse.emf.cdo.security.PackageFilter;
import org.eclipse.emf.cdo.security.PackagePermission;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.Permission;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.ResourceFilter;
import org.eclipse.emf.cdo.security.ResourcePermission;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityElement;
import org.eclipse.emf.cdo.security.SecurityItem;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.security.UserPassword;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class SecurityValidator
extends EObjectValidator {
    public static final SecurityValidator INSTANCE = new SecurityValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.cdo.security";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return SecurityPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateSecurityElement((SecurityElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateSecurityItem((SecurityItem)value, diagnostics, context);
            }
            case 2: {
                return this.validateRealm((Realm)value, diagnostics, context);
            }
            case 3: {
                return this.validateDirectory((Directory)value, diagnostics, context);
            }
            case 4: {
                return this.validateRole((Role)value, diagnostics, context);
            }
            case 5: {
                return this.validateAssignee((Assignee)value, diagnostics, context);
            }
            case 6: {
                return this.validateGroup((Group)value, diagnostics, context);
            }
            case 7: {
                return this.validateUser((User)value, diagnostics, context);
            }
            case 8: {
                return this.validateUserPassword((UserPassword)value, diagnostics, context);
            }
            case 9: {
                return this.validatePermission((Permission)value, diagnostics, context);
            }
            case 10: {
                return this.validateClassPermission((ClassPermission)value, diagnostics, context);
            }
            case 11: {
                return this.validatePackagePermission((PackagePermission)value, diagnostics, context);
            }
            case 12: {
                return this.validateResourcePermission((ResourcePermission)value, diagnostics, context);
            }
            case 13: {
                return this.validateObjectPermission((ObjectPermission)value, diagnostics, context);
            }
            case 14: {
                return this.validateFilterPermission((FilterPermission)value, diagnostics, context);
            }
            case 15: {
                return this.validatePermissionFilter((PermissionFilter)value, diagnostics, context);
            }
            case 16: {
                return this.validateLinkedFilter((LinkedFilter)value, diagnostics, context);
            }
            case 17: {
                return this.validatePackageFilter((PackageFilter)value, diagnostics, context);
            }
            case 18: {
                return this.validateClassFilter((ClassFilter)value, diagnostics, context);
            }
            case 19: {
                return this.validateResourceFilter((ResourceFilter)value, diagnostics, context);
            }
            case 20: {
                return this.validateObjectFilter((ObjectFilter)value, diagnostics, context);
            }
            case 21: {
                return this.validateExpressionFilter((ExpressionFilter)value, diagnostics, context);
            }
            case 22: {
                return this.validateCombinedFilter((CombinedFilter)value, diagnostics, context);
            }
            case 23: {
                return this.validateNotFilter((NotFilter)value, diagnostics, context);
            }
            case 24: {
                return this.validateAndFilter((AndFilter)value, diagnostics, context);
            }
            case 25: {
                return this.validateOrFilter((OrFilter)value, diagnostics, context);
            }
            case 26: {
                return this.validatePatternStyle((PatternStyle)((Object)value), diagnostics, context);
            }
            case 27: {
                return this.validateAccess((Access)((Object)value), diagnostics, context);
            }
            case 28: {
                return this.validateAccessObject((Access)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateSecurityElement(SecurityElement securityElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)securityElement, diagnostics, context);
    }

    public boolean validateSecurityItem(SecurityItem securityItem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)securityItem, diagnostics, context);
    }

    public boolean validateRealm(Realm realm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)realm, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)realm, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)realm, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRealm_HasAdministrator(realm, diagnostics, context);
        }
        return result;
    }

    public boolean validateRealm_HasAdministrator(Realm realm, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CDORevision realmRevision = realm.cdoRevision();
        CDORevisionProvider revisionProvider = this.getRevisionProvider(realm, context);
        CDOBranchPoint securityContext = this.getSecurityContext(realm, context);
        for (User user : realm.getAllUsers()) {
            if (user.getDefaultAccess() == Access.WRITE) {
                return true;
            }
            for (Permission permission : user.getAllPermissions()) {
                if (permission.getAccess() != Access.WRITE || !permission.isApplicable(realmRevision, revisionProvider, securityContext)) continue;
                return true;
            }
        }
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_Realm_hasAdministrator_diagnostic", new Object[0], new Object[]{realm}, context));
        }
        return false;
    }

    protected <T> T getContextByClassKey(Map<Object, Object> context, Class<T> key, T defaultValue) {
        Object value;
        if (context != null && key.isInstance(value = context.get(key))) {
            return key.cast(value);
        }
        return defaultValue;
    }

    protected CDORevisionProvider getRevisionProvider(Realm realm, Map<Object, Object> context) {
        return (CDORevisionProvider)this.getContextByClassKey(context, CDORevisionProvider.class, realm.cdoView());
    }

    protected CDOBranchPoint getSecurityContext(Realm realm, Map<Object, Object> context) {
        return (CDOBranchPoint)this.getContextByClassKey(context, CDOBranchPoint.class, realm.cdoView());
    }

    public boolean validateDirectory(Directory directory, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)directory, diagnostics, context);
    }

    public boolean validateRole(Role role, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)role, diagnostics, context);
    }

    public boolean validateAssignee(Assignee assignee, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)assignee, diagnostics, context);
    }

    public boolean validateGroup(Group group, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)group, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)group, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)group, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGroup_AcyclicInheritance(group, diagnostics, context);
        }
        return result;
    }

    public boolean validateGroup_AcyclicInheritance(Group group, DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashSet<Group> visited = new HashSet<Group>();
        LinkedList<Group> toVisit = new LinkedList<Group>();
        toVisit.offer(group);
        Group next = (Group)toVisit.poll();
        while (next != null) {
            if (!visited.add(next)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_Group_acyclicInheritance_diagnostic", new Object[]{group.getId()}, new Object[]{group}, context));
                }
                return false;
            }
            toVisit.addAll((Collection<Group>)next.getInheritedGroups());
            next = (Group)toVisit.poll();
        }
        return true;
    }

    public boolean validateUser(User user, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)user, diagnostics, context);
    }

    public boolean validateUserPasswordGen(UserPassword userPassword, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)userPassword, diagnostics, context);
    }

    public boolean validateUserPassword(UserPassword userPassword, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePermission(Permission permission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)permission, diagnostics, context);
    }

    public boolean validateClassPermission(ClassPermission classPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)classPermission, diagnostics, context);
    }

    public boolean validatePackagePermission(PackagePermission packagePermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)packagePermission, diagnostics, context);
    }

    public boolean validateResourcePermission(ResourcePermission resourcePermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)resourcePermission, diagnostics, context);
    }

    public boolean validateObjectPermission(ObjectPermission objectPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)objectPermission, diagnostics, context);
    }

    public boolean validateFilterPermission(FilterPermission filterPermission, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)filterPermission, diagnostics, context);
    }

    public boolean validatePermissionFilter(PermissionFilter permissionFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)permissionFilter, diagnostics, context);
    }

    public boolean validateLinkedFilter(LinkedFilter linkedFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)linkedFilter, diagnostics, context);
    }

    public boolean validatePackageFilter(PackageFilter packageFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)packageFilter, diagnostics, context);
    }

    public boolean validateClassFilter(ClassFilter classFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)classFilter, diagnostics, context);
    }

    public boolean validateResourceFilter(ResourceFilter resourceFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)resourceFilter, diagnostics, context);
    }

    public boolean validateObjectFilter(ObjectFilter objectFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)objectFilter, diagnostics, context);
    }

    public boolean validateExpressionFilter(ExpressionFilter expressionFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)expressionFilter, diagnostics, context);
    }

    public boolean validateCombinedFilter(CombinedFilter combinedFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)combinedFilter, diagnostics, context);
    }

    public boolean validateNotFilter(NotFilter notFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)notFilter, diagnostics, context);
    }

    public boolean validateAndFilter(AndFilter andFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)andFilter, diagnostics, context);
    }

    public boolean validateOrFilter(OrFilter orFilter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint((EObject)orFilter, diagnostics, context);
    }

    public boolean validatePatternStyle(PatternStyle patternStyle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateAccess(Access access, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateAccessObject(Access accessObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return OM.EMF_PLUGIN;
    }
}

