/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions;

public abstract class Condition {
    public static final Condition TRUE = new Condition(){

        public boolean isSatisfied(Object object) {
            return true;
        }
    };
    public static final Condition FALSE = new Condition(){

        public boolean isSatisfied(Object object) {
            return false;
        }
    };

    protected Condition() {
    }

    public Condition AND(Condition condition) {
        return new And(condition);
    }

    public Condition OR(Condition condition) {
        return new Or(condition);
    }

    public Condition XOR(Condition condition) {
        return new XOr(condition);
    }

    public Condition IMPLIES(Condition condition) {
        return new Implies(condition);
    }

    public Condition EQUIVALENT(Condition condition) {
        return new Equivalent(condition);
    }

    public abstract boolean isSatisfied(Object var1);

    private class And
    extends CompoundCondition {
        And(Condition condition2) {
            super(condition2);
        }

        public boolean isSatisfied(Object object) {
            return Condition.this.isSatisfied(object) && this.condition.isSatisfied(object);
        }
    }

    private static abstract class CompoundCondition
    extends Condition {
        Condition condition;

        CompoundCondition(Condition condition) {
            this.condition = condition;
        }
    }

    private class Equivalent
    extends CompoundCondition {
        Equivalent(Condition condition2) {
            super(condition2);
        }

        public boolean isSatisfied(Object object) {
            return Condition.this.isSatisfied(object) == this.condition.isSatisfied(object);
        }
    }

    private class Implies
    extends CompoundCondition {
        Implies(Condition condition2) {
            super(condition2);
        }

        public boolean isSatisfied(Object object) {
            return !Condition.this.isSatisfied(object) || this.condition.isSatisfied(object);
        }
    }

    private class Or
    extends CompoundCondition {
        Or(Condition condition2) {
            super(condition2);
        }

        public boolean isSatisfied(Object object) {
            return Condition.this.isSatisfied(object) || this.condition.isSatisfied(object);
        }
    }

    private class XOr
    extends CompoundCondition {
        XOr(Condition condition2) {
            super(condition2);
        }

        public boolean isSatisfied(Object object) {
            return Condition.this.isSatisfied(object) ^ this.condition.isSatisfied(object);
        }
    }
}

