/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.export.svgextension;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.image.PartPositionInfo;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.export.GraphicsSVG;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderedImageDescriptor;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.export.Activator;
import org.eclipse.papyrus.uml.export.extension.AnnotateSVG;
import org.eclipse.papyrus.uml.export.svgextension.internal.OpenAPIDiagramSVGGenerator;
import org.eclipse.uml2.uml.NamedElement;
import org.w3c.dom.Element;

public class PapyrusDiagramSVGGenerator
extends OpenAPIDiagramSVGGenerator {
    private List<AnnotateSVG> annotations = new ArrayList<AnnotateSVG>();
    private RenderedImage renderedImage = null;
    private Element svgRoot = null;
    private Rectangle viewBox = null;

    public PapyrusDiagramSVGGenerator(DiagramEditPart diagramEditPart, List<AnnotateSVG> annotations) {
        super(diagramEditPart);
        this.annotations = annotations;
    }

    protected Graphics setUpGraphics(int width, int height) {
        this.viewBox = new Rectangle(0, 0, width, height);
        return GraphicsSVG.getInstance((Rectangle)this.viewBox);
    }

    protected ImageDescriptor getImageDescriptor(Graphics g) {
        try {
            Activator.log(1, "Start transformation from Graphics to image descriptor");
            GraphicsSVG svgG = (GraphicsSVG)g;
            this.svgRoot = svgG.getRoot();
            List allPartPositionInfo = this.getDiagramPartInfo();
            Collections.reverse(allPartPositionInfo);
            for (PartPositionInfo partPositionInfo : allPartPositionInfo) {
                boolean hasAnnotation;
                Element rectangle = svgG.getDocument().createElementNS("http://www.w3.org/2000/svg", "rect");
                if (partPositionInfo.getSemanticElement() instanceof NamedElement) {
                    NamedElement nameElement = (NamedElement)partPositionInfo.getSemanticElement();
                    rectangle.setAttributeNS(null, "id", nameElement.getName());
                }
                rectangle.setAttributeNS(null, "x", String.valueOf(partPositionInfo.getPartX()));
                rectangle.setAttributeNS(null, "y", String.valueOf(partPositionInfo.getPartY()));
                rectangle.setAttributeNS(null, "width", String.valueOf(partPositionInfo.getPartWidth()));
                rectangle.setAttributeNS(null, "height", String.valueOf(partPositionInfo.getPartHeight()));
                rectangle.setAttributeNS(null, "fill-opacity", "0");
                rectangle.setAttributeNS(null, "stroke-opacity", "0");
                View view = partPositionInfo.getView();
                if (!(view instanceof Shape) || !(hasAnnotation = this.applyAll(view, svgG, rectangle))) continue;
                this.svgRoot.appendChild(rectangle);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream(5000);
            this.stream(os);
            os.close();
            this.setRenderedImage(RenderedImageFactory.getInstance((byte[])os.toByteArray()));
            return RenderedImageDescriptor.createFromRenderedImage((RenderedImage)this.getRenderedImage());
        }
        catch (IOException ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public boolean applyAll(View view, GraphicsSVG svgG, Element rectangle) {
        boolean res = false;
        for (AnnotateSVG annotateSVG : this.annotations) {
            boolean bl = res = res || annotateSVG.addAnnotation(view, svgG, rectangle);
        }
        return true;
    }

    public void stream(OutputStream outputStream) {
        try {
            this.svgRoot.setAttributeNS(null, "viewBox", String.valueOf(String.valueOf(this.viewBox.x)) + " " + String.valueOf(this.viewBox.y) + " " + String.valueOf(this.viewBox.width) + " " + String.valueOf(this.viewBox.height));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.svgRoot);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public Image createAWTImageForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        this.createSWTImageDescriptorForParts(editparts, sourceRect);
        if (this.getRenderedImage() != null) {
            try {
                BufferedImage bufImg = (BufferedImage)this.getRenderedImage().getAdapter(BufferedImage.class);
                if (bufImg == null) {
                    bufImg = ImageConverter.convert((org.eclipse.swt.graphics.Image)this.getRenderedImage().getSWTImage());
                }
                return bufImg;
            }
            catch (Error e) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)e);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
            catch (Exception ex) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)ex);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
        }
        return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
    }

    public RenderedImage getRenderedImage() {
        return this.renderedImage;
    }

    private void setRenderedImage(RenderedImage renderedImage) {
        this.renderedImage = renderedImage;
    }
}

