/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellDisplayConversionUtils;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.search.command.SearchCommand;
import org.eclipse.nebula.widgets.nattable.search.event.SearchEvent;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.GridSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.SelectionSearchStrategy;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SearchDialog
extends Dialog {
    private NatTable natTable;
    private SelectionLayer selectionLayer;
    private Comparator<?> comparator;
    private Stack<SelectionItem> selections = new Stack();
    private IDialogSettings originalSettings;
    private IDialogSettings dialogSettings;
    private IDialogSettings dialogBounds;
    private Rectangle dialogPositionValue;
    private Combo findCombo;
    private List<String> findHistory = new ArrayList<String>(5);
    private Button forwardButton;
    private boolean forwardValue = true;
    private Button allButton;
    private boolean allValue = true;
    private Button selectionButton;
    private Button caseSensitiveButton;
    private boolean caseSensitiveValue;
    private Button wrapSearchButton;
    private boolean wrapSearchValue = true;
    private Button wholeWordButton;
    private boolean wholeWordValue;
    private Button incrementalButton;
    private boolean incrementalValue;
    private Button columnFirstButton;
    private boolean columnFirstValue;
    private Button regexButton;
    private boolean regexValue;
    private Label statusLabel;
    private Button findButton;
    private ModifyListener findComboModifyListener;

    public SearchDialog(Shell shell, Comparator<?> comparator, int style) {
        super(shell);
        this.comparator = comparator;
        this.setShellStyle(this.getShellStyle() ^ style);
        this.setBlockOnOpen(false);
    }

    public void setInput(NatTable natTable, IDialogSettings settings) {
        if (natTable != null && natTable.equals(this.natTable)) {
            return;
        }
        this.natTable = natTable;
        if (natTable != null) {
            ILayer result = this.findSelectionLayer(this.natTable.getLayer());
            if (result != null && result instanceof SelectionLayer) {
                this.selectionLayer = (SelectionLayer)result;
                if (this.findButton != null && !this.findButton.isDisposed()) {
                    this.findButton.setEnabled(true);
                }
            }
        } else {
            this.selectionLayer = null;
            if (this.findButton != null && !this.findButton.isDisposed()) {
                this.findButton.setEnabled(false);
            }
        }
        this.originalSettings = settings;
        if (settings == null) {
            this.dialogSettings = null;
            this.dialogBounds = null;
        } else {
            this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
            if (this.dialogSettings == null) {
                this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
            }
            String boundsName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
            this.dialogBounds = settings.getSection(boundsName);
            if (this.dialogBounds == null) {
                this.dialogBounds = settings.addNewSection(boundsName);
            }
        }
        this.readConfiguration();
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isModal() {
        return (this.getShellStyle() & 0x10000) != 0;
    }

    public NatTable getNatTable() {
        return this.natTable;
    }

    public IDialogSettings getOriginalDialogSettings() {
        return this.originalSettings;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.getString("Search.find"));
        if (this.dialogPositionValue != null) {
            this.getShell().setBounds(this.dialogPositionValue);
        }
        this.findCombo.removeModifyListener(this.findComboModifyListener);
        SearchDialog.updateCombo(this.findCombo, this.findHistory);
        this.findCombo.addModifyListener(this.findComboModifyListener);
        ILayer result = this.findSelectionLayer(this.natTable.getLayer());
        if (result != null && result instanceof SelectionLayer) {
            this.selectionLayer = (SelectionLayer)result;
        }
        PositionCoordinate pos = this.getPosition();
        String text = this.getTextForSelection(pos);
        this.selections.push(new SelectionItem(text, pos));
        this.findCombo.setText(text);
    }

    private ILayer findSelectionLayer(ILayer layer) {
        if (layer == null || layer instanceof SelectionLayer) {
            return layer;
        }
        if (layer instanceof CompositeLayer) {
            CompositeLayer composite = (CompositeLayer)layer;
            int x = composite.getLayoutXCount();
            while (x >= 0) {
                int y = composite.getLayoutYCount();
                while (y >= 0) {
                    ILayer childStack = composite.getChildLayerByLayoutCoordinate(x, y);
                    ILayer result = this.findSelectionLayer(childStack);
                    if (result instanceof SelectionLayer) {
                        return result;
                    }
                    --y;
                }
                --x;
            }
            return null;
        }
        return this.findSelectionLayer(layer.getUnderlyingLayerByPosition(0, 0));
    }

    private String getTextForSelection(PositionCoordinate selection) {
        if (this.selectionLayer == null || selection == null || selection.columnPosition == -1) {
            return "";
        }
        ILayerCell cell = this.selectionLayer.getCellByPosition(selection.columnPosition, selection.rowPosition);
        if (cell == null || cell.getDataValue() == null) {
            return "";
        }
        if (this.natTable != null) {
            return CellDisplayConversionUtils.convertDataType(cell, this.natTable.getConfigRegistry());
        }
        return cell.getDataValue().toString();
    }

    public boolean close() {
        this.storeSettings();
        return super.close();
    }

    private void storeSettings() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        this.dialogPositionValue = this.getShell().getBounds();
        this.forwardValue = this.forwardButton.getSelection();
        this.allValue = this.allButton.getSelection();
        this.caseSensitiveValue = this.caseSensitiveButton.getSelection();
        this.wrapSearchValue = this.wrapSearchButton.getSelection();
        this.wholeWordValue = this.wholeWordButton.getSelection();
        this.incrementalValue = this.incrementalButton.getSelection();
        this.regexValue = this.regexButton.getSelection();
        this.columnFirstValue = this.columnFirstButton.getSelection();
        this.writeConfiguration();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.createInputPanel(composite));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.createOptionsPanel(composite));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.createStatusPanel(composite));
        GridDataFactory.swtDefaults().align(4, 1024).grab(true, true).applyTo((Control)this.createButtonSection(composite));
        return composite;
    }

    private Composite createStatusPanel(Composite composite) {
        Composite panel = new Composite(composite, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.statusLabel = new Label(panel, 16384);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.statusLabel);
        return panel;
    }

    private Composite createButtonSection(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 16384);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        this.findButton = this.createButton(panel, 1024, Messages.getString("Search.findButtonLabel"), false);
        int buttonWidth = SearchDialog.getButtonWidthHint(this.findButton);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).hint(buttonWidth, -1).applyTo((Control)this.findButton);
        this.findButton.setEnabled(false);
        this.getShell().setDefaultButton(this.findButton);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.doFind();
            }
        });
        Button closeButton = this.createButton(panel, 1, Messages.getString("Search.closeButtonLabel"), false);
        buttonWidth = SearchDialog.getButtonWidthHint(closeButton);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).hint(buttonWidth, -1).applyTo((Control)closeButton);
        return panel;
    }

    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    private Composite createInputPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, false));
        Label findLabel = new Label(row, 0);
        findLabel.setText(String.valueOf(Messages.getString("Search.findLabel")) + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)findLabel);
        this.findCombo = new Combo(row, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.findCombo);
        this.findComboModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SearchDialog.this.allValue && SearchDialog.this.incrementalButton.isEnabled() && SearchDialog.this.incrementalButton.getSelection()) {
                    SearchDialog.this.doIncrementalFind();
                }
                SearchDialog.this.findButton.setEnabled(SearchDialog.this.findCombo.getText().length() > 0 && SearchDialog.this.selectionLayer != null);
            }
        };
        this.findCombo.addModifyListener(this.findComboModifyListener);
        this.findCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SearchDialog.this.findButton.isEnabled()) {
                    SearchDialog.this.doFind();
                }
            }
        });
        return row;
    }

    private Composite createOptionsPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, true));
        Group directionGroup = new Group(row, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)directionGroup);
        directionGroup.setText(Messages.getString("Search.direction"));
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginWidth = 3;
        rowLayout.marginHeight = 3;
        directionGroup.setLayout((Layout)rowLayout);
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(Messages.getString("Search.forwardButtonLabel"));
        this.forwardButton.setSelection(this.forwardValue);
        this.forwardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchDialog.this.incrementalButton.getSelection()) {
                    SearchDialog.this.resetIncrementalSelections();
                }
            }
        });
        Button backwardButton = new Button((Composite)directionGroup, 16);
        backwardButton.setText(Messages.getString("Search.backwardButtonLabel"));
        backwardButton.setSelection(!this.forwardValue);
        Group scopeGroup = new Group(row, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scopeGroup);
        scopeGroup.setText(Messages.getString("Search.scope"));
        rowLayout = new RowLayout(512);
        rowLayout.marginWidth = 3;
        rowLayout.marginHeight = 3;
        scopeGroup.setLayout((Layout)rowLayout);
        this.allButton = new Button((Composite)scopeGroup, 16);
        this.allButton.setText(Messages.getString("Search.allLabel"));
        this.allButton.setSelection(this.allValue);
        this.allButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.updateButtons();
            }
        });
        this.selectionButton = new Button((Composite)scopeGroup, 16);
        this.selectionButton.setText(Messages.getString("Search.selectionLabel"));
        this.selectionButton.setSelection(!this.allValue);
        Group optionsGroup = new Group(row, 16);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)optionsGroup);
        optionsGroup.setText(Messages.getString("Search.options"));
        optionsGroup.setLayout((Layout)new GridLayout(2, true));
        this.caseSensitiveButton = new Button((Composite)optionsGroup, 32);
        this.caseSensitiveButton.setText(Messages.getString("Search.caseSensitiveButtonLabel"));
        this.caseSensitiveButton.setSelection(this.caseSensitiveValue);
        this.wrapSearchButton = new Button((Composite)optionsGroup, 32);
        this.wrapSearchButton.setText(Messages.getString("Search.wrapSearchButtonLabel"));
        this.wrapSearchButton.setSelection(this.wrapSearchValue);
        this.wholeWordButton = new Button((Composite)optionsGroup, 32);
        this.wholeWordButton.setText(Messages.getString("Search.wholeWordButtonLabel"));
        this.wholeWordButton.setSelection(this.wholeWordValue);
        this.wholeWordButton.setEnabled(!this.regexValue);
        this.incrementalButton = new Button((Composite)optionsGroup, 32);
        this.incrementalButton.setText(Messages.getString("Search.incrementalButtonLabel"));
        this.incrementalButton.setSelection(this.incrementalValue);
        this.incrementalButton.setEnabled(!this.regexValue);
        this.incrementalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SearchDialog.this.incrementalButton.getSelection()) {
                    SearchDialog.this.resetIncrementalSelections();
                }
            }
        });
        this.regexButton = new Button((Composite)optionsGroup, 32);
        this.regexButton.setText(Messages.getString("Search.regexButtonLabel"));
        this.regexButton.setSelection(this.regexValue);
        this.regexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.updateButtons();
            }
        });
        this.columnFirstButton = new Button((Composite)optionsGroup, 32);
        this.columnFirstButton.setText(Messages.getString("Search.columnFirstLabel"));
        this.columnFirstButton.setSelection(this.columnFirstValue);
        return row;
    }

    private void doFind() {
        this.doFindInit();
        this.doFind0(false, this.findCombo.getText());
    }

    protected void doIncrementalFind() {
        this.doFindInit();
        String text = this.findCombo.getText();
        String lastText = this.selections.peek().text;
        if (lastText.startsWith(text)) {
            while (this.selections.size() > 1 && this.selections.peek().text.length() > text.length()) {
                this.selections.pop();
            }
            this.doSelect(this.selections.peek());
        } else {
            int pos;
            if (text.startsWith(lastText)) {
                pos = lastText.length();
            } else {
                pos = 0;
                this.resetIncrementalSelections();
            }
            if (this.wholeWordValue) {
                this.doFind0(true, text);
            } else {
                int i = pos;
                int n = text.length();
                while (i < n) {
                    this.doFind0(true, text.substring(0, i + 1));
                    ++i;
                }
            }
        }
    }

    private void doFindInit() {
        PositionCoordinate pos;
        this.statusLabel.setText("");
        this.statusLabel.setForeground(null);
        if (this.selectionLayer != null && !(pos = this.getPosition()).equals(this.selections.peek().pos)) {
            this.selections.clear();
            this.selections.push(new SelectionItem(this.getTextForSelection(pos), pos));
        }
    }

    private void doSelect(SelectionItem selection) {
        ILayerCommand command = selection.pos.columnPosition != -1 ? this.createSelectCellCommand(selection.pos) : new ClearAllSelectionsCommand();
        final ILayerCommand finalCommand = command;
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SearchDialog.this.natTable.doCommand(finalCommand);
            }
        });
    }

    private void doFind0(final boolean isIncremental, final String text) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PositionCoordinate previous = new PositionCoordinate(((SelectionItem)((SearchDialog)SearchDialog.this).selections.peek()).pos);
                try {
                    SearchCommand searchCommand = SearchDialog.this.createSearchCommand(text, isIncremental);
                    SearchEventListener searchEventListener = new SearchEventListener();
                    searchCommand.setSearchEventListener(searchEventListener);
                    SearchDialog.this.natTable.doCommand(searchCommand);
                    if (searchEventListener.pos == null) {
                        SearchDialog.this.statusLabel.setText(Messages.getString("Search.textNotFound"));
                        SearchDialog.this.getShell().getDisplay().beep();
                    } else {
                        SelectionItem selection = new SelectionItem(text, searchEventListener.pos);
                        SearchDialog.this.selections.push(selection);
                        if (!isIncremental) {
                            SearchDialog.this.resetIncrementalSelections();
                        }
                        if (previous != null && previous.columnPosition > -1) {
                            int secondaryDelta;
                            int columnDelta = selection.pos.columnPosition - previous.columnPosition;
                            int rowDelta = selection.pos.rowPosition - previous.rowPosition;
                            if (!SearchDialog.this.forwardValue) {
                                columnDelta = -columnDelta;
                                rowDelta = -rowDelta;
                            }
                            int primaryDelta = SearchDialog.this.columnFirstValue ? columnDelta : rowDelta;
                            int n = secondaryDelta = SearchDialog.this.columnFirstValue ? rowDelta : columnDelta;
                            if (primaryDelta < 0 || !isIncremental && primaryDelta == 0 && secondaryDelta <= 0) {
                                SearchDialog.this.statusLabel.setText(Messages.getString("Search.wrappedSearch"));
                                SearchDialog.this.getShell().getDisplay().beep();
                            }
                        }
                    }
                    if (!isIncremental) {
                        SearchDialog.this.updateFindHistory();
                    }
                }
                catch (PatternSyntaxException e) {
                    SearchDialog.this.statusLabel.setText(e.getLocalizedMessage());
                    SearchDialog.this.statusLabel.setForeground(JFaceColors.getErrorText((Display)SearchDialog.this.statusLabel.getDisplay()));
                    SearchDialog.this.getShell().getDisplay().beep();
                }
            }
        });
    }

    private PositionCoordinate getPosition() {
        if (this.selectionLayer == null) {
            return new PositionCoordinate(null, -1, -1);
        }
        PositionCoordinate pos = new PositionCoordinate(this.selectionLayer.getSelectionAnchor());
        if (this.selectionLayer.getSelectedCellPositions().length == 0 && pos.rowPosition != -1) {
            this.selectionLayer.clear(false);
            pos = new PositionCoordinate(this.selectionLayer.getSelectionAnchor());
        }
        return pos;
    }

    private void resetIncrementalSelections() {
        SelectionItem selection = this.selections.peek();
        this.selections.clear();
        this.selections.push(selection);
    }

    private SelectCellCommand createSelectCellCommand(PositionCoordinate selection) {
        SelectCellCommand selectCellCommand = new SelectCellCommand(selection.getLayer(), selection.columnPosition, selection.rowPosition, false, false);
        selectCellCommand.setForcingEntireCellIntoViewport(true);
        return selectCellCommand;
    }

    private SearchCommand createSearchCommand(String text, boolean isIncremental) {
        this.forwardValue = this.forwardButton.getSelection();
        this.allValue = this.allButton.getSelection();
        this.caseSensitiveValue = this.caseSensitiveButton.getSelection();
        this.wrapSearchValue = this.wrapSearchButton.getSelection();
        this.wholeWordValue = this.wholeWordButton.getSelection();
        this.incrementalValue = this.incrementalButton.getSelection();
        this.regexValue = this.regexButton.getSelection();
        this.columnFirstValue = this.columnFirstButton.getSelection();
        String searchDirection = this.forwardValue ? "forward" : "backwards";
        AbstractSearchStrategy searchStrategy = this.allValue ? new GridSearchStrategy(this.natTable.getConfigRegistry(), true, this.columnFirstValue) : new SelectionSearchStrategy(this.natTable.getConfigRegistry(), this.columnFirstValue);
        return new SearchCommand(text, this.natTable, searchStrategy, searchDirection, this.wrapSearchValue, this.caseSensitiveValue, !this.regexValue && this.wholeWordValue, !this.regexValue && this.allValue && isIncremental, this.regexValue, false, this.comparator);
    }

    private void updateFindHistory() {
        this.findCombo.removeModifyListener(this.findComboModifyListener);
        SearchDialog.updateHistory(this.findCombo, this.findHistory);
        this.findCombo.addModifyListener(this.findComboModifyListener);
    }

    private static void updateHistory(Combo findCombo, List<String> history) {
        String findString = findCombo.getText();
        int index = history.indexOf(findString);
        if (index == 0) {
            return;
        }
        if (index != -1) {
            history.remove(index);
        }
        history.add(0, findString);
        Point selection = findCombo.getSelection();
        SearchDialog.updateCombo(findCombo, history);
        findCombo.setText(findString);
        findCombo.setSelection(selection);
    }

    private static void updateCombo(Combo combo, List<String> content) {
        combo.removeAll();
        int i = 0;
        while (i < content.size()) {
            combo.add(content.get(i).toString());
            ++i;
        }
    }

    private void updateButtons() {
        boolean regex = this.regexButton.getSelection();
        boolean allMode = this.allButton.getSelection();
        this.wholeWordButton.setEnabled(!regex);
        this.incrementalButton.setEnabled(!regex && allMode);
    }

    private IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogBounds;
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        if (s == null) {
            return;
        }
        this.wrapSearchValue = s.get("wrap") == null || s.getBoolean("wrap");
        this.caseSensitiveValue = s.getBoolean("casesensitive");
        this.wholeWordValue = s.getBoolean("wholeword");
        this.incrementalValue = s.getBoolean("incremental");
        this.regexValue = s.getBoolean("isRegEx");
        this.columnFirstValue = s.getBoolean("columnFirst");
        String[] findHistoryConfig = s.getArray("findhistory");
        if (findHistoryConfig != null) {
            this.findHistory.clear();
            String[] stringArray = findHistoryConfig;
            int n = findHistoryConfig.length;
            int n2 = 0;
            while (n2 < n) {
                String history = stringArray[n2];
                this.findHistory.add(history);
                ++n2;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        if (s == null) {
            return;
        }
        s.put("wrap", this.wrapSearchValue);
        s.put("casesensitive", this.caseSensitiveValue);
        s.put("wholeword", this.wholeWordValue);
        s.put("incremental", this.incrementalValue);
        s.put("isRegEx", this.regexValue);
        s.put("columnFirst", this.columnFirstValue);
        String findString = this.findCombo.getText();
        if (findString.length() > 0) {
            this.findHistory.add(0, findString);
        }
        this.writeHistory(this.findHistory, s, "findhistory");
    }

    private void writeHistory(List<String> history, IDialogSettings settings, String sectionName) {
        int itemCount = history.size();
        HashSet<String> distinctItems = new HashSet<String>(itemCount);
        int i = 0;
        while (i < itemCount) {
            String item = history.get(i);
            if (distinctItems.contains(item)) {
                history.remove(i--);
                --itemCount;
            } else {
                distinctItems.add(item);
            }
            ++i;
        }
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        settings.put(sectionName, names);
    }

    private class SearchEventListener
    implements ILayerListener {
        private PositionCoordinate pos;

        private SearchEventListener() {
        }

        @Override
        public void handleLayerEvent(ILayerEvent event) {
            if (!(event instanceof SearchEvent)) {
                return;
            }
            SearchEvent searchEvent = (SearchEvent)event;
            this.pos = searchEvent.getCellCoordinate();
        }
    }

    private class SelectionItem {
        String text;
        PositionCoordinate pos;

        SelectionItem(String text, PositionCoordinate pos) {
            this.text = text;
            this.pos = new PositionCoordinate(pos);
        }
    }
}

