/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImagePainter
extends BackgroundPainter {
    private Image image;
    private final boolean paintBg;
    protected boolean calculateByWidth;
    protected boolean calculateByHeight;

    public ImagePainter() {
        this((Image)null);
    }

    public ImagePainter(Image image) {
        this(image, true);
    }

    public ImagePainter(boolean paintBg) {
        this.paintBg = paintBg;
    }

    public ImagePainter(Image image, boolean paintBg) {
        this.image = image;
        this.paintBg = paintBg;
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().width;
        }
        return 0;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            return image.getBounds().height;
        }
        return 0;
    }

    @Override
    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image = this.getImage(cell, configRegistry);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            int x0 = bounds.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, bounds, imageBounds.width);
            int y0 = bounds.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, bounds, imageBounds.height);
            if (x >= x0 && x < x0 + imageBounds.width && y >= y0 && y < y0 + imageBounds.height) {
                return super.getCellPainterAt(x, y, cell, gc, bounds, configRegistry);
            }
        }
        return null;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        Image image;
        if (this.paintBg) {
            super.paintCell(cell, gc, bounds, configRegistry);
        }
        if ((image = this.getImage(cell, configRegistry)) != null) {
            Rectangle imageBounds = image.getBounds();
            IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
            int contentHeight = imageBounds.height;
            if (this.calculateByHeight && contentHeight > bounds.height) {
                int contentToCellDiff = cell.getBounds().height - bounds.height;
                ILayer layer = cell.getLayer();
                layer.doCommand(new RowResizeCommand(layer, cell.getRowPosition(), contentHeight + contentToCellDiff));
            }
            int contentWidth = imageBounds.width;
            if (this.calculateByWidth && contentWidth > bounds.width) {
                int contentToCellDiff = cell.getBounds().width - bounds.width;
                ILayer layer = cell.getLayer();
                layer.doCommand(new ColumnResizeCommand(layer, cell.getColumnPosition(), contentWidth + contentToCellDiff));
            }
            gc.drawImage(image, bounds.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, bounds, imageBounds.width), bounds.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, bounds, imageBounds.height));
        }
    }

    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.image != null ? this.image : CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.IMAGE);
    }

    public boolean isCalculateByWidth() {
        return this.calculateByWidth;
    }

    public void setCalculateByWidth(boolean calculateByWidth) {
        this.calculateByWidth = calculateByWidth;
    }

    public boolean isCalculateByHeight() {
        return this.calculateByHeight;
    }

    public void setCalculateByHeight(boolean calculateByHeight) {
        this.calculateByHeight = calculateByHeight;
    }
}

