/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;

public class ConfigureScalingCommandHandler
implements ILayerCommandHandler<ConfigureScalingCommand> {
    private final SizeConfig columnWidthConfig;
    private final SizeConfig rowHeightConfig;

    public ConfigureScalingCommandHandler(SizeConfig columnWidthConfig, SizeConfig rowHeightConfig) {
        this.columnWidthConfig = columnWidthConfig;
        this.rowHeightConfig = rowHeightConfig;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, ConfigureScalingCommand command) {
        if (this.columnWidthConfig != null) {
            this.columnWidthConfig.setDpiConverter(command.getHorizontalDpiConverter());
        }
        if (this.rowHeightConfig != null) {
            this.rowHeightConfig.setDpiConverter(command.getVerticalDpiConverter());
        }
        return false;
    }

    @Override
    public Class<ConfigureScalingCommand> getCommandClass() {
        return ConfigureScalingCommand.class;
    }
}

