/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.LinkedList;
import java.util.List;

public class LabelStack {
    private final List<String> labels = new LinkedList<String>();

    public LabelStack(String ... labelNames) {
        String[] stringArray = labelNames;
        int n = labelNames.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            if (label != null) {
                this.labels.add(label);
            }
            ++n2;
        }
    }

    public void addLabel(String label) {
        if (!this.hasLabel(label)) {
            this.labels.add(label);
        }
    }

    public void addLabelOnTop(String label) {
        if (!this.hasLabel(label)) {
            this.labels.add(0, label);
        }
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    public boolean removeLabel(String label) {
        return this.labels.remove(label);
    }

    public String toString() {
        return this.labels.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LabelStack)) {
            return false;
        }
        LabelStack that = (LabelStack)obj;
        return this.labels.equals(that.labels);
    }

    public int hashCode() {
        return this.labels.hashCode();
    }
}

