/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeHelper;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.IFreezeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeCommandHandler;
import org.eclipse.nebula.widgets.nattable.freeze.config.DefaultFreezeGridBindings;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommandHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeFreezeLayer
extends CompositeLayer
implements IUniqueIndexLayer {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;
    private final ILayerPainter layerPainter = new FreezableLayerPainter();

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, true);
    }

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
        this.setChildLayer("FROZEN_REGION", freezeLayer, 0, 0);
        this.setChildLayer("FROZEN_ROW_REGION", new DimensionallyDependentIndexLayer(viewportLayer.getScrollableLayer(), viewportLayer, freezeLayer), 1, 0);
        this.setChildLayer("FROZEN_COLUMN_REGION", new DimensionallyDependentIndexLayer(viewportLayer.getScrollableLayer(), freezeLayer, viewportLayer), 0, 1);
        this.setChildLayer("NONFROZEN_REGION", viewportLayer, 1, 1);
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultFreezeGridBindings());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof RowStructuralChangeEvent && (((RowStructuralChangeEvent)event).getRowDiffs() == null || ((RowStructuralChangeEvent)event).getRowDiffs().isEmpty()) && this.viewportLayer.getMinimumOriginRowPosition() < this.freezeLayer.getRowCount()) {
            this.viewportLayer.setMinimumOriginY(this.freezeLayer.getHeight());
        }
        if (event instanceof ColumnStructuralChangeEvent && (((ColumnStructuralChangeEvent)event).getColumnDiffs() == null || ((ColumnStructuralChangeEvent)event).getColumnDiffs().isEmpty())) {
            if (this.viewportLayer.getMinimumOriginColumnPosition() < this.freezeLayer.getColumnCount()) {
                this.viewportLayer.setMinimumOriginX(this.freezeLayer.getWidth());
            }
        } else if (event instanceof ColumnResizeEvent && this.freezeLayer.getColumnCount() == this.selectionLayer.getColumnCount() && this.viewportLayer.getMinimumOriginColumnPosition() < this.freezeLayer.getColumnCount()) {
            this.viewportLayer.setMinimumOriginX(this.freezeLayer.getWidth());
        }
        super.handleLayerEvent(event);
    }

    public boolean isFrozen() {
        return this.freezeLayer.isFrozen();
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new FreezeCommandHandler(this.freezeLayer, this.viewportLayer, this.selectionLayer));
        DimensionallyDependentIndexLayer frozenRowLayer = (DimensionallyDependentIndexLayer)this.getChildLayerByLayoutCoordinate(1, 0);
        frozenRowLayer.registerCommandHandler(new ViewportSelectRowCommandHandler(frozenRowLayer));
        DimensionallyDependentIndexLayer frozenColumnLayer = (DimensionallyDependentIndexLayer)this.getChildLayerByLayoutCoordinate(0, 1);
        frozenColumnLayer.registerCommandHandler(new ViewportSelectColumnCommandHandler(frozenColumnLayer));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            this.viewportLayer.doCommand(command);
        }
        return super.doCommand(command);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        int columnPosition = this.freezeLayer.getColumnPositionByIndex(columnIndex);
        if (columnPosition >= 0) {
            return columnPosition;
        }
        return this.freezeLayer.getColumnCount() + this.viewportLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        int rowPosition = this.freezeLayer.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        return this.freezeLayer.getRowCount() + this.viewportLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        PositionCoordinate coord = this.freezeLayer.getTopLeftPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeTopLeftPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        coord = this.freezeLayer.getBottomRightPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeBottomRightPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + ".freezeTopLeftPosition");
        PositionCoordinate topLeftPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            topLeftPosition = new PositionCoordinate(this.freezeLayer, Integer.valueOf(columnPosition), Integer.valueOf(rowPosition));
        }
        property = properties.getProperty(String.valueOf(prefix) + ".freezeBottomRightPosition");
        PositionCoordinate bottomRightPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            bottomRightPosition = new PositionCoordinate(this.freezeLayer, Integer.valueOf(columnPosition), Integer.valueOf(rowPosition));
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            if (topLeftPosition.columnPosition == -1 && topLeftPosition.rowPosition == -1 && bottomRightPosition.columnPosition == -1 && bottomRightPosition.rowPosition == -1) {
                FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
            } else {
                FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
            }
        }
        super.loadState(prefix, properties);
    }

    class FreezableLayerPainter
    extends CompositeLayer.CompositeLayerPainter {
        @Override
        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
            int freezeHeight;
            super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            Color separatorColor = configRegistry.getConfigAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, "NORMAL", new String[0]);
            if (separatorColor == null) {
                separatorColor = GUIHelper.COLOR_BLUE;
            }
            gc.setClipping(rectangle);
            Color oldFg = gc.getForeground();
            gc.setForeground(separatorColor);
            int freezeWidth = CompositeFreezeLayer.this.freezeLayer.getWidth() - 1;
            if (freezeWidth > 0) {
                gc.drawLine(xOffset + freezeWidth, yOffset, xOffset + freezeWidth, yOffset + CompositeFreezeLayer.this.getHeight() - 1);
            }
            if ((freezeHeight = CompositeFreezeLayer.this.freezeLayer.getHeight() - 1) > 0) {
                gc.drawLine(xOffset, yOffset + freezeHeight, xOffset + CompositeFreezeLayer.this.getWidth() - 1, yOffset + freezeHeight);
            }
            gc.setForeground(oldFg);
        }
    }
}

