/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.coordinate.IndexCoordinate;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractMathSingleValueFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractSingleValueFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.AverageFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.BigDecimalFunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.ModFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.MultipleValueFunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.NegateFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.OperatorFunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.PowerFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.ProductFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.QuotientFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.SquareRootFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.StringFunctionValue;
import org.eclipse.nebula.widgets.nattable.formula.function.SumFunction;

public class FormulaParser {
    public static final String operatorRegex = "[-+/*\\^]";
    public static final String digitRegex = "[\\d]+";
    public static final String placeholderRegex = "\\{[\\d]+\\}";
    public static final String operatorSplitRegex = "((?<=[-+/*\\^\\s])|(?=[-+/*\\^\\s]))";
    public static final String referenceRegex = "[A-Z]+[0-9]+";
    public static final String referenceRangeRegex = "[A-Z]+[0-9]+:[A-Z]+[0-9]+";
    public static final String columnRangeRegex = "[A-Z]+:[A-Z]+";
    public static final String rowRangeRegex = "[\\d]+:[\\d]+";
    public static final String rangeRegex = "([A-Z]+[0-9]+:[A-Z]+[0-9]+|[A-Z]+:[A-Z]+|[\\d]+:[\\d]+)";
    protected DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
    protected String localizedDigitRegex;
    protected String functionRegex;
    protected Pattern functionPattern;
    protected Pattern referencePattern = Pattern.compile("[A-Z]+[0-9]+");
    protected Map<String, Class<? extends AbstractFunction>> functionMapping = new HashMap<String, Class<? extends AbstractFunction>>();
    protected IDataProvider dataProvider;

    public FormulaParser(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.initFunctions();
        this.updateLocalizedDigitRegex();
    }

    public void registerFunction(String functionName, Class<? extends AbstractFunction> value) {
        this.functionMapping.put(functionName, value);
        this.updateFunctionRegex();
    }

    public Collection<String> getRegisteredFunctions() {
        return this.functionMapping.keySet();
    }

    protected void initFunctions() {
        this.functionMapping.put("AVERAGE", AverageFunction.class);
        this.functionMapping.put("MOD", ModFunction.class);
        this.functionMapping.put("NEGATE", NegateFunction.class);
        this.functionMapping.put("POWER", PowerFunction.class);
        this.functionMapping.put("PRODUCT", ProductFunction.class);
        this.functionMapping.put("QUOTIENT", QuotientFunction.class);
        this.functionMapping.put("SQRT", SquareRootFunction.class);
        this.functionMapping.put("SUM", SumFunction.class);
        this.updateFunctionRegex();
    }

    protected void updateFunctionRegex() {
        StringBuilder builder = new StringBuilder("(");
        Iterator<String> it = this.functionMapping.keySet().iterator();
        while (it.hasNext()) {
            String functionName = it.next();
            builder.append(functionName);
            if (!it.hasNext()) continue;
            builder.append("|");
        }
        builder.append(")\\(");
        this.functionRegex = builder.toString();
        this.functionPattern = Pattern.compile(this.functionRegex);
    }

    public FunctionValue parseFunction(String function) {
        return this.parseFunction(function, new HashMap<Integer, FunctionValue>(), new LinkedHashMap<IndexCoordinate, Set<IndexCoordinate>>(), null);
    }

    protected FunctionValue parseFunction(String function, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences, IndexCoordinate referer) {
        return this.parseFunction(function, new HashMap<Integer, FunctionValue>(), parsedReferences, referer);
    }

    protected FunctionValue parseFunction(String function, Map<Integer, FunctionValue> replacements, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences, IndexCoordinate referer) {
        function = this.getFunctionOnly(function);
        String processedFunction = this.processFunctions(function, replacements, parsedReferences, referer);
        processedFunction = this.processParenthesis(processedFunction, replacements, parsedReferences, referer);
        String[] operandsAndOperators = processedFunction.split(operatorSplitRegex);
        List<FunctionValue> values = new ArrayList<FunctionValue>(operandsAndOperators.length);
        int i = 0;
        while (i < operandsAndOperators.length) {
            String part = operandsAndOperators[i].trim();
            if (part.matches(operatorRegex)) {
                if ("-".equals(part)) {
                    values.add(new NegateFunction());
                } else if ("+".equals(part)) {
                    values.add(new SumFunction());
                } else if ("*".equals(part)) {
                    values.add(new ProductFunction());
                } else if ("/".equals(part)) {
                    values.add(new QuotientFunction());
                } else if ("^".equals(part)) {
                    values.add(new PowerFunction());
                }
            } else if (part.matches(rangeRegex)) {
                int tmp;
                MultipleValueFunctionValue multi = new MultipleValueFunctionValue();
                String[] parts = part.split(":");
                if (part.matches(referenceRangeRegex)) {
                    int[] from = this.evaluateReference(parts[0]);
                    int[] to = this.evaluateReference(parts[1]);
                    int fromColumn = Math.min(from[0], to[0]);
                    int toColumn = Math.max(from[0], to[0]);
                    int fromRow = Math.min(from[1], to[1]);
                    int toRow = Math.max(from[1], to[1]);
                    int row = fromRow;
                    while (row <= toRow) {
                        int column = fromColumn;
                        while (column <= toColumn) {
                            this.addDataProviderValue(column, row, (List<FunctionValue>)multi.getValue(), parsedReferences, referer);
                            ++column;
                        }
                        ++row;
                    }
                } else if (part.matches(rowRangeRegex)) {
                    int to;
                    int from = Integer.valueOf(parts[0]) - 1;
                    if (from > (to = Integer.valueOf(parts[1]) - 1)) {
                        tmp = to;
                        to = from;
                        from = tmp;
                    }
                    int row = from;
                    while (row <= to) {
                        int column = 0;
                        while (column < this.getUnderlyingColumnCount()) {
                            this.addDataProviderValue(column, row, (List<FunctionValue>)multi.getValue(), parsedReferences, referer);
                            ++column;
                        }
                        ++row;
                    }
                } else if (part.matches(columnRangeRegex)) {
                    int to;
                    int from = this.getColumnIndex(parts[0]);
                    if (from > (to = this.getColumnIndex(parts[1]))) {
                        tmp = to;
                        to = from;
                        from = tmp;
                    }
                    int column = from;
                    while (column <= to) {
                        int row = 0;
                        while (row < this.getUnderlyingRowCount()) {
                            this.addDataProviderValue(column, row, (List<FunctionValue>)multi.getValue(), parsedReferences, referer);
                            ++row;
                        }
                        ++column;
                    }
                }
                values.add(multi);
            } else if (part.matches(referenceRegex)) {
                int[] coords = this.evaluateReference(part);
                this.addDataProviderValue(coords[0], coords[1], values, parsedReferences, referer);
            } else if (part.matches(placeholderRegex)) {
                String number = part.substring(1, part.length() - 1);
                try {
                    values.add(replacements.get(Integer.valueOf(number)));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(Messages.getString("FormulaParser.error.replacement"), e);
                }
            } else if (part.matches(this.localizedDigitRegex)) {
                if (values.size() > 0 && values.get(values.size() - 1) instanceof BigDecimalFunctionValue) {
                    throw new IllegalArgumentException(Messages.getString("FormulaParser.error.missingOperator"));
                }
                values.add(new BigDecimalFunctionValue(this.convertToBigDecimal(part.trim())));
            } else {
                String s = part.trim();
                if (s.length() > 0) {
                    values.add(new StringFunctionValue(s));
                }
            }
            ++i;
        }
        int parts = 0;
        while ((parts = values.size()) != (values = this.processMultiplicationAndDivision(values)).size()) {
        }
        return this.combineFunctions(values);
    }

    protected String processFunctions(String function, Map<Integer, FunctionValue> replacements, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences, IndexCoordinate referer) {
        StringBuilder result = new StringBuilder();
        int startIndex = 0;
        Matcher functionMatcher = this.functionPattern.matcher(function);
        while (functionMatcher.find(startIndex)) {
            String[] parameter;
            String functionName = null;
            String parameterString = null;
            int openParanthesisCount = 0;
            int i = functionMatcher.start();
            while (i < function.length()) {
                char c = function.charAt(i);
                if (c == '(') {
                    if (i > 0 && ++openParanthesisCount == 1) {
                        result.append(function.substring(startIndex, functionMatcher.start()));
                        functionName = function.substring(functionMatcher.start(), i);
                        startIndex = i;
                    }
                } else if (c == ')') {
                    if (--openParanthesisCount < 0) {
                        throw new IllegalArgumentException(Messages.getString("FormulaParser.error.functionParameterNotOpened"));
                    }
                    if (openParanthesisCount == 0) {
                        parameterString = function.substring(startIndex + 1, i);
                        startIndex = i + 1;
                        break;
                    }
                }
                ++i;
            }
            if (openParanthesisCount != 0) {
                throw new IllegalArgumentException(Messages.getString("FormulaParser.error.functionParameterNotClosed"));
            }
            Class<? extends AbstractFunction> functionClass = this.functionMapping.get(functionName);
            if (functionClass == null) {
                throw new IllegalArgumentException("No function '" + functionName + "' registered");
            }
            AbstractFunction fv = null;
            try {
                fv = functionClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(Messages.getString("FormulaParser.error.instantiation", e.getLocalizedMessage()), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(Messages.getString("FormulaParser.error.instantiation", e.getLocalizedMessage()), e);
            }
            HashMap<Integer, FunctionValue> nestedReplacements = new HashMap<Integer, FunctionValue>();
            parameterString = this.processFunctions(parameterString, nestedReplacements, parsedReferences, referer);
            String[] stringArray = parameter = parameterString.split(";");
            int n = parameter.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                fv.addFunctionValue(this.parseFunction(param, nestedReplacements, parsedReferences, referer));
                ++n2;
            }
            Integer pos = replacements.size();
            replacements.put(pos, fv);
            result.append("{").append(pos).append("}");
        }
        if (startIndex < function.length()) {
            result.append(function.substring(startIndex, function.length()));
        }
        return result.toString();
    }

    protected String processParenthesis(String function, Map<Integer, FunctionValue> replacements, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences, IndexCoordinate referer) {
        StringBuilder result = new StringBuilder();
        int openParanthesisCount = 0;
        int startIndex = 0;
        int i = 0;
        while (i < function.length()) {
            char c = function.charAt(i);
            if (c == '(') {
                if (i > 0 && ++openParanthesisCount == 1) {
                    result.append(function.substring(startIndex, i));
                    startIndex = i;
                }
            } else if (c == ')') {
                if (--openParanthesisCount < 0) {
                    throw new IllegalArgumentException(Messages.getString("FormulaParser.error.parenthesisNotOpened"));
                }
                if (openParanthesisCount == 0) {
                    String paranthesisFunctionString = function.substring(startIndex + 1, i);
                    FunctionValue paranthesisFunction = this.parseFunction(paranthesisFunctionString, parsedReferences, referer);
                    Integer pos = replacements.size();
                    replacements.put(pos, paranthesisFunction);
                    result.append("{").append(pos).append("}");
                    startIndex = i + 1;
                }
            }
            ++i;
        }
        if (startIndex < function.length()) {
            result.append(function.substring(startIndex, function.length()));
        }
        if (openParanthesisCount != 0) {
            throw new IllegalArgumentException(Messages.getString("FormulaParser.error.parenthesisNotClosed"));
        }
        return result.toString();
    }

    protected List<FunctionValue> processMultiplicationAndDivision(List<FunctionValue> values) {
        ArrayList<FunctionValue> result = new ArrayList<FunctionValue>();
        boolean operatorFound = false;
        Iterator<FunctionValue> it = values.iterator();
        while (it.hasNext()) {
            FunctionValue v = it.next();
            if (!operatorFound && it.hasNext() && result.size() > 0 && (v instanceof ProductFunction || v instanceof QuotientFunction || v instanceof PowerFunction) && ((AbstractFunction)v).isEmpty()) {
                FunctionValue previous = (FunctionValue)result.remove(result.size() - 1);
                ((OperatorFunctionValue)((Object)v)).addFunctionValue(previous);
                FunctionValue next = it.next();
                if (next instanceof NegateFunction) {
                    ((NegateFunction)next).addFunctionValue(it.next());
                }
                ((OperatorFunctionValue)((Object)v)).addFunctionValue(next);
                operatorFound = true;
                result.add(v);
                continue;
            }
            result.add(v);
        }
        return result;
    }

    protected FunctionValue combineFunctions(List<FunctionValue> values) {
        FunctionValue result = null;
        if (values.size() == 1) {
            result = values.get(0);
        } else {
            int i = 0;
            while (i < values.size()) {
                FunctionValue v = values.get(i);
                if (v instanceof AbstractSingleValueFunction || v instanceof AbstractMathSingleValueFunction) {
                    ((AbstractFunction)v).addFunctionValue(values.get(++i));
                    if (result != null && v instanceof NegateFunction) {
                        SumFunction sum = new SumFunction();
                        sum.addFunctionValue(result);
                        sum.addFunctionValue(v);
                        result = sum;
                    } else {
                        result = v;
                    }
                } else if (v instanceof OperatorFunctionValue) {
                    if (i > 0 && result == null) {
                        ((OperatorFunctionValue)((Object)v)).addFunctionValue(values.get(i - 1));
                    } else if (result != null) {
                        ((OperatorFunctionValue)((Object)v)).addFunctionValue(result);
                    }
                    if (i > 0 && ++i < values.size()) {
                        ((OperatorFunctionValue)((Object)v)).addFunctionValue(values.get(i));
                    }
                    result = v;
                } else {
                    result = v;
                }
                ++i;
            }
        }
        return result;
    }

    protected int[] evaluateReference(String reference) {
        String columnString = "";
        String rowString = "";
        int i = 0;
        while (i < reference.length()) {
            char c = reference.charAt(i);
            if (Character.isLetter(c)) {
                columnString = String.valueOf(columnString) + c;
            } else if (Character.isDigit(c)) {
                rowString = String.valueOf(rowString) + c;
            }
            ++i;
        }
        int column = this.getColumnIndex(columnString);
        int row = Integer.valueOf(rowString) - 1;
        return new int[]{column, row};
    }

    protected int getColumnIndex(String columnLiteral) {
        int column = 0;
        int pos = 0;
        int i = columnLiteral.length() - 1;
        while (i >= 0) {
            char c = columnLiteral.charAt(i);
            column = (int)((double)column + (double)(c - (pos == 0 ? 65 : 64)) * Math.pow(26.0, pos));
            ++pos;
            --i;
        }
        return column;
    }

    protected String convertIndexToColumnString(int index) {
        int characterAddition = 65;
        int quotient = index;
        int remainder = 0;
        String result = "";
        do {
            remainder = quotient % 26;
            result = String.valueOf(Character.toString((char)(remainder + characterAddition))) + result;
            characterAddition = 64;
        } while ((quotient /= 26) != 0);
        return result;
    }

    protected void addDataProviderValue(int column, int row, List<FunctionValue> values, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences, IndexCoordinate referer) {
        Object value = this.getUnderlyingDataValue(column, row);
        if (value != null) {
            IndexCoordinate ref;
            String toParse = value.toString();
            if (value instanceof Number) {
                toParse = this.decimalFormat.format(value);
            }
            if (!parsedReferences.containsKey(ref = new IndexCoordinate(column, row))) {
                parsedReferences.put(ref, new HashSet());
            }
            if (referer != null) {
                parsedReferences.get(referer).add(ref);
            }
            if (this.detectCycle(parsedReferences)) {
                throw new FunctionException("#REF!", Messages.getString("FormulaParser.error.circular"));
            }
            FunctionValue parseResult = this.parseFunction(toParse, parsedReferences, ref);
            if (parseResult != null) {
                values.add(parseResult);
            }
        }
    }

    protected void updateLocalizedDigitRegex() {
        this.localizedDigitRegex = "[\\d]+(\\" + this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator() + digitRegex + ")?";
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.decimalFormat = format;
        this.updateLocalizedDigitRegex();
    }

    public boolean isFunction(String function) {
        return function.startsWith("=");
    }

    public String getFunctionOnly(String function) {
        if (function.startsWith("=")) {
            function = function.substring(1);
        }
        return function;
    }

    public boolean isNumber(String value) {
        return value.matches(this.localizedDigitRegex);
    }

    public boolean isIntegerValue(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public BigDecimal convertToBigDecimal(String value) {
        value = value.replaceAll("\\" + this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator(), ".");
        return new BigDecimal(value);
    }

    protected int getUnderlyingColumnCount() {
        return this.dataProvider.getColumnCount();
    }

    protected int getUnderlyingRowCount() {
        return this.dataProvider.getRowCount();
    }

    protected Object getUnderlyingDataValue(int column, int row) {
        return this.dataProvider.getDataValue(column, row);
    }

    public String updateReferences(String function, int fromColumn, int fromRow, int toColumn, int toRow) {
        int columnDiff = toColumn - fromColumn;
        int rowDiff = toRow - fromRow;
        Matcher referenceMatcher = this.referencePattern.matcher(function);
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (referenceMatcher.find()) {
            result.append(function.substring(start, referenceMatcher.start()));
            String reference = function.substring(referenceMatcher.start(), referenceMatcher.end());
            int[] coords = this.evaluateReference(reference);
            coords[0] = coords[0] + columnDiff;
            coords[1] = coords[1] + rowDiff;
            if (coords[0] < 0 || coords[1] + 1 < 0) {
                throw new FunctionException("#REF!", Messages.getString("FormulaParser.error.referenceNotExist"));
            }
            String newReference = String.valueOf(this.convertIndexToColumnString(coords[0])) + (coords[1] + 1);
            result.append(newReference);
            start = referenceMatcher.end();
        }
        if (start < function.length()) {
            result.append(function.substring(start));
        }
        return result.toString();
    }

    protected boolean detectCycle(Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences) {
        HashSet<IndexCoordinate> initPath = new HashSet<IndexCoordinate>();
        for (Map.Entry<IndexCoordinate, Set<IndexCoordinate>> entry : parsedReferences.entrySet()) {
            if (!this.isCyclic(new Node(entry.getKey(), entry.getValue()), initPath, parsedReferences)) continue;
            return true;
        }
        return false;
    }

    private boolean isCyclic(Node currNode, Set<IndexCoordinate> path, Map<IndexCoordinate, Set<IndexCoordinate>> parsedReferences) {
        if (currNode != null) {
            if (path.contains(currNode.referer)) {
                return true;
            }
            if (!currNode.references.isEmpty()) {
                path.add(currNode.referer);
                for (IndexCoordinate node : currNode.references) {
                    if (this.isCyclic(new Node(node, parsedReferences.get(node)), path, parsedReferences)) {
                        return true;
                    }
                    path.remove(node);
                }
            }
        }
        return false;
    }

    class Node {
        IndexCoordinate referer;
        Set<IndexCoordinate> references;

        public Node(IndexCoordinate referer, Set<IndexCoordinate> references) {
            this.referer = referer;
            this.references = references;
        }
    }
}

