/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

public class ParseResult {
    private MatchType matchType = MatchType.NONE;
    private String valueToMatch;

    public MatchType getMatchOperation() {
        return this.matchType;
    }

    public String getValueToMatch() {
        return this.valueToMatch;
    }

    public void setMatchType(MatchType matchType) {
        this.matchType = matchType;
    }

    public void setValueToMatch(String valueToMatch) {
        this.valueToMatch = valueToMatch;
    }

    public static enum MatchType {
        EQUAL("="),
        NOT_EQUAL("<>"),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        LESS_THAN_OR_EQUAL("<="),
        LESS_THAN("<"),
        NONE("");

        private String symbol;

        private MatchType(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public static MatchType parse(String symbol) {
            if ("=".equals(symbol)) {
                return EQUAL;
            }
            if ("<>".equals(symbol)) {
                return NOT_EQUAL;
            }
            if (">".equals(symbol)) {
                return GREATER_THAN;
            }
            if ("<".equals(symbol)) {
                return LESS_THAN;
            }
            if (">=".equals(symbol)) {
                return GREATER_THAN_OR_EQUAL;
            }
            if ("<=".equals(symbol)) {
                return LESS_THAN_OR_EQUAL;
            }
            return NONE;
        }
    }
}

