/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories.gui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.nattable.columnCategories.ColumnCategoriesModel;
import org.eclipse.nebula.widgets.nattable.columnCategories.Node;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class AvailableColumnCategoriesProvider
implements ITreeContentProvider {
    private final ColumnCategoriesModel model;
    private List<String> hiddenIndexes = new ArrayList<String>();

    public AvailableColumnCategoriesProvider(ColumnCategoriesModel model) {
        this.model = model;
    }

    public void hideEntries(List<ColumnEntry> entriesToHide) {
        for (ColumnEntry hiddenColumnEntry : entriesToHide) {
            this.hiddenIndexes.add(String.valueOf(hiddenColumnEntry.getIndex()));
        }
    }

    public Object[] getChildren(Object parentElement) {
        return this.getFilteredChildren(this.castToNode(parentElement).getChildren()).toArray();
    }

    public Object getParent(Object element) {
        return this.castToNode(element).getParent();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return ObjectUtils.isNull(this.model.getRootCategory()) ? new Object[]{} : this.getFilteredChildren(this.model.getRootCategory().getChildren()).toArray();
    }

    private List<Node> getFilteredChildren(List<Node> allChildren) {
        ArrayList<Node> children = new ArrayList<Node>(allChildren);
        for (Node child : allChildren) {
            if (!this.hiddenIndexes.contains(child.getData())) continue;
            children.remove(child);
        }
        return children;
    }

    private Node castToNode(Object element) {
        return (Node)element;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

