/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Node
implements Serializable {
    private static final long serialVersionUID = 7855L;
    private Type type;
    private String data;
    private List<Node> children;
    private Node parent;

    public Node(String data) {
        this(data, Type.UNKNOWN);
    }

    public Node(String newCategoryName, Type type) {
        this.setData(newCategoryName);
        this.setType(type);
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public List<Node> getChildren() {
        if (this.children == null) {
            return new ArrayList<Node>();
        }
        return this.children;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Node addChild(Node child) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        this.children.add(child);
        child.setParent(this);
        return child;
    }

    public Node addChildCategory(String categoryName) {
        return this.addChild(new Node(categoryName, Type.CATEGORY));
    }

    public void addChildColumnIndexes(int ... columnIndexes) {
        int[] nArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndex = nArray[n2];
            this.addChild(new Node(String.valueOf(columnIndex), Type.COLUMN));
            ++n2;
        }
    }

    public void insertChildAt(int index, Node child) throws IndexOutOfBoundsException {
        if (index == this.getNumberOfChildren()) {
            this.addChild(child);
            return;
        }
        this.children.get(index);
        this.children.add(index, child);
    }

    public void removeChildAt(int index) throws IndexOutOfBoundsException {
        this.children.remove(index);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append((Object)this.type).append(",").append(this.getData().toString()).append(",[");
        int i = 0;
        for (Node e : this.getChildren()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(e.getData().toString());
            ++i;
        }
        sb.append("]").append("}");
        return sb.toString();
    }

    public static enum Type {
        ROOT,
        COLUMN,
        CATEGORY,
        UNKNOWN;

    }
}

