/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.DiagramGridSpec;

public class SlidableSnapToGridAnchor
extends SlidableAnchor {
    private EditPartViewer myGridProvider;
    private boolean myGetLocationReentryLock = false;

    public SlidableSnapToGridAnchor(NodeFigure f, PrecisionPoint p) {
        super((IFigure)f, p);
    }

    public void setEditPartViewer(EditPartViewer viewer) {
        this.myGridProvider = viewer;
    }

    public Point getOrthogonalLocation(Point orthoReference) {
        Point result = this.getOrthogonalLocationNoSnap(orthoReference);
        if (result != null) {
            Rectangle gridSpecAbs = this.getAbsoluteGridSpec();
            LinkedList<Point> onVerticalGrid = new LinkedList<Point>();
            LinkedList<Point> onHorizontalGrid = new LinkedList<Point>();
            this.computeAnchorablePointsOnGrid(gridSpecAbs, onVerticalGrid, onHorizontalGrid);
            if (!onHorizontalGrid.isEmpty() || !onVerticalGrid.isEmpty()) {
                return SlidableSnapToGridAnchor.pickClosestPointToSet(result, onHorizontalGrid, onVerticalGrid);
            }
        }
        return result;
    }

    public Point getLocation(Point reference) {
        Rectangle gridSpecAbs = this.getAbsoluteGridSpec();
        if (gridSpecAbs != null && !this.myGetLocationReentryLock) {
            this.myGetLocationReentryLock = true;
            try {
                LinkedList<Point> onVerticalGrid = new LinkedList<Point>();
                LinkedList<Point> onHorizontalGrid = new LinkedList<Point>();
                this.computeAnchorablePointsOnGrid(gridSpecAbs, onVerticalGrid, onHorizontalGrid);
                if (!onVerticalGrid.isEmpty() || !onVerticalGrid.isEmpty()) {
                    Point point = SlidableSnapToGridAnchor.pickClosestPointToSet(this.getReferencePoint(), onHorizontalGrid, onVerticalGrid);
                    return point;
                }
            }
            finally {
                this.myGetLocationReentryLock = false;
            }
        }
        Point result = super.getLocation(reference);
        return result;
    }

    protected Point normalizeToStraightlineTolerance(Point foreignReference, Point ownReference, int tolerance) {
        boolean NO_TOLERANCE = false;
        return super.normalizeToStraightlineTolerance(foreignReference, ownReference, 0);
    }

    public String toString() {
        return "SSTGA:terminal: " + this.getTerminal() + ", terminalLoc: " + this.getReferencePoint() + ", box: " + this.getBox();
    }

    @Deprecated
    public static int getClosestSide2(Point p, Rectangle r) {
        double diff = Math.abs(r.preciseX() + r.preciseWidth() - p.preciseX());
        int side = 4;
        double currentDiff = Math.abs(r.preciseX() - p.preciseX());
        if (currentDiff < diff) {
            diff = currentDiff;
            side = 1;
        }
        if ((currentDiff = Math.abs(r.preciseY() + r.preciseHeight() - p.preciseY())) < diff) {
            diff = currentDiff;
            side = 32;
        }
        if ((currentDiff = Math.abs(r.preciseY() - p.preciseY())) < diff) {
            diff = currentDiff;
            side = 8;
        }
        return side;
    }

    protected Rectangle getAbsoluteGridSpec() {
        return this.myGridProvider == null ? null : DiagramGridSpec.getAbsoluteGridSpec(this.myGridProvider);
    }

    protected static Point pickClosestPointToSet(Point source, Collection<? extends Point> set1, Collection<? extends Point> set2) {
        double nextDistSquared;
        double bestDistSquared = Double.MAX_VALUE;
        Point result = null;
        for (Point point : set1) {
            nextDistSquared = source.getDistance(point);
            if (!(nextDistSquared < bestDistSquared)) continue;
            result = point;
            bestDistSquared = nextDistSquared;
        }
        for (Point point : set2) {
            nextDistSquared = source.getDistance(point);
            if (!(nextDistSquared < bestDistSquared)) continue;
            result = point;
            bestDistSquared = nextDistSquared;
        }
        return result;
    }

    protected void computeAnchorablePointsOnGrid(Rectangle gridSpecAbs, List<Point> onVerticalGridLocs, List<Point> onHorizontalGridLocs) {
        Point onGridForRightRef;
        Point onGridForLeftRef;
        Point onGridForBelowRef;
        Point onGridForAboveRef;
        if (gridSpecAbs == null) {
            return;
        }
        double gridX = gridSpecAbs.preciseWidth();
        double gridY = gridSpecAbs.preciseWidth();
        Point gridOrigin = gridSpecAbs.getLocation();
        PrecisionRectangle bounds = new PrecisionRectangle(FigureUtilities.getAnchorableFigureBounds((IFigure)this.getOwner()));
        this.getOwner().translateToAbsolute((Translatable)bounds);
        Point notOnGrid = bounds.getCenter();
        PrecisionPoint fakeRefAbove = new PrecisionPoint(notOnGrid);
        PrecisionPoint fakeRefBelow = new PrecisionPoint(notOnGrid);
        fakeRefAbove.setPreciseY(bounds.preciseY() - bounds.preciseHeight() / 2.0);
        fakeRefBelow.setPreciseY(bounds.preciseY() + bounds.preciseHeight() / 2.0 + bounds.preciseHeight());
        double reminderX = Math.IEEEremainder(notOnGrid.preciseX() - gridOrigin.preciseX(), gridX);
        if (reminderX < 0.0) {
            reminderX += gridX;
        }
        double nextX = notOnGrid.preciseX() - reminderX;
        while (nextX >= bounds.preciseX()) {
            fakeRefAbove.setPreciseX(nextX);
            fakeRefBelow.setPreciseX(nextX);
            onGridForAboveRef = this.getOrthogonalLocationNoSnap((Point)fakeRefAbove);
            onGridForBelowRef = this.getOrthogonalLocationNoSnap((Point)fakeRefBelow);
            onVerticalGridLocs.add(onGridForAboveRef);
            if (!onGridForBelowRef.equals((Object)onGridForAboveRef)) {
                onVerticalGridLocs.add(onGridForBelowRef);
            }
            nextX -= gridX;
        }
        nextX = gridX + notOnGrid.preciseX() - reminderX;
        while (nextX <= bounds.preciseX() + bounds.preciseWidth()) {
            fakeRefAbove.setPreciseX(nextX);
            fakeRefBelow.setPreciseX(nextX);
            onGridForAboveRef = this.getOrthogonalLocationNoSnap((Point)fakeRefAbove);
            onGridForBelowRef = this.getOrthogonalLocationNoSnap((Point)fakeRefBelow);
            onVerticalGridLocs.add(onGridForAboveRef);
            if (!onGridForBelowRef.equals((Object)onGridForAboveRef)) {
                onVerticalGridLocs.add(onGridForBelowRef);
            }
            nextX += gridX;
        }
        PrecisionPoint fakeRefLeft = new PrecisionPoint(notOnGrid);
        PrecisionPoint fakeRefRight = new PrecisionPoint(notOnGrid);
        fakeRefLeft.setPreciseX(bounds.preciseX() - bounds.preciseWidth() / 2.0);
        fakeRefRight.setPreciseX(bounds.preciseX() + bounds.preciseWidth() + bounds.preciseWidth() / 2.0);
        double reminderY = Math.IEEEremainder(notOnGrid.preciseY() - gridOrigin.preciseY(), gridY);
        if (reminderY < 0.0) {
            reminderY += gridY;
        }
        double nextY = notOnGrid.preciseY() - reminderY;
        while (nextY >= bounds.preciseY()) {
            fakeRefLeft.setPreciseY(nextY);
            fakeRefRight.setPreciseY(nextY);
            onGridForLeftRef = this.getOrthogonalLocationNoSnap((Point)fakeRefLeft);
            onGridForRightRef = this.getOrthogonalLocationNoSnap((Point)fakeRefRight);
            onHorizontalGridLocs.add(onGridForLeftRef);
            if (!onGridForLeftRef.equals((Object)onGridForRightRef)) {
                onHorizontalGridLocs.add(onGridForRightRef);
            }
            nextY -= gridY;
        }
        nextY = gridY + notOnGrid.preciseY() - reminderY;
        while (nextY <= bounds.preciseY() + bounds.preciseHeight()) {
            fakeRefLeft.setPreciseY(nextY);
            fakeRefRight.setPreciseY(nextY);
            onGridForLeftRef = this.getOrthogonalLocationNoSnap((Point)fakeRefLeft);
            onGridForRightRef = this.getOrthogonalLocationNoSnap((Point)fakeRefRight);
            onHorizontalGridLocs.add(onGridForLeftRef);
            if (!onGridForLeftRef.equals((Object)onGridForRightRef)) {
                onHorizontalGridLocs.add(onGridForRightRef);
            }
            nextY += gridY;
        }
    }

    protected Point getOrthogonalLocationNoSnap(Point refPoint) {
        return super.getOrthogonalLocation(refPoint);
    }
}

