/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.sync.SyncKind;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class SyncStyles {
    private static final String SYNC_STYLE_NAME = "papyrus-diagram-sync";
    private static final String SYNC_EXCLUDED_FEATURES_NAME = "papyrus-sync-exclude";

    private SyncStyles() {
    }

    static NamedStyle getSyncStyle(View view) {
        return view.getNamedStyle(NotationPackage.Literals.STRING_VALUE_STYLE, SYNC_STYLE_NAME);
    }

    public static SyncKind getSyncKind(View view) {
        SyncKind result = SyncKind.NONE;
        NamedStyle style = view.getNamedStyle(NotationPackage.Literals.STRING_VALUE_STYLE, SYNC_STYLE_NAME);
        if (style != null) {
            result = SyncKind.forStyle(style);
        }
        return result;
    }

    public static View getMaster(NamedStyle slaveStyle) {
        View result = null;
        if (slaveStyle instanceof EObjectValueStyle) {
            result = (View)TypeUtils.as((Object)((EObjectValueStyle)slaveStyle).getEObjectValue(), View.class);
        }
        return result;
    }

    public static void clearSync(View view) {
        NamedStyle syncStyle = SyncStyles.getSyncStyle(view);
        if (syncStyle != null) {
            EcoreUtil.remove((EObject)syncStyle);
        }
    }

    public static NamedStyle setSync(View view) {
        return SyncStyles.setSync(view, SyncKind.PEER);
    }

    private static NamedStyle setSync(View view, SyncKind kind) {
        StringValueStyle result = null;
        SyncStyles.clearSync(view);
        if (kind != SyncKind.NONE) {
            result = (StringValueStyle)view.createStyle(NotationPackage.Literals.STRING_VALUE_STYLE);
            result.setName(SYNC_STYLE_NAME);
            result.setStringValue(kind.styleKey());
        }
        return result;
    }

    public static NamedStyle setSyncMaster(View view) {
        return SyncStyles.setSync(view, SyncKind.MASTER);
    }

    public static NamedStyle setSyncSlave(View view) {
        return SyncStyles.setSync(view, SyncKind.SLAVE);
    }

    public static Command getSyncCommand(final View view, final SyncKind kind) {
        return new AbstractCommand("Configure Synchronization"){
            private SyncKind previousKind;

            protected boolean prepare() {
                this.previousKind = SyncStyles.getSyncKind(view);
                return true;
            }

            public void execute() {
                SyncStyles.setSync(view, kind);
            }

            public void undo() {
                SyncStyles.setSync(view, this.previousKind);
            }

            public void redo() {
                SyncStyles.setSync(view, kind);
            }
        };
    }

    public static List<String> getExcludedFeatures(View view) {
        StringListValueStyle style = SyncStyles.getExcludedFeaturesStyle(view);
        return style == null ? Collections.emptyList() : Collections.unmodifiableList(style.getStringListValue());
    }

    public static boolean isSynchronized(View view, String feature) {
        StringListValueStyle style = SyncStyles.getExcludedFeaturesStyle(view);
        return style == null || !style.getStringListValue().contains((Object)feature);
    }

    public static void setExcluded(View view, String feature, boolean excluded) {
        StringListValueStyle style = SyncStyles.getExcludedFeaturesStyle(view);
        if (!excluded) {
            if (style != null) {
                style.getStringListValue().remove((Object)feature);
                if (style.getStringListValue().isEmpty()) {
                    EcoreUtil.remove((EObject)style);
                }
            }
        } else {
            if (style == null) {
                style = SyncStyles.createExcludedFeaturesStyle(view);
            }
            if (!style.getStringListValue().contains((Object)feature)) {
                style.getStringListValue().add((Object)feature);
            }
        }
    }

    static StringListValueStyle getExcludedFeaturesStyle(View view) {
        return (StringListValueStyle)view.getNamedStyle(NotationPackage.Literals.STRING_LIST_VALUE_STYLE, SYNC_EXCLUDED_FEATURES_NAME);
    }

    static StringListValueStyle createExcludedFeaturesStyle(View view) {
        StringListValueStyle result = (StringListValueStyle)view.createStyle(NotationPackage.Literals.STRING_LIST_VALUE_STYLE);
        result.setName(SYNC_EXCLUDED_FEATURES_NAME);
        return result;
    }

    public static Command createSetExcludedCommand(final View view, final String feature, final boolean excluded) {
        return new CompoundCommand("Set view synchronization"){
            private final EditingDomain domain;
            private StringListValueStyle style;
            {
                super($anonymous0);
                this.domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)view2);
            }

            protected boolean prepare() {
                this.prepareCommand();
                return super.prepare();
            }

            void prepareCommand() {
                this.style = SyncStyles.getExcludedFeaturesStyle(view);
                if (this.style != null) {
                    if (this.style.getStringListValue().contains((Object)feature)) {
                        if (!excluded) {
                            this.append(RemoveCommand.create((EditingDomain)this.domain, (Object)this.style, (Object)NotationPackage.Literals.STRING_LIST_VALUE_STYLE__STRING_LIST_VALUE, (Object)feature));
                        }
                    } else if (excluded) {
                        this.append(AddCommand.create((EditingDomain)this.domain, (Object)this.style, (Object)NotationPackage.Literals.STRING_LIST_VALUE_STYLE__STRING_LIST_VALUE, (Object)feature));
                    }
                } else if (excluded) {
                    this.style = NotationFactory.eINSTANCE.createStringListValueStyle();
                    this.style.setName(SyncStyles.SYNC_EXCLUDED_FEATURES_NAME);
                    this.style.getStringListValue().add((Object)feature);
                    this.append(AddCommand.create((EditingDomain)this.domain, (Object)view, (Object)NotationPackage.Literals.VIEW__STYLES, (Object)this.style));
                }
            }

            public void execute() {
                super.execute();
                if (this.style.eContainer() != view) {
                    this.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)view, (Object)NotationPackage.Literals.VIEW__STYLES, (Object)this.style));
                } else if (this.style.getStringListValue().isEmpty()) {
                    this.appendAndExecute(RemoveCommand.create((EditingDomain)this.domain, (Object)this.style));
                }
            }
        };
    }
}

